/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.signing;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.zip.signer.metadata.SignatureAlgorithm;
import org.jetbrains.zip.signer.signing.SignatureProvider;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/zip/signer/signing/DefaultSignatureProvider;", "Lorg/jetbrains/zip/signer/signing/SignatureProvider;", "signatureAlgorithm", "Lorg/jetbrains/zip/signer/metadata/SignatureAlgorithm;", "privateKey", "Ljava/security/PrivateKey;", "(Lorg/jetbrains/zip/signer/metadata/SignatureAlgorithm;Ljava/security/PrivateKey;)V", "jcaSignatureAlgorithm", "", "signature", "Ljava/security/Signature;", "kotlin.jvm.PlatformType", "getSignatureAlgorithm", "()Lorg/jetbrains/zip/signer/metadata/SignatureAlgorithm;", "sign", "", "dataToSign", "lib"})
public final class DefaultSignatureProvider
implements SignatureProvider {
    private final String jcaSignatureAlgorithm;
    private final Signature signature;
    @NotNull
    private final SignatureAlgorithm signatureAlgorithm;
    private final PrivateKey privateKey;

    @Override
    @NotNull
    public byte[] sign(@NotNull byte[] dataToSign) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)dataToSign, (String)"dataToSign");
        try {
            object = this.signature;
            boolean bl = false;
            boolean bl2 = false;
            Signature $this$with = object;
            boolean bl3 = false;
            $this$with.initSign(this.privateKey);
            $this$with.update(dataToSign);
            byte[] byArray = $this$with.sign();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"with(signature) {\n      \u2026     sign()\n            }");
            object = byArray;
        }
        catch (InvalidKeyException e) {
            throw (Throwable)new InvalidKeyException("Failed to sign using " + this.jcaSignatureAlgorithm, e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw (Throwable)new SignatureException("Failed to sign using " + this.jcaSignatureAlgorithm, e);
        }
        catch (SignatureException e) {
            throw (Throwable)new SignatureException("Failed to sign using " + this.jcaSignatureAlgorithm, e);
        }
        return object;
    }

    @Override
    @NotNull
    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public DefaultSignatureProvider(@NotNull SignatureAlgorithm signatureAlgorithm, @NotNull PrivateKey privateKey) {
        Intrinsics.checkNotNullParameter((Object)((Object)signatureAlgorithm), (String)"signatureAlgorithm");
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        this.signatureAlgorithm = signatureAlgorithm;
        this.privateKey = privateKey;
        this.jcaSignatureAlgorithm = this.getSignatureAlgorithm().getJcaSignatureAlgorithm();
        this.signature = Signature.getInstance(this.jcaSignatureAlgorithm);
    }
}

