/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.signing;

import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.zip.signer.metadata.Digest;
import org.jetbrains.zip.signer.metadata.SignatureAlgorithm;
import org.jetbrains.zip.signer.metadata.SignatureData;
import org.jetbrains.zip.signer.metadata.SignerBlock;
import org.jetbrains.zip.signer.signing.SignatureProvider;
import org.jetbrains.zip.signer.verifier.DefaultSignatureVerifier;
import org.jetbrains.zip.signer.verifier.SignatureVerifier;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a,\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bH\u0000\u00a8\u0006\u000e"}, d2={"generateSignatureOverData", "", "digest", "Lorg/jetbrains/zip/signer/metadata/Digest;", "signatureProvider", "Lorg/jetbrains/zip/signer/signing/SignatureProvider;", "signatureVerifier", "Lorg/jetbrains/zip/signer/verifier/SignatureVerifier;", "generateSignerBlock", "Lorg/jetbrains/zip/signer/metadata/SignerBlock;", "certificates", "", "Ljava/security/cert/X509Certificate;", "contentDigests", "lib"})
public final class SigningKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SignerBlock generateSignerBlock(@NotNull List<? extends X509Certificate> certificates, @NotNull SignatureProvider signatureProvider, @NotNull List<Digest> contentDigests) {
        X509Certificate x509Certificate;
        SignatureAlgorithm signatureAlgorithm;
        List encodedCertificates;
        block4: {
            Iterable $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(certificates, (String)"certificates");
            Intrinsics.checkNotNullParameter((Object)signatureProvider, (String)"signatureProvider");
            Intrinsics.checkNotNullParameter(contentDigests, (String)"contentDigests");
            if (certificates.isEmpty()) {
                throw (Throwable)new SignatureException("No certificates configured for signer");
            }
            Iterable $this$map$iv = certificates;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                X509Certificate x509Certificate2 = (X509Certificate)item$iv$iv;
                Collection collection = destination$iv$iv22;
                boolean bl = false;
                byte[] byArray = it.getEncoded();
                collection.add(byArray);
            }
            encodedCertificates = (List)destination$iv$iv22;
            signatureAlgorithm = signatureProvider.getSignatureAlgorithm();
            $this$mapTo$iv$iv = contentDigests;
            boolean destination$iv$iv22 = false;
            Iterable iterable2 = $this$mapTo$iv$iv;
            boolean bl = false;
            for (X509Certificate x509Certificate2 : iterable2) {
                Digest it = (Digest)((Object)x509Certificate2);
                boolean bl2 = false;
                if (!(it.getAlgorithm() == signatureAlgorithm.getContentDigestAlgorithm())) continue;
                x509Certificate = x509Certificate2;
                break block4;
            }
            x509Certificate = null;
        }
        Digest digest = (Digest)((Object)x509Certificate);
        if (digest == null) {
            throw (Throwable)new RuntimeException((Object)((Object)signatureAlgorithm.getContentDigestAlgorithm()) + " content digest not computed");
        }
        Digest digest2 = digest;
        DefaultSignatureVerifier signatureVerifier = new DefaultSignatureVerifier(certificates, signatureAlgorithm);
        SignatureData signature = new SignatureData(signatureAlgorithm, SigningKt.generateSignatureOverData(digest2, signatureProvider, signatureVerifier));
        return new SignerBlock(encodedCertificates, CollectionsKt.listOf((Object)signature));
    }

    private static final byte[] generateSignatureOverData(Digest digest, SignatureProvider signatureProvider, SignatureVerifier signatureVerifier) {
        byte[] signatureBytes = signatureProvider.sign(digest.getDigestBytes());
        signatureVerifier.verify(digest.getDigestBytes(), signatureBytes);
        return signatureBytes;
    }
}

