/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.metadata;

import com.google.protobuf.ByteString;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.zip.signer.metadata.ContentDigestAlgorithm;
import org.jetbrains.zip.signer.proto.DigestProto;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u001f\b\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/zip/signer/metadata/Digest;", "", "protobufRepresentation", "Lorg/jetbrains/zip/signer/proto/DigestProto;", "(Lorg/jetbrains/zip/signer/proto/DigestProto;)V", "algorithm", "Lorg/jetbrains/zip/signer/metadata/ContentDigestAlgorithm;", "digestBytes", "", "(Lorg/jetbrains/zip/signer/metadata/ContentDigestAlgorithm;[B)V", "(Lorg/jetbrains/zip/signer/metadata/ContentDigestAlgorithm;[BLorg/jetbrains/zip/signer/proto/DigestProto;)V", "getAlgorithm", "()Lorg/jetbrains/zip/signer/metadata/ContentDigestAlgorithm;", "getDigestBytes", "()[B", "getProtobufRepresentation", "()Lorg/jetbrains/zip/signer/proto/DigestProto;", "lib"})
public final class Digest {
    @NotNull
    private final ContentDigestAlgorithm algorithm;
    @NotNull
    private final byte[] digestBytes;
    @NotNull
    private final DigestProto protobufRepresentation;

    private Digest(ContentDigestAlgorithm algorithm, byte[] digestBytes, DigestProto protobufRepresentation) {
        this.algorithm = algorithm;
        this.digestBytes = digestBytes;
        this.protobufRepresentation = protobufRepresentation;
    }

    @NotNull
    public final ContentDigestAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    @NotNull
    public final byte[] getDigestBytes() {
        return this.digestBytes;
    }

    @NotNull
    public final DigestProto getProtobufRepresentation() {
        return this.protobufRepresentation;
    }

    public Digest(@NotNull DigestProto protobufRepresentation) {
        Intrinsics.checkNotNullParameter(protobufRepresentation, "protobufRepresentation");
        DigestProto.AlgorithmId algorithmId = protobufRepresentation.getAlgorithmId();
        Intrinsics.checkNotNullExpressionValue(algorithmId, "protobufRepresentation.algorithmId");
        ContentDigestAlgorithm contentDigestAlgorithm = ContentDigestAlgorithm.Companion.fromProtobufEnum(algorithmId);
        byte[] byArray = protobufRepresentation.getDigestBytes().toByteArray();
        Intrinsics.checkNotNullExpressionValue(byArray, "protobufRepresentation.digestBytes.toByteArray()");
        this(contentDigestAlgorithm, byArray, protobufRepresentation);
    }

    public Digest(@NotNull ContentDigestAlgorithm algorithm, @NotNull byte[] digestBytes) {
        Intrinsics.checkNotNullParameter((Object)algorithm, "algorithm");
        Intrinsics.checkNotNullParameter(digestBytes, "digestBytes");
        DigestProto digestProto = DigestProto.newBuilder().setAlgorithmId(algorithm.toProtobufEnum()).setDigestBytes(ByteString.copyFrom(digestBytes)).build();
        Intrinsics.checkNotNullExpressionValue(digestProto, "newBuilder()\n           \u2026es))\n            .build()");
        this(algorithm, digestBytes, digestProto);
    }
}

