/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.signer;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/zip/signer/signer/SignerInfo;", "", "certificates", "", "Ljava/security/cert/X509Certificate;", "privateKey", "Ljava/security/PrivateKey;", "(Ljava/util/List;Ljava/security/PrivateKey;)V", "getCertificates", "()Ljava/util/List;", "getPrivateKey", "()Ljava/security/PrivateKey;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "lib"})
public final class SignerInfo {
    @NotNull
    private final List<X509Certificate> certificates;
    @NotNull
    private final PrivateKey privateKey;

    public SignerInfo(@NotNull List<? extends X509Certificate> certificates, @NotNull PrivateKey privateKey) {
        Intrinsics.checkNotNullParameter(certificates, "certificates");
        Intrinsics.checkNotNullParameter(privateKey, "privateKey");
        this.certificates = certificates;
        this.privateKey = privateKey;
        if (!(!((Collection)this.certificates).isEmpty())) {
            boolean bl = false;
            String string = "Could not find certificates";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final List<X509Certificate> getCertificates() {
        return this.certificates;
    }

    @NotNull
    public final PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @NotNull
    public final List<X509Certificate> component1() {
        return this.certificates;
    }

    @NotNull
    public final PrivateKey component2() {
        return this.privateKey;
    }

    @NotNull
    public final SignerInfo copy(@NotNull List<? extends X509Certificate> certificates, @NotNull PrivateKey privateKey) {
        Intrinsics.checkNotNullParameter(certificates, "certificates");
        Intrinsics.checkNotNullParameter(privateKey, "privateKey");
        return new SignerInfo(certificates, privateKey);
    }

    public static /* synthetic */ SignerInfo copy$default(SignerInfo signerInfo, List list, PrivateKey privateKey, int n, Object object) {
        if ((n & 1) != 0) {
            list = signerInfo.certificates;
        }
        if ((n & 2) != 0) {
            privateKey = signerInfo.privateKey;
        }
        return signerInfo.copy(list, privateKey);
    }

    @NotNull
    public String toString() {
        return "SignerInfo(certificates=" + this.certificates + ", privateKey=" + this.privateKey + ')';
    }

    public int hashCode() {
        int result = ((Object)this.certificates).hashCode();
        result = result * 31 + this.privateKey.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SignerInfo)) {
            return false;
        }
        SignerInfo signerInfo = (SignerInfo)other;
        if (!Intrinsics.areEqual(this.certificates, signerInfo.certificates)) {
            return false;
        }
        return Intrinsics.areEqual(this.privateKey, signerInfo.privateKey);
    }
}

