/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.verifier;

import java.security.cert.X509Certificate;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.zip.signer.verifier.ZipVerificationResult;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\u0006\u0010\t\u001a\u00020\u0004J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0004R\u001d\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/zip/signer/verifier/SuccessfulVerificationResult;", "Lorg/jetbrains/zip/signer/verifier/ZipVerificationResult;", "certificateChains", "", "Ljava/security/cert/X509Certificate;", "(Ljava/util/List;)V", "getCertificateChains", "()Ljava/util/List;", "findCertificateChain", "certificateAuthority", "isSignedBy", "", "lib"})
public final class SuccessfulVerificationResult
extends ZipVerificationResult {
    @NotNull
    private final List<List<X509Certificate>> certificateChains;

    public SuccessfulVerificationResult(@NotNull List<? extends List<? extends X509Certificate>> certificateChains) {
        Intrinsics.checkNotNullParameter(certificateChains, "certificateChains");
        super(null);
        this.certificateChains = certificateChains;
    }

    @NotNull
    public final List<List<X509Certificate>> getCertificateChains() {
        return this.certificateChains;
    }

    public final boolean isSignedBy(@NotNull X509Certificate certificateAuthority) {
        Intrinsics.checkNotNullParameter(certificateAuthority, "certificateAuthority");
        return this.findCertificateChain(certificateAuthority) != null;
    }

    @Nullable
    public final List<X509Certificate> findCertificateChain(@NotNull X509Certificate certificateAuthority) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(certificateAuthority, "certificateAuthority");
            Iterable iterable = this.certificateChains;
            for (Object t : iterable) {
                List it = (List)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(CollectionsKt.last(it), certificateAuthority)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }
}

