/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.datasource;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.zip.signer.datasource.DataSource;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0006\u001a\u00020\u0005H\u0016J\u0018\u0010\f\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J \u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/zip/signer/datasource/SeekableByteChannelDataSource;", "Lorg/jetbrains/zip/signer/datasource/DataSource;", "channel", "Ljava/nio/channels/SeekableByteChannel;", "offset", "", "size", "<init>", "(Ljava/nio/channels/SeekableByteChannel;JLjava/lang/Long;)V", "getSize", "()Ljava/lang/Long;", "Ljava/lang/Long;", "slice", "feed", "", "writableByteChannel", "Ljava/nio/channels/WritableByteChannel;", "copyTo", "", "dest", "Ljava/nio/ByteBuffer;", "getByteBuffer", "Companion", "lib"})
public final class SeekableByteChannelDataSource
implements DataSource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SeekableByteChannel channel;
    private final long offset;
    @Nullable
    private final Long size;
    private static final int MAX_READ_CHUNK_SIZE = 0x100000;

    public SeekableByteChannelDataSource(@NotNull SeekableByteChannel channel, long offset, @Nullable Long size) {
        Intrinsics.checkNotNullParameter(channel, "channel");
        this.channel = channel;
        this.offset = offset;
        this.size = size;
        if (this.offset < 0L) {
            throw new IndexOutOfBoundsException("offset: " + this.size);
        }
        if (this.size != null && this.size < 0L) {
            throw new IndexOutOfBoundsException("size: " + this.size);
        }
    }

    public /* synthetic */ SeekableByteChannelDataSource(SeekableByteChannel seekableByteChannel, long l, Long l2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = 0L;
        }
        if ((n & 4) != 0) {
            l2 = null;
        }
        this(seekableByteChannel, l, l2);
    }

    @Nullable
    public final Long getSize() {
        return this.size;
    }

    @Override
    public long size() {
        Long l = this.size;
        return l != null ? l.longValue() : this.channel.size();
    }

    @Override
    @NotNull
    public SeekableByteChannelDataSource slice(long offset, long size) {
        long sourceSize = this.size();
        SeekableByteChannelDataSource.Companion.checkChunkValid(offset, size, sourceSize);
        return offset == 0L && size == sourceSize ? this : new SeekableByteChannelDataSource(this.channel, this.offset + offset, size);
    }

    @Override
    public void feed(@NotNull WritableByteChannel writableByteChannel, long offset, long size) {
        int chunkSize;
        long remaining;
        Intrinsics.checkNotNullParameter(writableByteChannel, "writableByteChannel");
        long sourceSize = this.size();
        SeekableByteChannelDataSource.Companion.checkChunkValid(offset, size, sourceSize);
        if (size == 0L) {
            return;
        }
        long chunkOffsetInFile = this.offset + offset;
        ByteBuffer buf = ByteBuffer.allocateDirect(RangesKt.coerceAtMost((int)remaining, 0x100000));
        for (remaining = size; remaining > 0L; remaining -= (long)chunkSize) {
            int read;
            buf.limit(chunkSize);
            this.channel.position(chunkOffsetInFile);
            for (int chunkRemaining = chunkSize = (int)RangesKt.coerceAtMost(remaining, (long)buf.capacity()); chunkRemaining > 0; chunkRemaining -= read) {
                read = this.channel.read(buf);
                if (read >= 0) continue;
                throw new IOException("Unexpected EOF encountered");
            }
            buf.flip();
            writableByteChannel.write(buf);
            buf.clear();
            chunkOffsetInFile += (long)chunkSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyTo(long offset, int size, @NotNull ByteBuffer dest) {
        Intrinsics.checkNotNullParameter(dest, "dest");
        long sourceSize = this.size();
        SeekableByteChannelDataSource.Companion.checkChunkValid(offset, size, sourceSize);
        if (size == 0) {
            return;
        }
        if (size > dest.remaining()) {
            throw new BufferOverflowException();
        }
        long offsetInFile = this.offset + offset;
        int prevLimit = dest.limit();
        try {
            int chunkSize;
            dest.limit(dest.position() + size);
            for (int remaining = size; remaining > 0; remaining -= chunkSize) {
                this.channel.position(offsetInFile);
                chunkSize = this.channel.read(dest);
                offsetInFile += (long)chunkSize;
            }
        }
        finally {
            dest.limit(prevLimit);
        }
    }

    @Override
    @NotNull
    public ByteBuffer getByteBuffer(long offset, int size) {
        if (size < 0) {
            throw new IndexOutOfBoundsException("size: " + size);
        }
        ByteBuffer result = ByteBuffer.allocate(size);
        Intrinsics.checkNotNull(result);
        this.copyTo(offset, size, result);
        result.flip();
        return result;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/zip/signer/datasource/SeekableByteChannelDataSource$Companion;", "", "<init>", "()V", "MAX_READ_CHUNK_SIZE", "", "checkChunkValid", "", "offset", "", "size", "sourceSize", "lib"})
    public static final class Companion {
        private Companion() {
        }

        private final void checkChunkValid(long offset, long size, long sourceSize) {
            long endOffset = offset + size;
            if (offset < 0L) {
                throw new IndexOutOfBoundsException("offset: " + offset);
            }
            if (size < 0L) {
                throw new IndexOutOfBoundsException("size: " + size);
            }
            if (offset > sourceSize) {
                throw new IndexOutOfBoundsException("offset (" + offset + ") > source size (" + sourceSize + ')');
            }
            if (endOffset < offset) {
                throw new IndexOutOfBoundsException("offset (" + offset + ") + size (" + size + ") overflow");
            }
            if (endOffset > sourceSize) {
                throw new IndexOutOfBoundsException("offset (" + offset + ") + size (" + size + ") > source size (" + sourceSize + ')');
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

