/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.metadata;

import com.google.protobuf.GeneratedMessageV3;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.ExperimentalUnsignedTypes;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.zip.signer.datasource.DataSource;
import org.jetbrains.zip.signer.metadata.Digest;
import org.jetbrains.zip.signer.metadata.SignerBlock;
import org.jetbrains.zip.signer.proto.DigestProto;
import org.jetbrains.zip.signer.proto.SignerBlockProto;
import org.jetbrains.zip.signer.proto.ZipMetadataProto;
import org.jetbrains.zip.signer.proto.ZipSignatureBlockProto;
import org.jetbrains.zip.signer.zip.ZipSectionsInformation;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0001\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B#\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007B+\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0012\u001a\u00020\u0013R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/zip/signer/metadata/ZipMetadata;", "", "digests", "", "Lorg/jetbrains/zip/signer/metadata/Digest;", "signers", "Lorg/jetbrains/zip/signer/metadata/SignerBlock;", "(Ljava/util/List;Ljava/util/List;)V", "protobufRepresentation", "Lorg/jetbrains/zip/signer/proto/ZipMetadataProto;", "(Ljava/util/List;Ljava/util/List;Lorg/jetbrains/zip/signer/proto/ZipMetadataProto;)V", "getDigests", "()Ljava/util/List;", "getSigners", "size", "", "getSize", "()I", "toByteArray", "", "Companion", "lib"})
@ExperimentalUnsignedTypes
public final class ZipMetadata {
    private final int size;
    @NotNull
    private final List<Digest> digests;
    @NotNull
    private final List<SignerBlock> signers;
    private final ZipMetadataProto protobufRepresentation;
    private static final long SIGNATURE_BLOCK_MAGIC_HI = 3617552046287187010L;
    private static final long SIGNATURE_BLOCK_MAGIC_LO = 2334950737559900224L;
    private static final int signatureBlockHeaderSize = 8;
    private static final int signatureBlockFooterSize = 24;
    private static final int signatureBlockMetadataSize = 32;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final int getSize() {
        return this.size;
    }

    @NotNull
    public final byte[] toByteArray() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.size);
        boolean bl = false;
        boolean bl2 = false;
        ByteBuffer $this$with = byteBuffer;
        boolean bl3 = false;
        $this$with.order(ByteOrder.LITTLE_ENDIAN);
        long blockSizeFieldValue = (long)this.size - 8L;
        $this$with.putLong(blockSizeFieldValue);
        $this$with.put(this.protobufRepresentation.toByteArray());
        $this$with.putLong(blockSizeFieldValue);
        $this$with.putLong(2334950737559900224L);
        $this$with.putLong(3617552046287187010L);
        byte[] byArray = $this$with.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"with(ByteBuffer.allocate\u2026        array()\n        }");
        return byArray;
    }

    @NotNull
    public final List<Digest> getDigests() {
        return this.digests;
    }

    @NotNull
    public final List<SignerBlock> getSigners() {
        return this.signers;
    }

    private ZipMetadata(List<Digest> digests, List<SignerBlock> signers, ZipMetadataProto protobufRepresentation) {
        this.digests = digests;
        this.signers = signers;
        this.protobufRepresentation = protobufRepresentation;
        this.size = 32 + this.protobufRepresentation.getSerializedSize();
    }

    public ZipMetadata(@NotNull List<Digest> digests, @NotNull List<SignerBlock> signers) {
        GeneratedMessageV3 generatedMessageV3;
        SignerBlock it;
        Collection<DigestProto> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter(digests, (String)"digests");
        Intrinsics.checkNotNullParameter(signers, (String)"signers");
        Iterable iterable = digests;
        ZipSignatureBlockProto.Builder builder = ZipSignatureBlockProto.newBuilder();
        ZipMetadataProto.Builder builder2 = ZipMetadataProto.newBuilder().setSignatureSchemeVersion(1);
        List<SignerBlock> list = signers;
        List<Digest> list2 = digests;
        ZipMetadata zipMetadata = this;
        boolean $i$f$map = false;
        void var5_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Digest digest = (Digest)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            generatedMessageV3 = ((Digest)((Object)it)).getProtobufRepresentation();
            collection.add((DigestProto)generatedMessageV3);
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = signers;
        builder = builder.addAllDigests((Iterable<? extends DigestProto>)collection);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (SignerBlock)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            generatedMessageV3 = it.getProtobufRepresentation();
            collection.add((DigestProto)generatedMessageV3);
        }
        collection = (List)destination$iv$iv;
        ZipMetadataProto zipMetadataProto = builder2.setContent(builder.addAllSigners((Iterable<? extends SignerBlockProto>)collection).build()).build();
        Intrinsics.checkNotNullExpressionValue((Object)zipMetadataProto, (String)"ZipMetadataProto\n       \u2026   )\n            .build()");
        zipMetadata(list2, list, zipMetadataProto);
    }

    public /* synthetic */ ZipMetadata(List digests, List signers, ZipMetadataProto protobufRepresentation, DefaultConstructorMarker $constructor_marker) {
        this(digests, signers, protobufRepresentation);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/zip/signer/metadata/ZipMetadata$Companion;", "", "()V", "SIGNATURE_BLOCK_MAGIC_HI", "", "SIGNATURE_BLOCK_MAGIC_LO", "signatureBlockFooterSize", "", "signatureBlockHeaderSize", "signatureBlockMetadataSize", "findInZip", "Lorg/jetbrains/zip/signer/metadata/ZipMetadata;", "zipArchive", "Lorg/jetbrains/zip/signer/datasource/DataSource;", "zipSectionsInformation", "Lorg/jetbrains/zip/signer/zip/ZipSectionsInformation;", "lib"})
    public static final class Companion {
        @Nullable
        public final ZipMetadata findInZip(@NotNull DataSource zipArchive, @NotNull ZipSectionsInformation zipSectionsInformation) {
            Object object;
            SignerBlockProto it;
            Collection<Digest> collection;
            Iterable $this$mapTo$iv$iv;
            ZipMetadataProto protobufContent;
            Intrinsics.checkNotNullParameter((Object)zipArchive, (String)"zipArchive");
            Intrinsics.checkNotNullParameter((Object)zipSectionsInformation, (String)"zipSectionsInformation");
            long centralDirStartOffset = zipSectionsInformation.getCentralDirectoryOffset();
            if (centralDirStartOffset < (long)32) {
                return null;
            }
            ByteBuffer byteBuffer = zipArchive.getByteBuffer(centralDirStartOffset - (long)24, 24);
            boolean bl = false;
            boolean bl2 = false;
            ByteBuffer $this$apply = byteBuffer;
            boolean bl3 = false;
            $this$apply.order(ByteOrder.LITTLE_ENDIAN);
            ByteBuffer footer = byteBuffer;
            if (footer.getLong(8) != 2334950737559900224L || footer.getLong(16) != 3617552046287187010L) {
                return null;
            }
            long signatureBlockSizeInFooter = footer.getLong(0);
            if (signatureBlockSizeInFooter < (long)footer.capacity() || signatureBlockSizeInFooter > (long)0x7FFFFFF7) {
                return null;
            }
            int totalSize = (int)(signatureBlockSizeInFooter + (long)8);
            long signingBlockOffset = centralDirStartOffset - (long)totalSize;
            if (signingBlockOffset < 0L) {
                return null;
            }
            ByteBuffer byteBuffer2 = zipArchive.getByteBuffer(signingBlockOffset, 8);
            boolean bl4 = false;
            boolean bl5 = false;
            ByteBuffer $this$apply22 = byteBuffer2;
            boolean bl6 = false;
            $this$apply22.order(ByteOrder.LITTLE_ENDIAN);
            ByteBuffer signatureBlockHeader = byteBuffer2;
            long signatureBlockSizeInHeader = signatureBlockHeader.getLong(0);
            if (signatureBlockSizeInHeader != signatureBlockSizeInFooter) {
                return null;
            }
            ZipMetadataProto zipMetadataProto = protobufContent = ZipMetadataProto.parseFrom(zipArchive.getByteBuffer(signingBlockOffset + (long)8, totalSize - 32));
            Intrinsics.checkNotNullExpressionValue((Object)zipMetadataProto, (String)"protobufContent");
            boolean $this$apply22 = zipMetadataProto.getSignatureSchemeVersion() == 1;
            bl6 = false;
            boolean bl7 = false;
            bl7 = false;
            boolean bl8 = false;
            if (!$this$apply22) {
                boolean bl9 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            ZipSignatureBlockProto zipSignatureBlockProto = protobufContent.getContent();
            Intrinsics.checkNotNullExpressionValue((Object)zipSignatureBlockProto, (String)"protobufContent.content");
            List<DigestProto> list = zipSignatureBlockProto.getDigestsList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"protobufContent.content.digestsList");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                DigestProto digestProto = (DigestProto)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl10 = false;
                void v3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it");
                object = new Digest((DigestProto)v3);
                collection.add((Digest)object);
            }
            collection = (List)destination$iv$iv;
            ZipSignatureBlockProto zipSignatureBlockProto2 = protobufContent.getContent();
            Intrinsics.checkNotNullExpressionValue((Object)zipSignatureBlockProto2, (String)"protobufContent.content");
            List<SignerBlockProto> list2 = zipSignatureBlockProto2.getSignersList();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"protobufContent.content.signersList");
            $this$map$iv = list2;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (SignerBlockProto)item$iv$iv;
                object = destination$iv$iv;
                boolean bl11 = false;
                SignerBlockProto signerBlockProto = it;
                Intrinsics.checkNotNullExpressionValue((Object)signerBlockProto, (String)"it");
                SignerBlock signerBlock = new SignerBlock(signerBlockProto);
                object.add(signerBlock);
            }
            object = (List)destination$iv$iv;
            DefaultConstructorMarker defaultConstructorMarker = null;
            ZipMetadataProto zipMetadataProto2 = protobufContent;
            Object object2 = object;
            Collection<Digest> collection2 = collection;
            return new ZipMetadata((List)collection2, (List)object2, zipMetadataProto2, defaultConstructorMarker);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

