/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.zip.signer.zip;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.ZipException;
import kotlin.ExperimentalUnsignedTypes;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.UInt;
import kotlin.UShort;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.zip.signer.datasource.DataSource;
import org.jetbrains.zip.signer.metadata.ZipMetadata;
import org.jetbrains.zip.signer.utils.ByteBufferExtensionsKt;
import org.jetbrains.zip.signer.zip.ZipSections;
import org.jetbrains.zip.signer.zip.ZipSectionsInformation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c1\u0002\u0018\u00002\u00020\u0001:\u0001&B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001e\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J0\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014J'\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0000\u00a2\u0006\u0002\b\u001bJ\u000e\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u0010J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001e\u001a\u00020\rH\u0002J\"\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020#H\u0000\u00f8\u0001\u0000\u00a2\u0006\u0004\b$\u0010%R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006'"}, d2={"Lorg/jetbrains/zip/signer/zip/ZipUtils;", "", "()V", "ZIP_EOCD_CENTRAL_DIR_OFFSET_FIELD_OFFSET", "", "ZIP_EOCD_CENTRAL_DIR_SIZE_FIELD_OFFSET", "ZIP_EOCD_COMMENT_LENGTH_FIELD_OFFSET", "ZIP_EOCD_REC_MIN_SIZE", "ZIP_EOCD_REC_SIG", "findEocdInBuffer", "Lkotlin/Pair;", "Lorg/jetbrains/zip/signer/zip/ZipUtils$ZipEocdData;", "zipContents", "Ljava/nio/ByteBuffer;", "", "zip", "Lorg/jetbrains/zip/signer/datasource/DataSource;", "maxCommentSize", "Lkotlin/UShort;", "findEocdInBuffer-BFYp7ww", "(Lorg/jetbrains/zip/signer/datasource/DataSource;S)Lkotlin/Pair;", "findZipSections", "Lorg/jetbrains/zip/signer/zip/ZipSections;", "zipSectionsInformation", "Lorg/jetbrains/zip/signer/zip/ZipSectionsInformation;", "zipMetadata", "Lorg/jetbrains/zip/signer/metadata/ZipMetadata;", "findZipSections$lib", "findZipSectionsInformation", "parseEOCD", "eocdSection", "setZipEocdCentralDirectoryOffset", "", "zipEndOfCentralDirectory", "offset", "Lkotlin/UInt;", "setZipEocdCentralDirectoryOffset-7pO5UbU$lib", "(Ljava/nio/ByteBuffer;I)V", "ZipEocdData", "lib"})
@ExperimentalUnsignedTypes
public final class ZipUtils {
    private static final int ZIP_EOCD_REC_MIN_SIZE = 22;
    private static final int ZIP_EOCD_REC_SIG = 101010256;
    private static final int ZIP_EOCD_CENTRAL_DIR_SIZE_FIELD_OFFSET = 12;
    private static final int ZIP_EOCD_CENTRAL_DIR_OFFSET_FIELD_OFFSET = 16;
    private static final int ZIP_EOCD_COMMENT_LENGTH_FIELD_OFFSET = 20;
    @NotNull
    public static final ZipUtils INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ZipSectionsInformation findZipSectionsInformation(@NotNull DataSource zip) {
        void eocdOffset;
        Intrinsics.checkNotNullParameter((Object)zip, (String)"zip");
        Pair<Long, ZipEocdData> pair = this.findEocdInBuffer(zip);
        if (pair == null) {
            throw (Throwable)new ZipException("ZIP End of Central Directory record not found");
        }
        Pair<Long, ZipEocdData> pair2 = pair;
        long l = ((Number)pair2.component1()).longValue();
        ZipEocdData eocd = (ZipEocdData)pair2.component2();
        int n = eocd.getCentralDirectoryOffset-pVg5ArA();
        boolean bl = false;
        long l2 = (long)n & 0xFFFFFFFFL;
        n = eocd.getCentralDirectorySize-pVg5ArA();
        bl = false;
        long centralDirectoryEndOffset = l2 + ((long)n & 0xFFFFFFFFL);
        n = eocd.getCentralDirectoryOffset-pVg5ArA();
        bl = false;
        if (((long)n & 0xFFFFFFFFL) > eocdOffset) {
            throw (Throwable)new ZipException("ZIP Central Directory start offset out of range");
        }
        if (centralDirectoryEndOffset > eocdOffset) {
            throw (Throwable)new ZipException("ZIP Central Directory overlaps with End of Central Directory");
        }
        n = eocd.getCentralDirectoryOffset-pVg5ArA();
        bl = false;
        long l3 = (long)n & 0xFFFFFFFFL;
        n = eocd.getCentralDirectorySize-pVg5ArA();
        bl = false;
        return new ZipSectionsInformation(l3, (long)n & 0xFFFFFFFFL, (long)eocdOffset, (int)(zip.size() - eocdOffset));
    }

    @NotNull
    public final ZipSections findZipSections$lib(@NotNull DataSource zip, @NotNull ZipSectionsInformation zipSectionsInformation, @Nullable ZipMetadata zipMetadata) {
        Intrinsics.checkNotNullParameter((Object)zip, (String)"zip");
        Intrinsics.checkNotNullParameter((Object)zipSectionsInformation, (String)"zipSectionsInformation");
        ZipMetadata zipMetadata2 = zipMetadata;
        return new ZipSections(zip.slice(0L, zipSectionsInformation.getCentralDirectoryOffset() - (zipMetadata2 != null ? (long)zipMetadata2.getSize() : 0L)), zip.slice(zipSectionsInformation.getCentralDirectoryOffset(), zipSectionsInformation.getCentralDirectorySizeBytes()), zip.slice(zipSectionsInformation.getEndOfCentralDirectoryOffset(), zipSectionsInformation.getEndOfCentralDirectorySizeBytes()));
    }

    public final void setZipEocdCentralDirectoryOffset-7pO5UbU$lib(@NotNull ByteBuffer zipEndOfCentralDirectory, int offset) {
        Intrinsics.checkNotNullParameter((Object)zipEndOfCentralDirectory, (String)"zipEndOfCentralDirectory");
        boolean bl = ByteBufferExtensionsKt.isLittleEndian(zipEndOfCentralDirectory);
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ByteBufferExtensionsKt.setUnsignedInt-2sDpNY4(zipEndOfCentralDirectory, zipEndOfCentralDirectory.position() + 16, offset);
    }

    private final Pair<Long, ZipEocdData> findEocdInBuffer(DataSource zip) {
        Pair<Long, ZipEocdData> pair = this.findEocdInBuffer-BFYp7ww(zip, (short)0);
        if (pair == null) {
            pair = this.findEocdInBuffer-BFYp7ww(zip, (short)-1);
        }
        return pair;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<Long, ZipEocdData> findEocdInBuffer-BFYp7ww(DataSource zip, short maxCommentSize) {
        void eocdOffsetInBuffer;
        long fileSize = zip.size();
        if (fileSize < (long)22) {
            return null;
        }
        short s = maxCommentSize;
        boolean bl = false;
        int maxEocdSize = 22 + RangesKt.coerceAtMost((int)(s & 0xFFFF), (int)((int)fileSize - 22));
        long bufOffsetInFile = fileSize - (long)maxEocdSize;
        ByteBuffer byteBuffer = zip.getByteBuffer(bufOffsetInFile, maxEocdSize);
        boolean bl2 = false;
        boolean bl3 = false;
        ByteBuffer $this$apply = byteBuffer;
        boolean bl4 = false;
        $this$apply.order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer buf = byteBuffer;
        Pair<Integer, ZipEocdData> pair = this.findEocdInBuffer(buf);
        if (pair == null) {
            return null;
        }
        Pair<Integer, ZipEocdData> pair2 = pair;
        int n = ((Number)pair2.component1()).intValue();
        ZipEocdData eocd = (ZipEocdData)pair2.component2();
        return TuplesKt.to((Object)(bufOffsetInFile + (long)eocdOffsetInBuffer), (Object)eocd);
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<Integer, ZipEocdData> findEocdInBuffer(ByteBuffer zipContents) {
        boolean bl = ByteBufferExtensionsKt.isLittleEndian(zipContents);
        int n = 0;
        int n2 = 0;
        n2 = 0;
        int n3 = 0;
        if (!bl) {
            boolean bl2 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        int eocdWithEmptyCommentStartPosition = zipContents.capacity() - 22;
        if (eocdWithEmptyCommentStartPosition < 0) {
            return null;
        }
        n = 0;
        n3 = -1;
        short s = 0;
        n2 = RangesKt.coerceAtMost((int)eocdWithEmptyCommentStartPosition, (int)(n3 & 0xFFFF));
        if (n <= n2) {
            while (true) {
                void possibleCommentLength;
                zipContents.position(eocdWithEmptyCommentStartPosition - possibleCommentLength);
                if (this.parseEOCD(zipContents) == null) {
                } else {
                    ZipEocdData zipEocd;
                    s = zipEocd.getCommentLength-Mh2AYeg();
                    boolean bl3 = false;
                    if ((s & 0xFFFF) == possibleCommentLength) {
                        return TuplesKt.to((Object)zipContents.position(), (Object)zipEocd);
                    }
                }
                if (possibleCommentLength == n2) break;
                ++possibleCommentLength;
            }
        }
        return null;
    }

    private final ZipEocdData parseEOCD(ByteBuffer eocdSection) {
        boolean bl = false;
        boolean bl2 = false;
        ByteBuffer $this$with = eocdSection;
        boolean bl3 = false;
        boolean bl4 = ByteBufferExtensionsKt.isLittleEndian($this$with);
        boolean bl5 = false;
        boolean bl6 = false;
        bl6 = false;
        boolean bl7 = false;
        if (!bl4) {
            boolean bl8 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if ($this$with.getInt($this$with.position()) != 101010256) {
            return null;
        }
        return new ZipEocdData(ByteBufferExtensionsKt.getUnsignedInt($this$with, $this$with.position() + 16), ByteBufferExtensionsKt.getUnsignedInt($this$with, $this$with.position() + 12), ByteBufferExtensionsKt.getUnsignedShort($this$with, $this$with.position() + 20), null);
    }

    private ZipUtils() {
    }

    static {
        ZipUtils zipUtils;
        INSTANCE = zipUtils = new ZipUtils();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B \u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0010\u0010\tJ\u0016\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0012\u0010\tJ\u0016\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0014\u0010\rJ1\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0019\u0010\u0002\u001a\u00020\u0003\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0019\u0010\u0004\u001a\u00020\u0003\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\u000b\u0010\tR\u0019\u0010\u0005\u001a\u00020\u0006\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\r\u0082\u0002\b\n\u0002\b\u0019\n\u0002\b!\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/zip/signer/zip/ZipUtils$ZipEocdData;", "", "centralDirectoryOffset", "Lkotlin/UInt;", "centralDirectorySize", "commentLength", "Lkotlin/UShort;", "(IISLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getCentralDirectoryOffset-pVg5ArA", "()I", "I", "getCentralDirectorySize-pVg5ArA", "getCommentLength-Mh2AYeg", "()S", "S", "component1", "component1-pVg5ArA", "component2", "component2-pVg5ArA", "component3", "component3-Mh2AYeg", "copy", "copy-KFDBkXY", "(IIS)Lorg/jetbrains/zip/signer/zip/ZipUtils$ZipEocdData;", "equals", "", "other", "hashCode", "", "toString", "", "lib"})
    private static final class ZipEocdData {
        private final int centralDirectoryOffset;
        private final int centralDirectorySize;
        private final short commentLength;

        public final int getCentralDirectoryOffset-pVg5ArA() {
            return this.centralDirectoryOffset;
        }

        public final int getCentralDirectorySize-pVg5ArA() {
            return this.centralDirectorySize;
        }

        public final short getCommentLength-Mh2AYeg() {
            return this.commentLength;
        }

        private ZipEocdData(int centralDirectoryOffset, int centralDirectorySize, short commentLength) {
            this.centralDirectoryOffset = centralDirectoryOffset;
            this.centralDirectorySize = centralDirectorySize;
            this.commentLength = commentLength;
        }

        public /* synthetic */ ZipEocdData(int centralDirectoryOffset, int centralDirectorySize, short commentLength, DefaultConstructorMarker $constructor_marker) {
            this(centralDirectoryOffset, centralDirectorySize, commentLength);
        }

        public final int component1-pVg5ArA() {
            return this.centralDirectoryOffset;
        }

        public final int component2-pVg5ArA() {
            return this.centralDirectorySize;
        }

        public final short component3-Mh2AYeg() {
            return this.commentLength;
        }

        @NotNull
        public final ZipEocdData copy-KFDBkXY(int centralDirectoryOffset, int centralDirectorySize, short commentLength) {
            return new ZipEocdData(centralDirectoryOffset, centralDirectorySize, commentLength);
        }

        public static /* synthetic */ ZipEocdData copy-KFDBkXY$default(ZipEocdData zipEocdData, int n, int n2, short s, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = zipEocdData.centralDirectoryOffset;
            }
            if ((n3 & 2) != 0) {
                n2 = zipEocdData.centralDirectorySize;
            }
            if ((n3 & 4) != 0) {
                s = zipEocdData.commentLength;
            }
            return zipEocdData.copy-KFDBkXY(n, n2, s);
        }

        @NotNull
        public String toString() {
            return "ZipEocdData(centralDirectoryOffset=" + UInt.toString-impl((int)this.centralDirectoryOffset) + ", centralDirectorySize=" + UInt.toString-impl((int)this.centralDirectorySize) + ", commentLength=" + UShort.toString-impl((short)this.commentLength) + ")";
        }

        public int hashCode() {
            return (this.centralDirectoryOffset * 31 + this.centralDirectorySize) * 31 + this.commentLength;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ZipEocdData)) break block3;
                    ZipEocdData zipEocdData = (ZipEocdData)object;
                    if (this.centralDirectoryOffset != zipEocdData.centralDirectoryOffset || this.centralDirectorySize != zipEocdData.centralDirectorySize || this.commentLength != zipEocdData.commentLength) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

