/*
 * Copyright 2000-2024 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.jetbrains;

import java.awt.*;
import java.util.function.Supplier;

/**
 * {@link java.awt.GraphicsEnvironment}-related utilities.
 */
@Service
@Provided
public interface ProjectorUtils {

    /**
     * Override {@link GraphicsEnvironment#getLocalGraphicsEnvironment()}
     * with custom provider. Provider is called only once, returned value is cached.
     * Calling this method after {@link GraphicsEnvironment} initialization (e.g.
     * after {@link GraphicsEnvironment#getLocalGraphicsEnvironment()} was called)
     * will have no effect.
     * @param geProvider GraphicsEnvironment provider
     */
    void setLocalGraphicsEnvironmentProvider(Supplier<GraphicsEnvironment> geProvider);

    /**
     * Override {@link GraphicsEnvironment#getLocalGraphicsEnvironment()}
     * with custom instance.
     * Calling this method after {@link GraphicsEnvironment} initialization (e.g.
     * after {@link GraphicsEnvironment#getLocalGraphicsEnvironment()} was called)
     * will have no effect.
     * @param overriddenGE new GraphicsEnvironment
     */
    void overrideGraphicsEnvironment(GraphicsEnvironment overriddenGE);
}
