/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skia;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.ColorAlphaType;
import org.jetbrains.skia.ColorInfo;
import org.jetbrains.skia.ColorSpace;
import org.jetbrains.skia.ColorType;
import org.jetbrains.skia.IRect;
import org.jetbrains.skia.impl.InteropScope;
import org.jetbrains.skia.impl.Native;
import org.jetbrains.skia.impl.NativePointerArray;
import org.jetbrains.skia.impl.Stats;
import org.jetbrains.skia.impl.theScope;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010\u000e\n\u0002\b\f\u0018\u0000 D2\u00020\u0001:\u0001DB'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB1\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fB3\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\n\u0010\n\u001a\u00060\rj\u0002`\u000e\u00a2\u0006\u0002\u0010\u000fB\u001d\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0012J\u000e\u0010.\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u0003J\u0006\u00100\u001a\u00020\u0003J\u001e\u00101\u001a\u00020\r2\u0006\u00102\u001a\u00020\u00032\u0006\u00103\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\rJ\u0013\u00104\u001a\u00020%2\b\u00105\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u00106\u001a\u00020\u0003H\u0016J\u000e\u00107\u001a\u00020%2\u0006\u0010/\u001a\u00020\rJ\b\u00108\u001a\u000209H\u0016J\u000e\u0010:\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010;\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u0011J\u000e\u0010=\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010>\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010?\u001a\u00020\u00002\u0006\u0010@\u001a\u00020\u0003J\u000e\u0010A\u001a\u00020\u00002\u0006\u0010B\u001a\u00020\u0003J\u0016\u0010C\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0019R\u0011\u0010$\u001a\u00020%8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010&R\u0011\u0010'\u001a\u00020%8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010&R\u0011\u0010(\u001a\u00020%8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010&R\u0011\u0010)\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0019R\u0011\u0010+\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u0019\u00a8\u0006E"}, d2={"Lorg/jetbrains/skia/ImageInfo;", "", "width", "", "height", "colorType", "Lorg/jetbrains/skia/ColorType;", "alphaType", "Lorg/jetbrains/skia/ColorAlphaType;", "(IILorg/jetbrains/skia/ColorType;Lorg/jetbrains/skia/ColorAlphaType;)V", "colorSpace", "Lorg/jetbrains/skia/ColorSpace;", "(IILorg/jetbrains/skia/ColorType;Lorg/jetbrains/skia/ColorAlphaType;Lorg/jetbrains/skia/ColorSpace;)V", "", "Lorg/jetbrains/skia/impl/NativePointer;", "(IIIIJ)V", "colorInfo", "Lorg/jetbrains/skia/ColorInfo;", "(Lorg/jetbrains/skia/ColorInfo;II)V", "bounds", "Lorg/jetbrains/skia/IRect;", "getBounds", "()Lorg/jetbrains/skia/IRect;", "bytesPerPixel", "getBytesPerPixel", "()I", "colorAlphaType", "getColorAlphaType", "()Lorg/jetbrains/skia/ColorAlphaType;", "getColorInfo", "()Lorg/jetbrains/skia/ColorInfo;", "getColorSpace", "()Lorg/jetbrains/skia/ColorSpace;", "getColorType", "()Lorg/jetbrains/skia/ColorType;", "getHeight", "isEmpty", "", "()Z", "isGammaCloseToSRGB", "isOpaque", "minRowBytes", "getMinRowBytes", "shiftPerPixel", "getShiftPerPixel", "getWidth", "computeByteSize", "rowBytes", "computeMinByteSize", "computeOffset", "x", "y", "equals", "other", "hashCode", "isRowBytesValid", "toString", "", "withColorAlphaType", "withColorInfo", "_colorInfo", "withColorSpace", "withColorType", "withHeight", "_height", "withWidth", "_width", "withWidthHeight", "Companion", "skiko"})
public final class ImageInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ColorInfo colorInfo;
    private final int width;
    private final int height;
    @NotNull
    private static final ImageInfo DEFAULT = new ImageInfo(ColorInfo.Companion.getDEFAULT(), 0, 0);

    public ImageInfo(@NotNull ColorInfo colorInfo, int width2, int height2) {
        Intrinsics.checkNotNullParameter((Object)colorInfo, (String)"colorInfo");
        this.colorInfo = colorInfo;
        this.width = width2;
        this.height = height2;
    }

    @NotNull
    public final ColorInfo getColorInfo() {
        return this.colorInfo;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public ImageInfo(int width2, int height2, @NotNull ColorType colorType, @NotNull ColorAlphaType alphaType) {
        Intrinsics.checkNotNullParameter((Object)((Object)colorType), (String)"colorType");
        Intrinsics.checkNotNullParameter((Object)((Object)alphaType), (String)"alphaType");
        this(new ColorInfo(colorType, alphaType, null), width2, height2);
    }

    public ImageInfo(int width2, int height2, @NotNull ColorType colorType, @NotNull ColorAlphaType alphaType, @Nullable ColorSpace colorSpace) {
        Intrinsics.checkNotNullParameter((Object)((Object)colorType), (String)"colorType");
        Intrinsics.checkNotNullParameter((Object)((Object)alphaType), (String)"alphaType");
        this(new ColorInfo(colorType, alphaType, colorSpace), width2, height2);
    }

    public ImageInfo(int width2, int height2, int colorType, int alphaType, long colorSpace) {
        this(width2, height2, ColorType.values()[colorType], ColorAlphaType.values()[alphaType], colorSpace == Native.Companion.getNullPointer() ? null : new ColorSpace(colorSpace));
    }

    public final int getMinRowBytes() {
        return this.width * this.getBytesPerPixel();
    }

    @NotNull
    public final ColorType getColorType() {
        return this.colorInfo.getColorType();
    }

    @NotNull
    public final ImageInfo withColorType(@NotNull ColorType colorType) {
        Intrinsics.checkNotNullParameter((Object)((Object)colorType), (String)"colorType");
        return this.withColorInfo(this.colorInfo.withColorType(colorType));
    }

    @NotNull
    public final ColorAlphaType getColorAlphaType() {
        return this.colorInfo.getAlphaType();
    }

    @NotNull
    public final ImageInfo withColorAlphaType(@NotNull ColorAlphaType alphaType) {
        Intrinsics.checkNotNullParameter((Object)((Object)alphaType), (String)"alphaType");
        return this.withColorInfo(this.colorInfo.withAlphaType(alphaType));
    }

    @Nullable
    public final ColorSpace getColorSpace() {
        return this.colorInfo.getColorSpace();
    }

    @NotNull
    public final ImageInfo withColorSpace(@NotNull ColorSpace colorSpace) {
        Intrinsics.checkNotNullParameter((Object)colorSpace, (String)"colorSpace");
        return this.withColorInfo(this.colorInfo.withColorSpace(colorSpace));
    }

    public final boolean isEmpty() {
        return this.width <= 0 || this.height <= 0;
    }

    public final boolean isOpaque() {
        return this.colorInfo.isOpaque();
    }

    @NotNull
    public final IRect getBounds() {
        return IRect.Companion.makeXYWH(0, 0, this.width, this.height);
    }

    public final boolean isGammaCloseToSRGB() {
        return this.colorInfo.isGammaCloseToSRGB();
    }

    @NotNull
    public final ImageInfo withWidthHeight(int width2, int height2) {
        return new ImageInfo(this.colorInfo, width2, height2);
    }

    public final int getBytesPerPixel() {
        return this.colorInfo.getBytesPerPixel();
    }

    public final int getShiftPerPixel() {
        return this.colorInfo.getShiftPerPixel();
    }

    public final boolean isRowBytesValid(long rowBytes) {
        if (rowBytes < (long)this.getMinRowBytes()) {
            return false;
        }
        int shift = this.getShiftPerPixel();
        return rowBytes >> shift << shift == rowBytes;
    }

    public final long computeOffset(int x2, int y2, long rowBytes) {
        return this.colorInfo.getColorType().computeOffset(x2, y2, rowBytes);
    }

    public final int computeByteSize(int rowBytes) {
        return this.height == 0 ? 0 : (this.height - 1) * rowBytes + this.width * this.getBytesPerPixel();
    }

    public final int computeMinByteSize() {
        return this.computeByteSize(this.getMinRowBytes());
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ImageInfo)) {
            return false;
        }
        if (this.width != ((ImageInfo)other).width) {
            return false;
        }
        if (this.height != ((ImageInfo)other).height) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.colorInfo, (Object)((ImageInfo)other).colorInfo);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * PRIME + this.width;
        result = result * PRIME + this.height;
        result = result * PRIME + this.colorInfo.hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        return "ImageInfo(_colorInfo=" + this.colorInfo + ", _width=" + this.width + ", _height=" + this.height + ')';
    }

    @NotNull
    public final ImageInfo withColorInfo(@NotNull ColorInfo _colorInfo) {
        Intrinsics.checkNotNullParameter((Object)_colorInfo, (String)"_colorInfo");
        return this.colorInfo == _colorInfo ? this : new ImageInfo(_colorInfo, this.width, this.height);
    }

    @NotNull
    public final ImageInfo withWidth(int _width) {
        return this.width == _width ? this : new ImageInfo(this.colorInfo, _width, this.height);
    }

    @NotNull
    public final ImageInfo withHeight(int _height) {
        return this.height == _height ? this : new ImageInfo(this.colorInfo, this.width, _height);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Jo\u0010\u0007\u001a\u00020\u00042\n\u0010\b\u001a\u00060\tj\u0002`\n2[\u0010\u000b\u001aW\u0012\u0017\u0012\u00150\tj\u0002`\n\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\b\u0012\u0019\u0012\u0017\u0018\u00010\u0001j\u0002`\u000f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0010\u0012\u0019\u0012\u0017\u0018\u00010\u0001j\u0002`\u000f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00120\fJ\u0016\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015J\u001e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019J(\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\u0016\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015J \u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\u001e\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/skia/ImageInfo$Companion;", "", "()V", "DEFAULT", "Lorg/jetbrains/skia/ImageInfo;", "getDEFAULT", "()Lorg/jetbrains/skia/ImageInfo;", "createUsing", "_ptr", "", "Lorg/jetbrains/skia/impl/NativePointer;", "_nGetImageInfo", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "Lorg/jetbrains/skia/impl/InteropPointer;", "intArrayPointer", "nativePointerArrayPtr", "", "makeA8", "width", "", "height", "makeN32", "alphaType", "Lorg/jetbrains/skia/ColorAlphaType;", "colorSpace", "Lorg/jetbrains/skia/ColorSpace;", "makeN32Premul", "makeS32", "makeUnknown", "skiko"})
    @SourceDebugExtension(value={"SMAP\nImageInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageInfo.kt\norg/jetbrains/skia/ImageInfo$Companion\n+ 2 Native.kt\norg/jetbrains/skia/impl/NativeKt\n+ 3 Native.jvm.kt\norg/jetbrains/skia/impl/Native_jvmKt\n*L\n1#1,309:1\n114#2:310\n115#2,2:312\n145#2:314\n146#2,5:316\n117#2,3:321\n55#3:311\n55#3:315\n*S KotlinDebug\n*F\n+ 1 ImageInfo.kt\norg/jetbrains/skia/ImageInfo$Companion\n*L\n293#1:310\n293#1:312,2\n294#1:314\n294#1:316,5\n293#1:321,3\n293#1:311\n294#1:315\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ImageInfo getDEFAULT() {
            return DEFAULT;
        }

        @NotNull
        public final ImageInfo makeN32(int width2, int height2, @NotNull ColorAlphaType alphaType) {
            Intrinsics.checkNotNullParameter((Object)((Object)alphaType), (String)"alphaType");
            return new ImageInfo(new ColorInfo(ColorType.Companion.getN32(), alphaType, null), width2, height2);
        }

        @NotNull
        public final ImageInfo makeN32(int width2, int height2, @NotNull ColorAlphaType alphaType, @Nullable ColorSpace colorSpace) {
            Intrinsics.checkNotNullParameter((Object)((Object)alphaType), (String)"alphaType");
            return new ImageInfo(new ColorInfo(ColorType.Companion.getN32(), alphaType, colorSpace), width2, height2);
        }

        @NotNull
        public final ImageInfo makeS32(int width2, int height2, @NotNull ColorAlphaType alphaType) {
            Intrinsics.checkNotNullParameter((Object)((Object)alphaType), (String)"alphaType");
            return new ImageInfo(new ColorInfo(ColorType.Companion.getN32(), alphaType, ColorSpace.Companion.getSRGB()), width2, height2);
        }

        @NotNull
        public final ImageInfo makeN32Premul(int width2, int height2) {
            return new ImageInfo(new ColorInfo(ColorType.Companion.getN32(), ColorAlphaType.PREMUL, null), width2, height2);
        }

        @NotNull
        public final ImageInfo makeN32Premul(int width2, int height2, @Nullable ColorSpace colorSpace) {
            return new ImageInfo(new ColorInfo(ColorType.Companion.getN32(), ColorAlphaType.PREMUL, colorSpace), width2, height2);
        }

        @NotNull
        public final ImageInfo makeA8(int width2, int height2) {
            return new ImageInfo(new ColorInfo(ColorType.ALPHA_8, ColorAlphaType.PREMUL, null), width2, height2);
        }

        @NotNull
        public final ImageInfo makeUnknown(int width2, int height2) {
            return new ImageInfo(new ColorInfo(ColorType.UNKNOWN, ColorAlphaType.UNKNOWN, null), width2, height2);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ImageInfo createUsing(long _ptr, @NotNull Function3<? super Long, Object, Object, Unit> _nGetImageInfo) {
            void nativePointerArrayPtr;
            void intArrayPointer;
            Object handle$iv;
            Object handle$iv2;
            Intrinsics.checkNotNullParameter(_nGetImageInfo, (String)"_nGetImageInfo");
            Stats.INSTANCE.onNativeCall();
            Ref.ObjectRef colorSpacePtr = new Ref.ObjectRef();
            int[] result$iv = new int[4];
            boolean $i$f$withResult = false;
            boolean $i$f$interopScope = false;
            InteropScope $this$withResult_u24lambda_u244$iv = theScope.INSTANCE;
            boolean bl = false;
            Object object = handle$iv2 = $this$withResult_u24lambda_u244$iv.toInteropForResult(result$iv);
            InteropScope $this$createUsing_u24lambda_u241 = $this$withResult_u24lambda_u244$iv;
            boolean bl2 = false;
            NativePointerArray result$iv2 = new NativePointerArray(1);
            boolean $i$f$withResult2 = false;
            boolean $i$f$interopScope2 = false;
            InteropScope $this$withResult_u24lambda_u248$iv = theScope.INSTANCE;
            boolean bl3 = false;
            Object object2 = handle$iv = $this$withResult_u24lambda_u248$iv.toInteropForResult(result$iv2);
            InteropScope interopScope = $this$withResult_u24lambda_u248$iv;
            Ref.ObjectRef objectRef = colorSpacePtr;
            boolean bl4 = false;
            _nGetImageInfo.invoke((Object)_ptr, (Object)intArrayPointer, (Object)nativePointerArrayPtr);
            $this$withResult_u24lambda_u248$iv.fromInterop(handle$iv, result$iv2);
            objectRef.element = result$iv2.get(0);
            $this$withResult_u24lambda_u244$iv.fromInterop(handle$iv2, result$iv);
            int[] it = result$iv;
            boolean bl5 = false;
            int n = it[0];
            int n2 = it[1];
            int n3 = it[2];
            int n4 = it[3];
            Object object3 = colorSpacePtr.element;
            Intrinsics.checkNotNull((Object)object3);
            return new ImageInfo(n, n2, n3, n4, ((Number)object3).longValue());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

