/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko;

import java.awt.Font;
import java.awt.color.ColorSpace;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.File;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.ColorAlphaType;
import org.jetbrains.skia.ColorType;
import org.jetbrains.skia.Data;
import org.jetbrains.skia.Data_jvmKt;
import org.jetbrains.skia.Image;
import org.jetbrains.skia.ImageInfo;
import org.jetbrains.skia.Pixmap;
import org.jetbrains.skia.Typeface;
import org.jetbrains.skia.impl.BufferUtil;
import org.jetbrains.skiko.AwtFontManager;
import org.jetbrains.skiko.Convertors_jvmKt;
import org.jetbrains.skiko.DirectDataBuffer;
import org.jetbrains.skiko.SkikoInputEvent;
import org.jetbrains.skiko.SkikoInputModifiers;
import org.jetbrains.skiko.SkikoKey;
import org.jetbrains.skiko.SkikoKeyboardEvent;
import org.jetbrains.skiko.SkikoKeyboardEventKind;
import org.jetbrains.skiko.SkikoMouseButtons;
import org.jetbrains.skiko.SkikoPointerEvent;
import org.jetbrains.skiko.SkikoPointerEventKind;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000d\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u000e\u0010\u0006\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u000b\u001a\u000e\u0010\u0006\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\f\u001a\u0010\u0010\r\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0001H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011\u001a\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\u000bH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014\u001a\u0018\u0010\u0015\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\u000bH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014\u001a\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\t\u001a\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\t2\b\u0010\u0019\u001a\u0004\u0018\u00010\t\u001a\n\u0010\u001b\u001a\u00020\u001c*\u00020\u001d\u001a\n\u0010\u001e\u001a\u00020\u001d*\u00020\u001c\u001a\n\u0010\u001f\u001a\u00020 *\u00020\u001d\u001a!\u0010!\u001a\u0004\u0018\u00010\"*\u00020#2\b\b\u0002\u0010$\u001a\u00020%H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010&\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0003\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006'"}, d2={"MouseEventButton4", "", "getMouseEventButton4", "()I", "MouseEventButton5", "getMouseEventButton5", "toSkikoEvent", "Lorg/jetbrains/skiko/SkikoKeyboardEvent;", "event", "Ljava/awt/event/KeyEvent;", "Lorg/jetbrains/skiko/SkikoPointerEvent;", "Ljava/awt/event/MouseEvent;", "Ljava/awt/event/MouseWheelEvent;", "toSkikoKey", "toSkikoModifiers", "Lorg/jetbrains/skiko/SkikoInputModifiers;", "modifiers", "(I)I", "toSkikoMouseButton", "Lorg/jetbrains/skiko/SkikoMouseButtons;", "(Ljava/awt/event/MouseEvent;)I", "toSkikoPressedMouseButtons", "toSkikoTypeEvent", "Lorg/jetbrains/skiko/SkikoInputEvent;", "Ljava/awt/event/InputMethodEvent;", "keyEvent", "typeEvent", "toBitmap", "Lorg/jetbrains/skia/Bitmap;", "Ljava/awt/image/BufferedImage;", "toBufferedImage", "toImage", "Lorg/jetbrains/skia/Image;", "toSkikoTypeface", "Lorg/jetbrains/skia/Typeface;", "Ljava/awt/Font;", "fontManager", "Lorg/jetbrains/skiko/AwtFontManager;", "(Ljava/awt/Font;Lorg/jetbrains/skiko/AwtFontManager;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "skiko"})
public final class Convertors_jvmKt {
    @NotNull
    public static final BufferedImage toBufferedImage(@NotNull Bitmap $this$toBufferedImage) {
        int[] nArray;
        Intrinsics.checkNotNullParameter((Object)$this$toBufferedImage, (String)"<this>");
        Pixmap pixmap = $this$toBufferedImage.peekPixels();
        Intrinsics.checkNotNull((Object)pixmap);
        long pixelsNativePointer = pixmap.getAddr();
        ByteBuffer pixelsBuffer = BufferUtil.INSTANCE.getByteBufferFromPointer(pixelsNativePointer, $this$toBufferedImage.getRowBytes() * $this$toBufferedImage.getHeight());
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toBufferedImage.getColorInfo().getColorType().ordinal()]) {
            case 1: {
                int[] nArray2 = new int[]{0, 1, 2, 3};
                nArray = nArray2;
                break;
            }
            case 2: {
                int[] nArray2 = new int[]{2, 1, 0, 3};
                nArray = nArray2;
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported color type " + (Object)((Object)$this$toBufferedImage.getColorInfo().getColorType()));
            }
        }
        int[] order = nArray;
        WritableRaster raster = Raster.createInterleavedRaster(new DirectDataBuffer(pixelsBuffer), $this$toBufferedImage.getWidth(), $this$toBufferedImage.getHeight(), $this$toBufferedImage.getWidth() * 4, 4, order, null);
        ComponentColorModel colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), true, false, 3, 0);
        ColorModel colorModel2 = colorModel;
        WritableRaster writableRaster = raster;
        Intrinsics.checkNotNull((Object)writableRaster);
        return new BufferedImage(colorModel2, writableRaster, false, null);
    }

    @NotNull
    public static final Bitmap toBitmap(@NotNull BufferedImage $this$toBitmap) {
        Intrinsics.checkNotNullParameter((Object)$this$toBitmap, (String)"<this>");
        int bytesPerPixel = 4;
        byte[] pixels = new byte[$this$toBitmap.getWidth() * $this$toBitmap.getHeight() * bytesPerPixel];
        int k = 0;
        int n = $this$toBitmap.getHeight();
        for (int y2 = 0; y2 < n; ++y2) {
            int n2 = $this$toBitmap.getWidth();
            for (int x2 = 0; x2 < n2; ++x2) {
                int argb = $this$toBitmap.getRGB(x2, y2);
                int a = argb >> 24 & 0xFF;
                int r = argb >> 16 & 0xFF;
                int g = argb >> 8 & 0xFF;
                int b = argb >> 0 & 0xFF;
                pixels[k++] = (byte)b;
                pixels[k++] = (byte)g;
                pixels[k++] = (byte)r;
                pixels[k++] = (byte)a;
            }
        }
        Bitmap bitmap = new Bitmap();
        bitmap.allocPixels(ImageInfo.Companion.makeS32($this$toBitmap.getWidth(), $this$toBitmap.getHeight(), ColorAlphaType.UNPREMUL));
        bitmap.installPixels(pixels);
        return bitmap;
    }

    @NotNull
    public static final Image toImage(@NotNull BufferedImage $this$toImage) {
        Intrinsics.checkNotNullParameter((Object)$this$toImage, (String)"<this>");
        return Image.Companion.makeFromBitmap(Convertors_jvmKt.toBitmap($this$toImage));
    }

    private static final int getMouseEventButton4() {
        return 4;
    }

    private static final int getMouseEventButton5() {
        return 5;
    }

    @NotNull
    public static final SkikoPointerEvent toSkikoEvent(@NotNull MouseEvent event) {
        SkikoPointerEventKind skikoPointerEventKind;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        double d = event.getX();
        double d2 = event.getY();
        int n = Convertors_jvmKt.toSkikoPressedMouseButtons(event);
        int n2 = Convertors_jvmKt.toSkikoMouseButton(event);
        int n3 = Convertors_jvmKt.toSkikoModifiers(event.getModifiersEx());
        switch (event.getID()) {
            case 501: {
                skikoPointerEventKind = SkikoPointerEventKind.DOWN;
                break;
            }
            case 502: {
                skikoPointerEventKind = SkikoPointerEventKind.UP;
                break;
            }
            case 506: {
                skikoPointerEventKind = SkikoPointerEventKind.DRAG;
                break;
            }
            case 503: {
                skikoPointerEventKind = SkikoPointerEventKind.MOVE;
                break;
            }
            case 504: {
                skikoPointerEventKind = SkikoPointerEventKind.ENTER;
                break;
            }
            case 505: {
                skikoPointerEventKind = SkikoPointerEventKind.EXIT;
                break;
            }
            default: {
                skikoPointerEventKind = SkikoPointerEventKind.UNKNOWN;
            }
        }
        SkikoPointerEventKind skikoPointerEventKind2 = skikoPointerEventKind;
        long l = event.getWhen();
        return new SkikoPointerEvent(d, d2, skikoPointerEventKind2, 0.0, 0.0, n, n2, n3, l, null, event, 536, null);
    }

    @NotNull
    public static final SkikoPointerEvent toSkikoEvent(@NotNull MouseWheelEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        double scrollAmount = event.getPreciseWheelRotation();
        int modifiers = Convertors_jvmKt.toSkikoModifiers(event.getModifiersEx());
        boolean isShiftPressed = SkikoInputModifiers.has-TH98kIg(modifiers, SkikoInputModifiers.Companion.getSHIFT-kKhcapQ());
        double deltaX = isShiftPressed ? scrollAmount : 0.0;
        double deltaY = isShiftPressed ? 0.0 : scrollAmount;
        double d = event.getX();
        double d2 = event.getY();
        int n = Convertors_jvmKt.toSkikoPressedMouseButtons(event);
        int n2 = Convertors_jvmKt.toSkikoMouseButton(event);
        SkikoPointerEventKind skikoPointerEventKind = event.getID() == 507 ? SkikoPointerEventKind.SCROLL : SkikoPointerEventKind.UNKNOWN;
        long l = event.getWhen();
        return new SkikoPointerEvent(d, d2, skikoPointerEventKind, deltaX, deltaY, n, n2, modifiers, l, null, event, 512, null);
    }

    @NotNull
    public static final SkikoKeyboardEvent toSkikoEvent(@NotNull KeyEvent event) {
        SkikoKeyboardEventKind skikoKeyboardEventKind;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        SkikoKey skikoKey = SkikoKey.Companion.valueOf(Convertors_jvmKt.toSkikoKey(event));
        int n = Convertors_jvmKt.toSkikoModifiers(event.getModifiersEx());
        switch (event.getID()) {
            case 401: {
                skikoKeyboardEventKind = SkikoKeyboardEventKind.DOWN;
                break;
            }
            case 402: {
                skikoKeyboardEventKind = SkikoKeyboardEventKind.UP;
                break;
            }
            default: {
                skikoKeyboardEventKind = SkikoKeyboardEventKind.UNKNOWN;
            }
        }
        return new SkikoKeyboardEvent(skikoKey, n, skikoKeyboardEventKind, event.getWhen(), event, null);
    }

    @NotNull
    public static final SkikoInputEvent toSkikoTypeEvent(@NotNull KeyEvent typeEvent, @Nullable KeyEvent keyEvent) {
        Intrinsics.checkNotNullParameter((Object)typeEvent, (String)"typeEvent");
        int key = -1;
        int modifiers = SkikoInputModifiers.Companion.getEMPTY-kKhcapQ();
        if (keyEvent != null) {
            key = Convertors_jvmKt.toSkikoKey(keyEvent);
            modifiers = Convertors_jvmKt.toSkikoModifiers(keyEvent.getModifiersEx());
        }
        return new SkikoInputEvent(String.valueOf(typeEvent.getKeyChar()), SkikoKey.Companion.valueOf(key), modifiers, SkikoKeyboardEventKind.TYPE, typeEvent, null);
    }

    @NotNull
    public static final SkikoInputEvent toSkikoTypeEvent(@NotNull InputMethodEvent event, @Nullable KeyEvent keyEvent) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        int key = -1;
        int modifiers = SkikoInputModifiers.Companion.getEMPTY-kKhcapQ();
        if (keyEvent != null) {
            key = Convertors_jvmKt.toSkikoKey(keyEvent);
            modifiers = Convertors_jvmKt.toSkikoModifiers(keyEvent.getModifiersEx());
        }
        return new SkikoInputEvent("", SkikoKey.Companion.valueOf(key), modifiers, SkikoKeyboardEventKind.TYPE, event, null);
    }

    private static final int toSkikoPressedMouseButtons(MouseEvent event) {
        int mask = event.getModifiersEx();
        int result = 0;
        if ((mask & 0x400) != 0 || event.getID() == 501 && event.getButton() == 1) {
            result |= SkikoMouseButtons.Companion.getLEFT-CuO1FYg();
        }
        if ((mask & 0x800) != 0 || event.getID() == 501 && event.getButton() == 2) {
            result |= SkikoMouseButtons.Companion.getMIDDLE-CuO1FYg();
        }
        if ((mask & 0x1000) != 0 || event.getID() == 501 && event.getButton() == 3) {
            result |= SkikoMouseButtons.Companion.getRIGHT-CuO1FYg();
        }
        if ((mask & MouseEvent.getMaskForButton(Convertors_jvmKt.getMouseEventButton4())) != 0 || event.getID() == 501 && event.getButton() == Convertors_jvmKt.getMouseEventButton4()) {
            result |= SkikoMouseButtons.Companion.getBUTTON_4-CuO1FYg();
        }
        if ((mask & MouseEvent.getMaskForButton(Convertors_jvmKt.getMouseEventButton5())) != 0 || event.getID() == 501 && event.getButton() == Convertors_jvmKt.getMouseEventButton5()) {
            result |= SkikoMouseButtons.Companion.getBUTTON_5-CuO1FYg();
        }
        return SkikoMouseButtons.constructor-impl(result);
    }

    private static final int toSkikoMouseButton(MouseEvent event) {
        int n = event.getButton();
        return n == 1 ? SkikoMouseButtons.Companion.getLEFT-CuO1FYg() : (n == 2 ? SkikoMouseButtons.Companion.getMIDDLE-CuO1FYg() : (n == 3 ? SkikoMouseButtons.Companion.getRIGHT-CuO1FYg() : (n == Convertors_jvmKt.getMouseEventButton4() ? SkikoMouseButtons.Companion.getBUTTON_4-CuO1FYg() : (n == Convertors_jvmKt.getMouseEventButton5() ? SkikoMouseButtons.Companion.getBUTTON_5-CuO1FYg() : SkikoMouseButtons.constructor-impl(event.getButton())))));
    }

    private static final int toSkikoModifiers(int modifiers) {
        int result = 0;
        if ((modifiers & 0x200) != 0) {
            result |= SkikoInputModifiers.Companion.getALT-kKhcapQ();
        }
        if ((modifiers & 0x40) != 0) {
            result |= SkikoInputModifiers.Companion.getSHIFT-kKhcapQ();
        }
        if ((modifiers & 0x80) != 0) {
            result |= SkikoInputModifiers.Companion.getCONTROL-kKhcapQ();
        }
        if ((modifiers & 0x100) != 0) {
            result |= SkikoInputModifiers.Companion.getMETA-kKhcapQ();
        }
        return SkikoInputModifiers.constructor-impl(result);
    }

    private static final int toSkikoKey(KeyEvent event) {
        int key = event.getKeyCode();
        int side = event.getKeyLocation();
        if (side == 3 && (key == SkikoKey.KEY_LEFT_CONTROL.getPlatformKeyCode() || key == SkikoKey.KEY_LEFT_SHIFT.getPlatformKeyCode() || key == SkikoKey.KEY_LEFT_META.getPlatformKeyCode())) {
            key |= Integer.MIN_VALUE;
        }
        if (side == 4 && key == SkikoKey.KEY_ENTER.getPlatformKeyCode()) {
            key |= Integer.MIN_VALUE;
        }
        return key;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object toSkikoTypeface(@NotNull Font var0, @NotNull AwtFontManager var1_1, @NotNull Continuation<? super Typeface> var2_2) {
        if (!(var2_2 instanceof toSkikoTypeface.1)) ** GOTO lbl-1000
        var5_3 = var2_2;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var2_2){
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return Convertors_jvmKt.toSkikoTypeface(null, null, (Continuation<? super Typeface>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = fontManager.findFontFile($this$toSkikoTypeface, (Continuation<? super File>)$continuation);
                if (v0 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                v1 = (File)v0;
                if (v1 == null) {
                    return null;
                }
                file = v1;
                return Typeface.Companion.makeFromData$default(Typeface.Companion, Data_jvmKt.makeFromFileName(Data.Companion, file.getAbsolutePath()), 0, 2, null);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object toSkikoTypeface$default(Font font, AwtFontManager awtFontManager, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            awtFontManager = AwtFontManager.Companion.getDEFAULT();
        }
        return Convertors_jvmKt.toSkikoTypeface(font, awtFontManager, (Continuation<? super Typeface>)continuation);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ColorType.values().length];
            try {
                nArray[ColorType.RGB_888X.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColorType.BGRA_8888.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

