/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.swing;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.util.ArrayList;
import java.util.List;
import javax.accessibility.Accessible;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skiko.ClipRectangle;
import org.jetbrains.skiko.ExperimentalSkikoApi;
import org.jetbrains.skiko.GpuPriority;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.Library;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkiaLayerProperties;
import org.jetbrains.skiko.SkiaLayer_awtKt;
import org.jetbrains.skiko.SkikoGestureEvent;
import org.jetbrains.skiko.SkikoInput;
import org.jetbrains.skiko.SkikoInputEvent;
import org.jetbrains.skiko.SkikoKeyboardEvent;
import org.jetbrains.skiko.SkikoLoggerInterface;
import org.jetbrains.skiko.SkikoPointerEvent;
import org.jetbrains.skiko.SkikoView;
import org.jetbrains.skiko.redrawer.RedrawerManager;
import org.jetbrains.skiko.swing.SkiaSwingLayer;
import org.jetbrains.skiko.swing.SwingLayerProperties;
import org.jetbrains.skiko.swing.SwingRedrawer;
import org.jetbrains.skiko.swing.SwingRedrawerKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0002\u001c\u001f\b\u0017\u0018\u0000 -2\u00020\u0001:\u0001-B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010!\u001a\u00020\"H\u0016J\u0006\u0010#\u001a\u00020\"J\u0012\u0010$\u001a\u00020\"2\b\b\u0002\u0010%\u001a\u00020\rH\u0002J\u0010\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\"H\u0016J\u0010\u0010*\u001a\u00020\"2\b\u0010+\u001a\u0004\u0018\u00010,R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0010\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u0010\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010 \u00a8\u0006."}, d2={"Lorg/jetbrains/skiko/swing/SkiaSwingLayer;", "Ljavax/swing/JComponent;", "skikoView", "Lorg/jetbrains/skiko/SkikoView;", "analytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "(Lorg/jetbrains/skiko/SkikoView;Lorg/jetbrains/skiko/SkiaLayerAnalytics;)V", "clipComponents", "", "Lorg/jetbrains/skiko/ClipRectangle;", "getClipComponents", "()Ljava/util/List;", "isDisposed", "", "isInitialized", "properties", "Lorg/jetbrains/skiko/SkiaLayerProperties;", "redrawer", "Lorg/jetbrains/skiko/swing/SwingRedrawer;", "getRedrawer", "()Lorg/jetbrains/skiko/swing/SwingRedrawer;", "redrawerManager", "Lorg/jetbrains/skiko/redrawer/RedrawerManager;", "renderApi", "Lorg/jetbrains/skiko/GraphicsApi;", "getRenderApi", "()Lorg/jetbrains/skiko/GraphicsApi;", "skikoViewWithClipping", "org/jetbrains/skiko/swing/SkiaSwingLayer$skikoViewWithClipping$1", "Lorg/jetbrains/skiko/swing/SkiaSwingLayer$skikoViewWithClipping$1;", "swingLayerProperties", "org/jetbrains/skiko/swing/SkiaSwingLayer$swingLayerProperties$1", "Lorg/jetbrains/skiko/swing/SkiaSwingLayer$swingLayerProperties$1;", "addNotify", "", "dispose", "init", "recreation", "paint", "g", "Ljava/awt/Graphics;", "removeNotify", "requestNativeFocusOnAccessible", "accessible", "Ljavax/accessibility/Accessible;", "Companion", "skiko"})
@ExperimentalSkikoApi
@SourceDebugExtension(value={"SMAP\nSkiaSwingLayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SkiaSwingLayer.kt\norg/jetbrains/skiko/swing/SkiaSwingLayer\n+ 2 Logging.kt\norg/jetbrains/skiko/Logger\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,125:1\n118#2,4:126\n118#2,4:130\n159#2,4:135\n1#3:134\n*S KotlinDebug\n*F\n+ 1 SkiaSwingLayer.kt\norg/jetbrains/skiko/swing/SkiaSwingLayer\n*L\n82#1:126,4\n88#1:130,4\n114#1:135,4\n*E\n"})
public class SkiaSwingLayer
extends JComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SkiaLayerProperties properties;
    private boolean isInitialized;
    private volatile boolean isDisposed;
    @NotNull
    private final skikoViewWithClipping.1 skikoViewWithClipping;
    @NotNull
    private final swingLayerProperties.1 swingLayerProperties;
    @NotNull
    private final RedrawerManager<SwingRedrawer> redrawerManager;

    public SkiaSwingLayer(@NotNull SkikoView skikoView, @NotNull SkiaLayerAnalytics analytics) {
        Intrinsics.checkNotNullParameter((Object)skikoView, (String)"skikoView");
        Intrinsics.checkNotNullParameter((Object)analytics, (String)"analytics");
        this.properties = new SkiaLayerProperties(false, false, null, null, 15, null);
        this.skikoViewWithClipping = new SkikoView(skikoView, this){
            private final /* synthetic */ SkikoView $$delegate_0;
            final /* synthetic */ SkikoView $skikoView;
            final /* synthetic */ SkiaSwingLayer this$0;
            {
                this.$skikoView = $skikoView;
                this.this$0 = $receiver;
                this.$$delegate_0 = $skikoView;
            }

            @NotNull
            public SkikoInput getInput() {
                return this.$$delegate_0.getInput();
            }

            public void onGestureEvent(@NotNull SkikoGestureEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$$delegate_0.onGestureEvent(event);
            }

            @Deprecated(message="This method will be removed. Use override val input: SkikoInput")
            public void onInputEvent(@NotNull SkikoInputEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$$delegate_0.onInputEvent(event);
            }

            public void onKeyboardEvent(@NotNull SkikoKeyboardEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$$delegate_0.onKeyboardEvent(event);
            }

            public void onPointerEvent(@NotNull SkikoPointerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$$delegate_0.onPointerEvent(event);
            }

            public void onRender(@NotNull Canvas canvas, int width2, int height2, long nanoTime) {
                Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
                float scale = (float)this.this$0.getGraphicsConfiguration().getDefaultTransform().getScaleX();
                for (ClipRectangle component : this.this$0.getClipComponents()) {
                    SkiaLayer_awtKt.clipRectBy(canvas, component, scale);
                }
                this.$skikoView.onRender(canvas, width2, height2, nanoTime);
            }
        };
        this.swingLayerProperties = new SwingLayerProperties(this){
            final /* synthetic */ SkiaSwingLayer this$0;
            {
                this.this$0 = $receiver;
            }

            public int getWidth() {
                return this.this$0.getWidth();
            }

            public int getHeight() {
                return this.this$0.getHeight();
            }

            @NotNull
            public GraphicsConfiguration getGraphicsConfiguration() {
                GraphicsConfiguration graphicsConfiguration = this.this$0.getGraphicsConfiguration();
                Intrinsics.checkNotNullExpressionValue((Object)graphicsConfiguration, (String)"getGraphicsConfiguration(...)");
                return graphicsConfiguration;
            }

            @NotNull
            public GpuPriority getAdapterPriority() {
                return SkiaSwingLayer.access$getProperties$p(this.this$0).getAdapterPriority();
            }
        };
        this.redrawerManager = new RedrawerManager(this.properties.getRenderApi(), (Function2)new Function2<GraphicsApi, SwingRedrawer, SwingRedrawer>(this, analytics){
            final /* synthetic */ SkiaSwingLayer this$0;
            final /* synthetic */ SkiaLayerAnalytics $analytics;
            {
                this.this$0 = $receiver;
                this.$analytics = $analytics;
                super(2);
            }

            @NotNull
            public final SwingRedrawer invoke(@NotNull GraphicsApi renderApi, @Nullable SwingRedrawer oldRedrawer) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)((Object)renderApi), (String)"renderApi");
                    SwingRedrawer swingRedrawer = oldRedrawer;
                    if (swingRedrawer == null) break block0;
                    swingRedrawer.dispose();
                }
                return SwingRedrawerKt.createSwingRedrawer(SkiaSwingLayer.access$getSwingLayerProperties$p(this.this$0), SkiaSwingLayer.access$getSkikoViewWithClipping$p(this.this$0), renderApi, this.$analytics);
            }
        });
        this.setOpaque(false);
        this.setLayout(null);
    }

    public /* synthetic */ SkiaSwingLayer(SkikoView skikoView, SkiaLayerAnalytics skiaLayerAnalytics, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            skiaLayerAnalytics = SkiaLayerAnalytics.Companion.getEmpty();
        }
        this(skikoView, skiaLayerAnalytics);
    }

    @NotNull
    public final List<ClipRectangle> getClipComponents() {
        return new ArrayList();
    }

    private final SwingRedrawer getRedrawer() {
        return this.redrawerManager.getRedrawer();
    }

    @NotNull
    public final GraphicsApi getRenderApi() {
        return this.redrawerManager.getRenderApi();
    }

    @Override
    public void removeNotify() {
        Logger this_$iv = Logger.INSTANCE;
        boolean $i$f$debug = false;
        if (this_$iv.getLoggerImpl().isDebugEnabled()) {
            SkikoLoggerInterface skikoLoggerInterface = this_$iv.getLoggerImpl();
            boolean bl = false;
            skikoLoggerInterface.debug("SkiaSwingLayer.awt#removeNotify " + this);
        }
        this.dispose();
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        Logger this_$iv = Logger.INSTANCE;
        boolean $i$f$debug = false;
        if (this_$iv.getLoggerImpl().isDebugEnabled()) {
            SkikoLoggerInterface skikoLoggerInterface = this_$iv.getLoggerImpl();
            boolean bl = false;
            skikoLoggerInterface.debug("SkiaSwingLayer.awt#addNotify " + this);
        }
        super.addNotify();
        this.init(this.isInitialized);
    }

    private final void init(boolean recreation) {
        this.isDisposed = false;
        this.redrawerManager.findNextWorkingRenderApi(recreation);
        this.isInitialized = true;
    }

    static /* synthetic */ void init$default(SkiaSwingLayer skiaSwingLayer, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: init");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        skiaSwingLayer.init(bl);
    }

    public final void dispose() {
        if (!SwingUtilities.isEventDispatchThread()) {
            boolean bl = false;
            String string = "Method should be called from AWT event dispatch thread";
            throw new IllegalStateException(string.toString());
        }
        if (this.isInitialized && !this.isDisposed) {
            SwingRedrawer swingRedrawer = this.getRedrawer();
            if (swingRedrawer != null) {
                swingRedrawer.dispose();
            }
            this.redrawerManager.dispose();
            this.isDisposed = true;
        }
    }

    @Override
    public void paint(@NotNull Graphics g) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            try {
                SwingRedrawer swingRedrawer = this.getRedrawer();
                if (swingRedrawer != null) {
                    swingRedrawer.redraw((Graphics2D)g);
                }
            }
            catch (RenderException e) {
                if (this.isDisposed) break block4;
                Logger this_$iv = Logger.INSTANCE;
                boolean $i$f$warn = false;
                if (this_$iv.getLoggerImpl().isWarnEnabled()) {
                    Throwable throwable = e;
                    SkikoLoggerInterface skikoLoggerInterface = this_$iv.getLoggerImpl();
                    boolean bl = false;
                    String string = "Exception in draw scope";
                    skikoLoggerInterface.warn(throwable, string);
                }
                RedrawerManager.findNextWorkingRenderApi$default(this.redrawerManager, false, 1, null);
                this.repaint();
            }
        }
    }

    public final void requestNativeFocusOnAccessible(@Nullable Accessible accessible) {
    }

    public static final /* synthetic */ SkiaLayerProperties access$getProperties$p(SkiaSwingLayer $this) {
        return $this.properties;
    }

    public static final /* synthetic */ swingLayerProperties.1 access$getSwingLayerProperties$p(SkiaSwingLayer $this) {
        return $this.swingLayerProperties;
    }

    public static final /* synthetic */ skikoViewWithClipping.1 access$getSkikoViewWithClipping$p(SkiaSwingLayer $this) {
        return $this.skikoViewWithClipping;
    }

    static {
        Library.INSTANCE.load();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/skiko/swing/SkiaSwingLayer$Companion;", "", "()V", "skiko"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

