/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.crypto.convert;

import java.io.IOException;
import jetbrains.exodus.crypto.convert.EncryptListener;
import jetbrains.exodus.crypto.convert.FileHeader;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/exodus/crypto/convert/ArchiveEncryptListenerFactory;", "Lmu/KLogging;", "()V", "newListener", "Ljetbrains/exodus/crypto/convert/EncryptListener;", "archive", "Lorg/apache/commons/compress/archivers/ArchiveOutputStream;", "xodus-crypto"})
public final class ArchiveEncryptListenerFactory
extends KLogging {
    @NotNull
    public static final ArchiveEncryptListenerFactory INSTANCE = new ArchiveEncryptListenerFactory();

    private ArchiveEncryptListenerFactory() {
    }

    @NotNull
    public final EncryptListener newListener(@NotNull ArchiveOutputStream archive) {
        EncryptListener encryptListener;
        Intrinsics.checkNotNullParameter((Object)archive, (String)"archive");
        ArchiveOutputStream archiveOutputStream = archive;
        if (archiveOutputStream instanceof TarArchiveOutputStream) {
            encryptListener = new EncryptListener(archive){
                final /* synthetic */ ArchiveOutputStream $archive;
                {
                    this.$archive = $archive;
                }

                public void onFile(@NotNull FileHeader header) {
                    Intrinsics.checkNotNullParameter((Object)header, (String)"header");
                    ArchiveEncryptListenerFactory.INSTANCE.getLogger().debug((Function0)new Function0<Object>(header){
                        final /* synthetic */ FileHeader $header;
                        {
                            this.$header = $header;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return Intrinsics.stringPlus((String)"Start file ", (Object)this.$header);
                        }
                    });
                    TarArchiveEntry entry = new TarArchiveEntry(Intrinsics.stringPlus((String)header.getPath(), (Object)header.getName()));
                    entry.setSize(header.getSize());
                    entry.setModTime(header.getTimestamp());
                    this.$archive.putArchiveEntry((ArchiveEntry)entry);
                }

                public void onFileEnd(@NotNull FileHeader header) {
                    Intrinsics.checkNotNullParameter((Object)header, (String)"header");
                    this.$archive.closeArchiveEntry();
                }

                public void onData(@NotNull FileHeader header, int size, @NotNull byte[] data) {
                    Intrinsics.checkNotNullParameter((Object)header, (String)"header");
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    this.$archive.write(data, 0, size);
                }
            };
        } else if (archiveOutputStream instanceof ZipArchiveOutputStream) {
            encryptListener = new EncryptListener(archive){
                final /* synthetic */ ArchiveOutputStream $archive;
                {
                    this.$archive = $archive;
                }

                public void onFile(@NotNull FileHeader header) {
                    Intrinsics.checkNotNullParameter((Object)header, (String)"header");
                    ArchiveEncryptListenerFactory.INSTANCE.getLogger().debug((Function0)new Function0<Object>(header){
                        final /* synthetic */ FileHeader $header;
                        {
                            this.$header = $header;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return Intrinsics.stringPlus((String)"Start file ", (Object)this.$header);
                        }
                    });
                    ZipArchiveEntry entry = new ZipArchiveEntry(Intrinsics.stringPlus((String)header.getPath(), (Object)header.getName()));
                    entry.setSize(header.getSize());
                    entry.setTime(header.getTimestamp());
                    this.$archive.putArchiveEntry((ArchiveEntry)entry);
                }

                public void onFileEnd(@NotNull FileHeader header) {
                    Intrinsics.checkNotNullParameter((Object)header, (String)"header");
                    this.$archive.closeArchiveEntry();
                }

                public void onData(@NotNull FileHeader header, int size, @NotNull byte[] data) {
                    Intrinsics.checkNotNullParameter((Object)header, (String)"header");
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    this.$archive.write(data, 0, size);
                }
            };
        } else {
            throw new IOException("Unknown archive output stream");
        }
        return encryptListener;
    }
}

