/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.crypto.convert;

import java.io.Closeable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import jetbrains.exodus.crypto.EnvKryptKt;
import jetbrains.exodus.crypto.StreamCipher;
import jetbrains.exodus.crypto.StreamCipherProvider;
import jetbrains.exodus.crypto.convert.EncryptListener;
import jetbrains.exodus.crypto.convert.EncryptMessage;
import jetbrains.exodus.crypto.convert.EndChunk;
import jetbrains.exodus.crypto.convert.FileChunk;
import jetbrains.exodus.crypto.convert.FileHeader;
import jetbrains.exodus.crypto.convert.ScytaleEngine;
import jetbrains.exodus.util.ByteArraySpinAllocator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006*\u0001$\u0018\u0000 -2\u00020\u0001:\u0001-BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u0012\b\b\u0002\u0010\r\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010&\u001a\u00020\u0007J\u0006\u0010'\u001a\u00020(J\b\u0010)\u001a\u00020(H\u0016J\u000e\u0010*\u001a\u00020(2\u0006\u0010+\u001a\u00020\u001fJ\u0006\u0010,\u001a\u00020(R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010%\u00a8\u0006."}, d2={"Ljetbrains/exodus/crypto/convert/ScytaleEngine;", "Ljava/io/Closeable;", "listener", "Ljetbrains/exodus/crypto/convert/EncryptListener;", "cipherProvider", "Ljetbrains/exodus/crypto/StreamCipherProvider;", "key", "", "basicIV", "", "blockAlignment", "", "bufferSize", "inputQueueSize", "outputQueueSize", "(Ljetbrains/exodus/crypto/convert/EncryptListener;Ljetbrains/exodus/crypto/StreamCipherProvider;[BJIIII)V", "bufferAllocator", "Ljetbrains/exodus/util/ByteArraySpinAllocator;", "cancelled", "", "consumer", "Ljava/lang/Thread;", "consumerFinished", "error", "", "getError", "()Ljava/lang/Throwable;", "setError", "(Ljava/lang/Throwable;)V", "inputQueue", "Ljava/util/concurrent/ArrayBlockingQueue;", "Ljetbrains/exodus/crypto/convert/EncryptMessage;", "outputQueue", "producer", "producerFinished", "statefulProducer", "jetbrains/exodus/crypto/convert/ScytaleEngine$statefulProducer$1", "Ljetbrains/exodus/crypto/convert/ScytaleEngine$statefulProducer$1;", "alloc", "cancel", "", "close", "put", "e", "start", "Companion", "xodus-crypto"})
public final class ScytaleEngine
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EncryptListener listener;
    @NotNull
    private final StreamCipherProvider cipherProvider;
    @NotNull
    private final byte[] key;
    private final long basicIV;
    private final int blockAlignment;
    @NotNull
    private final ArrayBlockingQueue<EncryptMessage> inputQueue;
    @NotNull
    private final ArrayBlockingQueue<EncryptMessage> outputQueue;
    @NotNull
    private final ByteArraySpinAllocator bufferAllocator;
    private volatile boolean producerFinished;
    private volatile boolean consumerFinished;
    private volatile boolean cancelled;
    @Nullable
    private volatile Throwable error;
    @NotNull
    private final statefulProducer.1 statefulProducer;
    @NotNull
    private final Thread producer;
    @NotNull
    private final Thread consumer;
    private static final long timeout = 200L;

    public ScytaleEngine(@NotNull EncryptListener listener, @NotNull StreamCipherProvider cipherProvider, @NotNull byte[] key, long basicIV, int blockAlignment, int bufferSize, int inputQueueSize, int outputQueueSize) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)cipherProvider, (String)"cipherProvider");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.listener = listener;
        this.cipherProvider = cipherProvider;
        this.key = key;
        this.basicIV = basicIV;
        this.blockAlignment = blockAlignment;
        this.inputQueue = new ArrayBlockingQueue(inputQueueSize);
        this.outputQueue = new ArrayBlockingQueue(outputQueueSize);
        this.bufferAllocator = new ByteArraySpinAllocator(bufferSize, inputQueueSize + outputQueueSize + 4);
        this.statefulProducer = new Runnable(this){
            @NotNull
            private final StreamCipher cipher;
            private int offset;
            private long iv;
            final /* synthetic */ ScytaleEngine this$0;
            {
                this.this$0 = $receiver;
                StreamCipher streamCipher = ScytaleEngine.access$getCipherProvider$p(this.this$0).newCipher();
                Intrinsics.checkNotNullExpressionValue((Object)streamCipher, (String)"cipherProvider.newCipher()");
                this.cipher = streamCipher;
            }

            public void run() {
                try {
                    while (!ScytaleEngine.access$getCancelled$p(this.this$0) && this.this$0.getError() == null) {
                        Unit unit;
                        Unit unit2;
                        if ((EncryptMessage)ScytaleEngine.access$getInputQueue$p(this.this$0).poll(ScytaleEngine.Companion.getTimeout(), TimeUnit.MILLISECONDS) == null) {
                            unit2 = null;
                        } else {
                            EncryptMessage encryptMessage;
                            ScytaleEngine scytaleEngine = this.this$0;
                            EncryptMessage it = encryptMessage;
                            boolean bl = false;
                            EncryptMessage encryptMessage2 = it;
                            if (encryptMessage2 instanceof FileHeader) {
                                this.offset = 0;
                                this.iv = ScytaleEngine.access$getBasicIV$p(scytaleEngine) + (((FileHeader)it).getChunkedIV() ? ((FileHeader)it).getHandle() / (long)ScytaleEngine.access$getBlockAlignment$p(scytaleEngine) : ((FileHeader)it).getHandle());
                                this.cipher.init(ScytaleEngine.access$getKey$p(scytaleEngine), EnvKryptKt.asHashedIV((long)this.iv));
                            } else if (encryptMessage2 instanceof FileChunk) {
                                this.encryptChunk((FileChunk)it);
                            } else if (!(encryptMessage2 instanceof EndChunk)) {
                                throw new IllegalArgumentException();
                            }
                            while (!ScytaleEngine.access$getOutputQueue$p(scytaleEngine).offer(it, ScytaleEngine.Companion.getTimeout(), TimeUnit.MILLISECONDS)) {
                                if (!ScytaleEngine.access$getCancelled$p(scytaleEngine) && scytaleEngine.getError() == null) continue;
                                return;
                            }
                            unit2 = Unit.INSTANCE;
                        }
                        if ((unit = unit2) != null || !ScytaleEngine.access$getProducerFinished$p(this.this$0)) continue;
                        return;
                    }
                }
                catch (Throwable t) {
                    ScytaleEngine.access$setProducerFinished$p(this.this$0, true);
                    this.this$0.setError(t);
                }
            }

            private final void encryptChunk(FileChunk it) {
                if (it.getHeader().getCanBeEncrypted()) {
                    byte[] data = it.getData();
                    if (it.getHeader().getChunkedIV()) {
                        this.blockEncrypt(it.getSize(), data);
                    } else {
                        this.encrypt(it.getSize(), data);
                    }
                }
            }

            private final void encrypt(int size, byte[] data) {
                int n = 0;
                while (n < size) {
                    int i = n++;
                    data[i] = this.cipher.crypt(data[i]);
                }
            }

            private final void blockEncrypt(int size, byte[] data) {
                int n = 0;
                while (n < size) {
                    int i = n++;
                    data[i] = this.cipher.crypt(data[i]);
                    ++this.offset;
                    if (this.offset != ScytaleEngine.access$getBlockAlignment$p(this.this$0)) continue;
                    this.offset = 0;
                    ++this.iv;
                    this.cipher.init(ScytaleEngine.access$getKey$p(this.this$0), EnvKryptKt.asHashedIV((long)this.iv));
                }
            }
        };
        this.producer = new Thread((Runnable)this.statefulProducer, Intrinsics.stringPlus((String)"xodus encrypt ", (Object)this.hashCode()));
        this.consumer = new Thread(() -> ScytaleEngine.consumer$lambda-3(this), Intrinsics.stringPlus((String)"xodus write ", (Object)this.hashCode()));
    }

    public /* synthetic */ ScytaleEngine(EncryptListener encryptListener, StreamCipherProvider streamCipherProvider, byte[] byArray, long l, int n, int n2, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 0x10) != 0) {
            n = 1024;
        }
        if ((n5 & 0x20) != 0) {
            n2 = 0x100000;
        }
        if ((n5 & 0x40) != 0) {
            n3 = 40;
        }
        if ((n5 & 0x80) != 0) {
            n4 = 40;
        }
        this(encryptListener, streamCipherProvider, byArray, l, n, n2, n3, n4);
    }

    @Nullable
    public final Throwable getError() {
        return this.error;
    }

    public final void setError(@Nullable Throwable throwable) {
        this.error = throwable;
    }

    public final void start() {
        this.producer.start();
        this.consumer.start();
    }

    @NotNull
    public final byte[] alloc() {
        Object object = this.bufferAllocator.alloc();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"bufferAllocator.alloc()");
        return (byte[])object;
    }

    public final void put(@NotNull EncryptMessage e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        while (!this.inputQueue.offer(e, timeout, TimeUnit.MILLISECONDS)) {
            if (this.error == null) continue;
            throw new RuntimeException(this.error);
        }
    }

    public final void cancel() {
        this.cancelled = true;
    }

    @Override
    public void close() {
        this.producerFinished = true;
        this.producer.join();
        this.consumerFinished = true;
        this.consumer.join();
        Throwable throwable = this.error;
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            throw new RuntimeException(it);
        }
    }

    private static final void consumer$lambda-3(ScytaleEngine this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            EncryptMessage currentFile = null;
            while (!this$0.cancelled && this$0.error == null) {
                Unit unit;
                Object object;
                if (this$0.outputQueue.poll(timeout, TimeUnit.MILLISECONDS) == null) {
                    object = null;
                } else {
                    FileHeader it;
                    EncryptMessage it2;
                    boolean bl = false;
                    EncryptMessage encryptMessage = it2;
                    if (encryptMessage instanceof FileHeader) {
                        if ((FileHeader)currentFile != null) {
                            boolean bl2 = false;
                            this$0.listener.onFileEnd(it);
                        }
                        currentFile = it2;
                        this$0.listener.onFile((FileHeader)it2);
                        object = Unit.INSTANCE;
                    } else if (encryptMessage instanceof FileChunk) {
                        FileHeader current = (FileHeader)currentFile;
                        if (current != null && !Intrinsics.areEqual((Object)current, (Object)((FileChunk)it2).getHeader())) {
                            throw new Throwable(Intrinsics.stringPlus((String)"Invalid chunk with header ", (Object)((FileChunk)it2).getHeader().getPath()));
                        }
                        this$0.listener.onData(((FileChunk)it2).getHeader(), ((FileChunk)it2).getSize(), ((FileChunk)it2).getData());
                        object = this$0.bufferAllocator.dispose((Object)((FileChunk)it2).getData());
                    } else if (encryptMessage instanceof EndChunk) {
                        if ((FileHeader)currentFile == null) {
                            object = null;
                        } else {
                            boolean bl3 = false;
                            this$0.listener.onFileEnd(it);
                            object = Unit.INSTANCE;
                        }
                    } else {
                        throw new IllegalArgumentException();
                    }
                }
                if ((unit = object) != null || !this$0.consumerFinished) continue;
                return;
            }
        }
        catch (Throwable t) {
            this$0.consumerFinished = true;
            this$0.error = t;
        }
    }

    public static final /* synthetic */ StreamCipherProvider access$getCipherProvider$p(ScytaleEngine $this) {
        return $this.cipherProvider;
    }

    public static final /* synthetic */ boolean access$getCancelled$p(ScytaleEngine $this) {
        return $this.cancelled;
    }

    public static final /* synthetic */ ArrayBlockingQueue access$getInputQueue$p(ScytaleEngine $this) {
        return $this.inputQueue;
    }

    public static final /* synthetic */ boolean access$getProducerFinished$p(ScytaleEngine $this) {
        return $this.producerFinished;
    }

    public static final /* synthetic */ void access$setProducerFinished$p(ScytaleEngine $this, boolean bl) {
        $this.producerFinished = bl;
    }

    public static final /* synthetic */ int access$getBlockAlignment$p(ScytaleEngine $this) {
        return $this.blockAlignment;
    }

    public static final /* synthetic */ byte[] access$getKey$p(ScytaleEngine $this) {
        return $this.key;
    }

    public static final /* synthetic */ long access$getBasicIV$p(ScytaleEngine $this) {
        return $this.basicIV;
    }

    public static final /* synthetic */ ArrayBlockingQueue access$getOutputQueue$p(ScytaleEngine $this) {
        return $this.outputQueue;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/exodus/crypto/convert/ScytaleEngine$Companion;", "Lmu/KLogging;", "()V", "timeout", "", "getTimeout", "()J", "xodus-crypto"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public final long getTimeout() {
            return timeout;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

