/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore;

import java.util.regex.Pattern;
import jetbrains.exodus.core.dataStructures.ConcurrentObjectCache;
import jetbrains.exodus.entitystore.PersistentEntityId;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\bH\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ljetbrains/exodus/entitystore/EntityIdCache;", "", "()V", "ID_SPLIT_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "theCache", "Ljetbrains/exodus/core/dataStructures/ConcurrentObjectCache;", "", "Ljetbrains/exodus/entitystore/PersistentEntityId;", "getEntityId", "representation", "xodus-entity-store"})
public final class EntityIdCache {
    private static final Pattern ID_SPLIT_PATTERN;
    private static final ConcurrentObjectCache<CharSequence, PersistentEntityId> theCache;
    public static final EntityIdCache INSTANCE;

    @JvmStatic
    @NotNull
    public static final PersistentEntityId getEntityId(@NotNull CharSequence representation) {
        Intrinsics.checkParameterIsNotNull((Object)representation, (String)"representation");
        PersistentEntityId result = (PersistentEntityId)theCache.tryKey((Object)representation);
        if (result == null) {
            String[] idParts = ID_SPLIT_PATTERN.split(representation);
            int partsCount = idParts.length;
            if (partsCount != 2) {
                throw (Throwable)new IllegalArgumentException("Invalid structure of entity id: " + representation);
            }
            int entityTypeId = Integer.parseInt(idParts[0]);
            long entityLocalId = Long.parseLong(idParts[1]);
            result = new PersistentEntityId(entityTypeId, entityLocalId);
            theCache.cacheObject((Object)representation, (Object)result);
        }
        return result;
    }

    private EntityIdCache() {
    }

    static {
        EntityIdCache entityIdCache;
        INSTANCE = entityIdCache = new EntityIdCache();
        ID_SPLIT_PATTERN = Pattern.compile("-");
        Integer n = Integer.getInteger("jetbrains.exodus.entitystore.entityIdCacheSize", 2991);
        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"Integer.getInteger(\"jetb\u2026ityIdCacheSize\", 997 * 3)");
        theCache = new ConcurrentObjectCache(n.intValue());
    }
}

