/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.ComparableBinding;
import jetbrains.exodus.bindings.ComparableSet;
import jetbrains.exodus.bindings.IntegerBinding;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.core.dataStructures.Pair;
import jetbrains.exodus.core.dataStructures.hash.IntHashMap;
import jetbrains.exodus.core.dataStructures.hash.IntHashSet;
import jetbrains.exodus.core.dataStructures.hash.LongHashMap;
import jetbrains.exodus.core.dataStructures.hash.LongHashSet;
import jetbrains.exodus.core.dataStructures.hash.LongIterator;
import jetbrains.exodus.core.dataStructures.hash.LongSet;
import jetbrains.exodus.core.dataStructures.hash.PackedLongHashSet;
import jetbrains.exodus.core.dataStructures.persistent.PersistentLong23TreeSet;
import jetbrains.exodus.core.dataStructures.persistent.PersistentLongSet;
import jetbrains.exodus.entitystore.BlobVault;
import jetbrains.exodus.entitystore.BlobVaultItem;
import jetbrains.exodus.entitystore.DiskBasedBlobVault;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityStoreException;
import jetbrains.exodus.entitystore.FileSystemBlobVaultOld;
import jetbrains.exodus.entitystore.PersistentEntity;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.Settings;
import jetbrains.exodus.entitystore.StoreTransaction;
import jetbrains.exodus.entitystore.StoreTransactionalComputable;
import jetbrains.exodus.entitystore.StoreTransactionalExecutable;
import jetbrains.exodus.entitystore.tables.BlobsTable;
import jetbrains.exodus.entitystore.tables.LinkValue;
import jetbrains.exodus.entitystore.tables.LinksTable;
import jetbrains.exodus.entitystore.tables.PropertiesTable;
import jetbrains.exodus.entitystore.tables.PropertyKey;
import jetbrains.exodus.entitystore.tables.PropertyTypes;
import jetbrains.exodus.entitystore.tables.PropertyValue;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.ReadonlyTransactionException;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.env.TransactionalExecutable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PersistentEntityStoreRefactorings {
    private static final Logger logger = LoggerFactory.getLogger(PersistentEntityStoreRefactorings.class);
    @NotNull
    private final PersistentEntityStoreImpl store;

    PersistentEntityStoreRefactorings(@NotNull PersistentEntityStoreImpl store) {
        this.store = store;
    }

    void refactorDeleteRedundantBlobs() {
        BlobVault blobVault = this.store.getBlobVault();
        if (blobVault instanceof FileSystemBlobVaultOld) {
            PersistentEntityStoreRefactorings.logInfo("Deleting redundant blobs...");
            final FileSystemBlobVaultOld fsBlobVault = (FileSystemBlobVaultOld)blobVault;
            Long nextBlobHandle = this.store.computeInReadonlyTransaction(new StoreTransactionalComputable<Long>(){

                public Long compute(@NotNull StoreTransaction tx) {
                    PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                    return fsBlobVault.nextHandle(txn.getEnvironmentTransaction());
                }
            });
            for (int i = 0; i < 10000; ++i) {
                BlobVaultItem item = fsBlobVault.getBlob(nextBlobHandle + (long)i);
                if (!item.exists()) continue;
                if (fsBlobVault.delete(item.getHandle())) {
                    PersistentEntityStoreRefactorings.logInfo("Deleted " + item);
                    continue;
                }
                logger.error("Failed to delete " + item);
            }
        }
    }

    void refactorEntitiesTables() {
        this.store.executeInReadonlyTransaction(new StoreTransactionalExecutable(){

            public void execute(@NotNull StoreTransaction tx) {
                PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                for (String entityType : PersistentEntityStoreRefactorings.this.store.getEntityTypes(txn)) {
                    int entityTypeId = PersistentEntityStoreRefactorings.this.store.getEntityTypeId(txn, entityType, false);
                    String sourceName = PersistentEntityStoreRefactorings.this.store.getNamingRules().getEntitiesTableName(entityTypeId);
                    String targetName = sourceName + "_temp";
                    if (logger.isInfoEnabled()) {
                        logger.info("Refactoring " + sourceName + " to key-prefixed store.");
                    }
                    PersistentEntityStoreRefactorings.this.transactionalCopyAndRemoveEntitiesStore(sourceName, targetName);
                    PersistentEntityStoreRefactorings.this.transactionalCopyAndRemoveEntitiesStore(targetName, sourceName);
                }
            }
        });
    }

    void refactorCreateNullPropertyIndices() {
        this.store.executeInReadonlyTransaction(new StoreTransactionalExecutable(){

            public void execute(@NotNull StoreTransaction tx) {
                PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                for (final String entityType : PersistentEntityStoreRefactorings.this.store.getEntityTypes(txn)) {
                    if (logger.isInfoEnabled()) {
                        logger.info("Refactoring creating null-value property indices for [" + entityType + ']');
                    }
                    PersistentEntityStoreRefactorings.this.safeExecuteRefactoringForEntityType(entityType, new StoreTransactionalExecutable(){

                        public void execute(@NotNull StoreTransaction tx) {
                            PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                            int entityTypeId = PersistentEntityStoreRefactorings.this.store.getEntityTypeId(txn, entityType, false);
                            PropertiesTable props = PersistentEntityStoreRefactorings.this.store.getPropertiesTable(txn, entityTypeId);
                            Store allPropsIndex = props.getAllPropsIndex();
                            Cursor cursor = PersistentEntityStoreRefactorings.this.store.getPrimaryPropertyIndexCursor(txn, entityTypeId);
                            Transaction envTxn = txn.getEnvironmentTransaction();
                            while (cursor.getNext()) {
                                PropertyKey propertyKey = PropertyKey.entryToPropertyKey(cursor.getKey());
                                allPropsIndex.put(envTxn, (ByteIterable)IntegerBinding.intToCompressedEntry((int)propertyKey.getPropertyId()), (ByteIterable)LongBinding.longToCompressedEntry((long)propertyKey.getEntityLocalId()));
                            }
                            cursor.close();
                        }
                    });
                }
            }
        });
    }

    void refactorCreateNullBlobIndices() {
        this.store.executeInReadonlyTransaction(new StoreTransactionalExecutable(){

            public void execute(@NotNull StoreTransaction tx) {
                PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                for (final String entityType : PersistentEntityStoreRefactorings.this.store.getEntityTypes(txn)) {
                    if (logger.isInfoEnabled()) {
                        logger.info("Refactoring creating null-value blob indices for [" + entityType + ']');
                    }
                    PersistentEntityStoreRefactorings.this.safeExecuteRefactoringForEntityType(entityType, new StoreTransactionalExecutable(){

                        public void execute(@NotNull StoreTransaction tx) {
                            PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                            int entityTypeId = PersistentEntityStoreRefactorings.this.store.getEntityTypeId(txn, entityType, false);
                            BlobsTable blobs = PersistentEntityStoreRefactorings.this.store.getBlobsTable(txn, entityTypeId);
                            Store allBlobsIndex = blobs.getAllBlobsIndex();
                            Transaction envTxn = txn.getEnvironmentTransaction();
                            Cursor cursor = blobs.getPrimaryIndex().openCursor(envTxn);
                            while (cursor.getNext()) {
                                PropertyKey propertyKey = PropertyKey.entryToPropertyKey(cursor.getKey());
                                allBlobsIndex.put(envTxn, (ByteIterable)IntegerBinding.intToCompressedEntry((int)propertyKey.getPropertyId()), (ByteIterable)LongBinding.longToCompressedEntry((long)propertyKey.getEntityLocalId()));
                            }
                            cursor.close();
                        }
                    });
                }
            }
        });
    }

    void refactorBlobFileLengths() {
        BlobVault blobVault = this.store.getBlobVault();
        if (blobVault instanceof DiskBasedBlobVault) {
            final DiskBasedBlobVault diskVault = (DiskBasedBlobVault)blobVault;
            this.store.executeInReadonlyTransaction(new StoreTransactionalExecutable(){

                public void execute(@NotNull StoreTransaction tx) {
                    PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                    for (final String entityType : PersistentEntityStoreRefactorings.this.store.getEntityTypes(txn)) {
                        if (logger.isInfoEnabled()) {
                            logger.info("Refactoring blob lengths table for [" + entityType + ']');
                        }
                        PersistentEntityStoreRefactorings.this.safeExecuteRefactoringForEntityType(entityType, new StoreTransactionalExecutable(){

                            public void execute(@NotNull StoreTransaction tx) {
                                PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                                int entityTypeId = PersistentEntityStoreRefactorings.this.store.getEntityTypeId(txn, entityType, false);
                                BlobsTable blobs = PersistentEntityStoreRefactorings.this.store.getBlobsTable(txn, entityTypeId);
                                Transaction envTxn = txn.getEnvironmentTransaction();
                                try (Cursor cursor = blobs.getPrimaryIndex().openCursor(envTxn);){
                                    while (cursor.getNext()) {
                                        long blobHandle = LongBinding.compressedEntryToLong((ByteIterable)cursor.getValue());
                                        if (PersistentEntityStoreImpl.isEmptyOrInPlaceBlobHandle(blobHandle)) continue;
                                        PersistentEntityStoreRefactorings.this.store.setBlobFileLength(txn, blobHandle, diskVault.getBlobLocation(blobHandle).length());
                                    }
                                }
                            }
                        });
                    }
                }
            });
        }
    }

    void refactorCreateNullLinkIndices() {
        this.store.executeInReadonlyTransaction(new StoreTransactionalExecutable(){

            public void execute(@NotNull StoreTransaction tx) {
                PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                for (final String entityType : PersistentEntityStoreRefactorings.this.store.getEntityTypes(txn)) {
                    if (logger.isInfoEnabled()) {
                        logger.info("Refactoring creating null-value link indices for [" + entityType + ']');
                    }
                    PersistentEntityStoreRefactorings.this.safeExclusiveExecuteRefactoringForEntityType(entityType, new StoreTransactionalExecutable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void execute(@NotNull StoreTransaction tx) {
                            Transaction envTxn;
                            PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                            int entityTypeId = PersistentEntityStoreRefactorings.this.store.getEntityTypeId(txn, entityType, false);
                            LinksTable links = PersistentEntityStoreRefactorings.this.store.getLinksTable(txn, entityTypeId);
                            Store allLinksIndex = links.getAllLinksIndex();
                            if (allLinksIndex.count(envTxn = txn.getEnvironmentTransaction()) > 0L) {
                                if (logger.isWarnEnabled()) {
                                    logger.warn("Refactoring creating null-value link indices looped for [" + entityType + ']');
                                }
                                envTxn.getEnvironment().truncateStore(allLinksIndex.getName(), envTxn);
                                ((PersistentEntityStoreRefactorings)PersistentEntityStoreRefactorings.this).store.linksTables.remove(entityTypeId);
                                links = PersistentEntityStoreRefactorings.this.store.getLinksTable(txn, entityTypeId);
                                allLinksIndex = links.getAllLinksIndex();
                            }
                            Transaction readonlySnapshot = envTxn.getReadonlySnapshot();
                            try {
                                Cursor cursor = links.getSecondIndexCursor(readonlySnapshot);
                                long total = links.getSecondaryCount(readonlySnapshot);
                                long done = 0L;
                                int prevLinkId = -1;
                                int linkId = -1;
                                PersistentLongSet.MutableSet idSet2 = new PersistentLong23TreeSet().beginWrite();
                                String format = "done %4.1f%% for " + entityType;
                                while (cursor.getNext()) {
                                    PropertyKey linkKey = PropertyKey.entryToPropertyKey(cursor.getValue());
                                    linkId = linkKey.getPropertyId();
                                    long entityLocalId = linkKey.getEntityLocalId();
                                    if (prevLinkId != linkId) {
                                        if (prevLinkId == -1) {
                                            prevLinkId = linkId;
                                        } else {
                                            if (linkId < prevLinkId) {
                                                throw new IllegalStateException("Unsorted index");
                                            }
                                            done = this.dumpSetAndFlush(format, allLinksIndex, txn, total, done, prevLinkId, idSet2);
                                            prevLinkId = linkId;
                                            linkId = -1;
                                        }
                                    }
                                    idSet2.add(entityLocalId);
                                }
                                if (prevLinkId != -1) {
                                    this.dumpSetAndFlush(format, allLinksIndex, txn, total, done, prevLinkId, idSet2);
                                }
                                cursor.close();
                            }
                            finally {
                                readonlySnapshot.abort();
                            }
                        }

                        private long dumpSetAndFlush(String format, Store allLinksIndex, PersistentStoreTransaction txn, double total, long done, int prevLinkId, PersistentLongSet.MutableSet idSet2) {
                            LongIterator itr = idSet2.longIterator();
                            while (itr.hasNext()) {
                                allLinksIndex.putRight(txn.getEnvironmentTransaction(), (ByteIterable)IntegerBinding.intToCompressedEntry((int)prevLinkId), (ByteIterable)LongBinding.longToCompressedEntry((long)((Long)itr.next())));
                                if (++done % 10000L == 0L && logger.isInfoEnabled()) {
                                    logger.info(String.format(format, (double)done * 100.0 / total));
                                }
                                if (done % 100000L != 0L || txn.flush()) continue;
                                throw new IllegalStateException("cannot flush");
                            }
                            idSet2.clear();
                            return done;
                        }
                    });
                }
            }
        });
    }

    void refactorDropEmptyPrimaryLinkTables() {
        this.store.executeInReadonlyTransaction(new StoreTransactionalExecutable(){

            public void execute(@NotNull StoreTransaction tx) {
                final PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                for (final String entityType : PersistentEntityStoreRefactorings.this.store.getEntityTypes(txn)) {
                    PersistentEntityStoreRefactorings.runReadonlyTransactionSafeForEntityType(entityType, new Runnable(){

                        @Override
                        public void run() {
                            Transaction envTxn = txn.getEnvironmentTransaction();
                            int entityTypeId = PersistentEntityStoreRefactorings.this.store.getEntityTypeId(txn, entityType, false);
                            final LinksTable linksTable = PersistentEntityStoreRefactorings.this.store.getLinksTable(txn, entityTypeId);
                            long primaryCount = linksTable.getPrimaryCount(envTxn);
                            if (primaryCount != 0L && linksTable.getSecondaryCount(envTxn) == 0L) {
                                PersistentEntityStoreRefactorings.this.store.getEnvironment().executeInTransaction(new TransactionalExecutable(){

                                    public void execute(@NotNull Transaction txn) {
                                        linksTable.truncateFirst(txn);
                                    }
                                });
                                if (logger.isInfoEnabled()) {
                                    logger.info("Drop links' tables when primary index is empty for [" + entityType + ']');
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    void refactorMakeLinkTablesConsistent(final Store internalSettings) {
        this.store.executeInReadonlyTransaction(new StoreTransactionalExecutable(){

            public void execute(@NotNull StoreTransaction tx) {
                final PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                for (final String entityType : PersistentEntityStoreRefactorings.this.store.getEntityTypes(txn)) {
                    if (logger.isInfoEnabled()) {
                        logger.info("Refactoring making links' tables consistent for [" + entityType + ']');
                    }
                    PersistentEntityStoreRefactorings.runReadonlyTransactionSafeForEntityType(entityType, new Runnable(){

                        @Override
                        public void run() {
                            Object first;
                            final ArrayList<Pair> redundantLinks = new ArrayList<Pair>();
                            final ArrayList<Pair> deleteLinks = new ArrayList<Pair>();
                            int entityTypeId = PersistentEntityStoreRefactorings.this.store.getEntityTypeId(txn, entityType, false);
                            final LinksTable linksTable = PersistentEntityStoreRefactorings.this.store.getLinksTable(txn, entityTypeId);
                            Transaction envTxn = txn.getEnvironmentTransaction();
                            PackedLongHashSet all = new PackedLongHashSet();
                            PackedLongHashSet linkFilter = new PackedLongHashSet();
                            try (Cursor cursor = PersistentEntityStoreRefactorings.this.store.getEntitiesIndexCursor(txn, entityTypeId);){
                                while (cursor.getNext()) {
                                    all.add(LongBinding.compressedEntryToLong((ByteIterable)cursor.getKey()));
                                }
                            }
                            IntHashSet redundantLinkTypes = new IntHashSet();
                            IntHashSet deletedLinkTypes = new IntHashSet();
                            IntHashSet deletedLinkIds = new IntHashSet();
                            try (Cursor cursor = linksTable.getFirstIndexCursor(envTxn);){
                                while (cursor.getNext()) {
                                    ByteIterable first2 = cursor.getKey();
                                    ByteIterable second = cursor.getValue();
                                    LinkValue linkValue = null;
                                    long localId = LongBinding.compressedEntryToLong((ByteIterable)first2);
                                    if (!all.contains(localId)) {
                                        try {
                                            linkValue = LinkValue.entryToLinkValue(second);
                                            deletedLinkTypes.add(linkValue.getEntityId().getTypeId());
                                            deletedLinkIds.add(linkValue.getLinkId());
                                        }
                                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                            // empty catch block
                                        }
                                        do {
                                            deleteLinks.add(new Pair((Object)first2, (Object)second));
                                        } while (cursor.getNextDup());
                                        continue;
                                    }
                                    linkFilter.add((long)((first2.hashCode() << 31) + second.hashCode()));
                                    if (linkValue == null) {
                                        try {
                                            linkValue = LinkValue.entryToLinkValue(second);
                                        }
                                        catch (ArrayIndexOutOfBoundsException ignore) {
                                            deleteLinks.add(new Pair((Object)first2, (Object)second));
                                        }
                                    }
                                    if (linkValue == null) continue;
                                    EntityId targetEntityId = linkValue.getEntityId();
                                    if (PersistentEntityStoreRefactorings.this.store.getLastVersion(txn, targetEntityId) < 0) {
                                        deletedLinkTypes.add(targetEntityId.getTypeId());
                                        deletedLinkIds.add(linkValue.getLinkId());
                                        deleteLinks.add(new Pair((Object)first2, (Object)second));
                                        continue;
                                    }
                                    linkFilter.add((long)((first2.hashCode() << 31) + second.hashCode()));
                                    if (linksTable.contains2(envTxn, first2, second)) continue;
                                    redundantLinkTypes.add(targetEntityId.getTypeId());
                                    redundantLinks.add(new Pair((Object)first2, (Object)second));
                                }
                            }
                            if (!redundantLinks.isEmpty()) {
                                PersistentEntityStoreRefactorings.this.store.getEnvironment().executeInTransaction(new TransactionalExecutable(){

                                    public void execute(@NotNull Transaction txn) {
                                        for (Pair badLink : redundantLinks) {
                                            linksTable.put(txn, (ByteIterable)badLink.getFirst(), (ByteIterable)badLink.getSecond());
                                        }
                                    }
                                });
                                if (logger.isInfoEnabled()) {
                                    logger.info(redundantLinks.size() + " missing links found for [" + entityType + ']');
                                }
                                redundantLinks.clear();
                            }
                            cursor = linksTable.getSecondIndexCursor(envTxn);
                            var12_17 = null;
                            try {
                                while (cursor.getNext()) {
                                    ByteIterable second = cursor.getKey();
                                    first = cursor.getValue();
                                    if (linkFilter.contains((long)((first.hashCode() << 31) + second.hashCode())) || linksTable.contains(envTxn, (ByteIterable)first, second)) continue;
                                    redundantLinks.add(new Pair(first, (Object)second));
                                }
                            }
                            catch (Throwable second) {
                                var12_17 = second;
                                throw second;
                            }
                            finally {
                                if (cursor != null) {
                                    if (var12_17 != null) {
                                        try {
                                            cursor.close();
                                        }
                                        catch (Throwable second) {
                                            var12_17.addSuppressed(second);
                                        }
                                    } else {
                                        cursor.close();
                                    }
                                }
                            }
                            int redundantLinksSize = redundantLinks.size();
                            int deleteLinksSize = deleteLinks.size();
                            if (redundantLinksSize > 0 || deleteLinksSize > 0) {
                                PersistentEntityStoreRefactorings.this.store.getEnvironment().executeInTransaction(new TransactionalExecutable(){

                                    public void execute(@NotNull Transaction txn) {
                                        for (Pair redundantLink : redundantLinks) {
                                            PersistentEntityStoreRefactorings.deletePair(linksTable.getSecondIndexCursor(txn), (ByteIterable)redundantLink.getFirst(), (ByteIterable)redundantLink.getSecond());
                                        }
                                        for (Pair deleteLink : deleteLinks) {
                                            PersistentEntityStoreRefactorings.deletePair(linksTable.getFirstIndexCursor(txn), (ByteIterable)deleteLink.getFirst(), (ByteIterable)deleteLink.getSecond());
                                            PersistentEntityStoreRefactorings.deletePair(linksTable.getSecondIndexCursor(txn), (ByteIterable)deleteLink.getSecond(), (ByteIterable)deleteLink.getFirst());
                                        }
                                    }
                                });
                                if (logger.isInfoEnabled()) {
                                    if (redundantLinksSize > 0) {
                                        ArrayList<String> redundantLinkTypeNames = new ArrayList<String>(redundantLinkTypes.size());
                                        first = redundantLinkTypes.iterator();
                                        while (first.hasNext()) {
                                            int typeId = (Integer)first.next();
                                            redundantLinkTypeNames.add(PersistentEntityStoreRefactorings.this.store.getEntityType(txn, typeId));
                                        }
                                        logger.info(redundantLinksSize + " redundant links found and fixed for [" + entityType + "] and targets: " + redundantLinkTypeNames);
                                    }
                                    if (deleteLinksSize > 0) {
                                        ArrayList<String> deletedLinkTypeNames = new ArrayList<String>(deletedLinkTypes.size());
                                        first = deletedLinkTypes.iterator();
                                        while (first.hasNext()) {
                                            int typeId = (Integer)first.next();
                                            try {
                                                String entityTypeName = PersistentEntityStoreRefactorings.this.store.getEntityType(txn, typeId);
                                                deletedLinkTypeNames.add(entityTypeName);
                                            }
                                            catch (Throwable entityTypeName) {}
                                        }
                                        ArrayList<String> deletedLinkIdsNames = new ArrayList<String>(deletedLinkIds.size());
                                        Iterator iterator = deletedLinkIds.iterator();
                                        while (iterator.hasNext()) {
                                            int typeId = (Integer)iterator.next();
                                            try {
                                                String linkName = PersistentEntityStoreRefactorings.this.store.getLinkName(txn, typeId);
                                                deletedLinkIdsNames.add(linkName);
                                            }
                                            catch (Throwable throwable) {}
                                        }
                                        logger.info(deleteLinksSize + " phantom links found and fixed for [" + entityType + "] and targets: " + deletedLinkTypeNames);
                                        logger.info("Link types: " + deletedLinkIdsNames);
                                    }
                                }
                            }
                            Settings.delete(internalSettings, "Link null-indices present");
                        }
                    });
                }
            }
        });
    }

    void refactorMakePropTablesConsistent() {
        this.store.executeInReadonlyTransaction(new StoreTransactionalExecutable(){

            public void execute(@NotNull StoreTransaction tx) {
                final PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                for (final String entityType : PersistentEntityStoreRefactorings.this.store.getEntityTypes(txn)) {
                    if (logger.isInfoEnabled()) {
                        logger.info("Refactoring making props' tables consistent for [" + entityType + ']');
                    }
                    PersistentEntityStoreRefactorings.runReadonlyTransactionSafeForEntityType(entityType, new Runnable(){

                        @Override
                        public void run() {
                            Object propKey;
                            int entityTypeId = PersistentEntityStoreRefactorings.this.store.getEntityTypeId(txn, entityType, false);
                            final PropertiesTable propTable = PersistentEntityStoreRefactorings.this.store.getPropertiesTable(txn, entityTypeId);
                            Transaction envTxn = txn.getEnvironmentTransaction();
                            IntHashMap props = new IntHashMap();
                            PackedLongHashSet all = new PackedLongHashSet();
                            try (Cursor cursor = PersistentEntityStoreRefactorings.this.store.getEntitiesIndexCursor(txn, entityTypeId);){
                                while (cursor.getNext()) {
                                    all.add(LongBinding.compressedEntryToLong((ByteIterable)cursor.getKey()));
                                }
                            }
                            PropertyTypes propertyTypes = PersistentEntityStoreRefactorings.this.store.getPropertyTypes();
                            LongHashSet entitiesToDelete = new LongHashSet();
                            try (Cursor cursor = PersistentEntityStoreRefactorings.this.store.getPrimaryPropertyIndexCursor(txn, propTable);){
                                while (cursor.getNext()) {
                                    propKey = PropertyKey.entryToPropertyKey(cursor.getKey());
                                    long localId = ((PropertyKey)propKey).getEntityLocalId();
                                    if (!all.contains(localId)) {
                                        entitiesToDelete.add(localId);
                                        continue;
                                    }
                                    PropertyValue propValue = propertyTypes.entryToPropertyValue(cursor.getValue());
                                    int propId = ((PropertyKey)propKey).getPropertyId();
                                    LongHashMap entitiesToValues = (LongHashMap)props.get(propId);
                                    if (entitiesToValues == null) {
                                        entitiesToValues = new LongHashMap();
                                        props.put(propId, (Object)entitiesToValues);
                                    }
                                    entitiesToValues.put(localId, (Object)propValue);
                                }
                            }
                            if (!entitiesToDelete.isEmpty()) {
                                PersistentEntityStoreRefactorings.this.store.executeInTransaction(new StoreTransactionalExecutable((LongSet)entitiesToDelete, entityTypeId){
                                    final /* synthetic */ LongSet val$entitiesToDelete;
                                    final /* synthetic */ int val$entityTypeId;
                                    {
                                        this.val$entitiesToDelete = longSet;
                                        this.val$entityTypeId = n;
                                    }

                                    public void execute(@NotNull StoreTransaction tx) {
                                        PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                                        for (Long localId : this.val$entitiesToDelete) {
                                            PersistentEntityStoreRefactorings.this.store.deleteEntity(txn, new PersistentEntity(PersistentEntityStoreRefactorings.this.store, new PersistentEntityId(this.val$entityTypeId, localId)));
                                        }
                                    }
                                });
                            }
                            final ArrayList<Pair> missingPairs = new ArrayList<Pair>();
                            final IntHashMap allPropsMap = new IntHashMap();
                            propKey = props.keySet().iterator();
                            while (propKey.hasNext()) {
                                Long[] localIds;
                                int propId = (Integer)propKey.next();
                                Store valueIndex = propTable.getValueIndex(txn, propId, false);
                                Cursor valueCursor = valueIndex == null ? null : valueIndex.openCursor(envTxn);
                                LongHashMap entitiesToValues = (LongHashMap)props.get(propId);
                                Set localIdSet = entitiesToValues.keySet();
                                TreeSet sortedLocalIdSet = new TreeSet(localIdSet);
                                allPropsMap.put(propId, sortedLocalIdSet);
                                Long[] longArray = localIds = sortedLocalIdSet.toArray(new Long[entitiesToValues.size()]);
                                int n = longArray.length;
                                for (int i = 0; i < n; ++i) {
                                    long localId = longArray[i];
                                    PropertyValue propValue = (PropertyValue)entitiesToValues.get(localId);
                                    for (ByteIterable secondaryKey : PropertiesTable.createSecondaryKeys(propertyTypes, (ByteIterable)PropertyTypes.propertyValueToEntry(propValue), propValue.getType())) {
                                        ArrayByteIterable secondaryValue = LongBinding.longToCompressedEntry((long)localId);
                                        if (valueCursor != null && valueCursor.getSearchBoth(secondaryKey, (ByteIterable)secondaryValue)) continue;
                                        missingPairs.add(new Pair((Object)propId, (Object)new Pair((Object)secondaryKey, (Object)secondaryValue)));
                                    }
                                }
                                if (valueCursor == null) continue;
                                valueCursor.close();
                            }
                            if (!missingPairs.isEmpty()) {
                                PersistentEntityStoreRefactorings.this.store.executeInTransaction(new StoreTransactionalExecutable(){

                                    public void execute(@NotNull StoreTransaction tx) {
                                        PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                                        for (Pair pair : missingPairs) {
                                            Store valueIndex = propTable.getValueIndex(txn, (Integer)pair.getFirst(), true);
                                            Pair missing = (Pair)pair.getSecond();
                                            if (valueIndex == null) {
                                                throw new NullPointerException("Can't be");
                                            }
                                            valueIndex.put(txn.getEnvironmentTransaction(), (ByteIterable)missing.getFirst(), (ByteIterable)missing.getSecond());
                                        }
                                    }
                                });
                                if (logger.isInfoEnabled()) {
                                    logger.info(missingPairs.size() + " missing secondary keys found and fixed for [" + entityType + ']');
                                }
                            }
                            final ArrayList<Pair> phantomPairs = new ArrayList<Pair>();
                            for (Map.Entry<Integer, Store> entry : propTable.getValueIndices()) {
                                int propId = entry.getKey();
                                LongHashMap entitiesToValues = (LongHashMap)props.get(propId);
                                Cursor c = entry.getValue().openCursor(envTxn);
                                while (c.getNext()) {
                                    ByteIterable keyEntry = c.getKey();
                                    ByteIterable valueEntry = c.getValue();
                                    PropertyValue propValue = (PropertyValue)entitiesToValues.get(LongBinding.compressedEntryToLong((ByteIterable)valueEntry));
                                    if (propValue != null) {
                                        ComparableBinding objectBinding;
                                        Class dataClass;
                                        Comparable data = propValue.getData();
                                        int typeId = propValue.getType().getTypeId();
                                        if (typeId == 8) {
                                            dataClass = ((ComparableSet)data).getItemClass();
                                            objectBinding = propertyTypes.getPropertyType(dataClass).getBinding();
                                        } else {
                                            dataClass = data.getClass();
                                            objectBinding = propValue.getBinding();
                                        }
                                        try {
                                            Comparable value = objectBinding.entryToObject(keyEntry);
                                            if (dataClass.equals(value.getClass()) && (typeId == 8 ? ((ComparableSet)data).containsItem(value) : PropertyTypes.toLowerCase(data).compareTo(value) == 0)) {
                                                continue;
                                            }
                                        }
                                        catch (Throwable t) {
                                            logger.error("Error reading property value index ", t);
                                            PersistentEntityStoreRefactorings.throwJVMError(t);
                                        }
                                    }
                                    phantomPairs.add(new Pair((Object)propId, (Object)new Pair((Object)keyEntry, (Object)valueEntry)));
                                }
                                c.close();
                            }
                            if (!phantomPairs.isEmpty()) {
                                PersistentEntityStoreRefactorings.this.store.executeInTransaction(new StoreTransactionalExecutable(){

                                    public void execute(@NotNull StoreTransaction tx) {
                                        PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                                        Transaction envTxn = txn.getEnvironmentTransaction();
                                        for (Pair pair : phantomPairs) {
                                            Store valueIndex = propTable.getValueIndex(txn, (Integer)pair.getFirst(), true);
                                            Pair phantom = (Pair)pair.getSecond();
                                            if (valueIndex == null) {
                                                throw new NullPointerException("Can't be");
                                            }
                                            PersistentEntityStoreRefactorings.deletePair(valueIndex.openCursor(envTxn), (ByteIterable)phantom.getFirst(), (ByteIterable)phantom.getSecond());
                                        }
                                    }
                                });
                                if (logger.isInfoEnabled()) {
                                    logger.info(phantomPairs.size() + " phantom secondary keys found and fixed for [" + entityType + ']');
                                }
                            }
                            final ArrayList<Pair> phantomIds = new ArrayList<Pair>();
                            Cursor c = propTable.getAllPropsIndex().openCursor(envTxn);
                            while (c.getNext()) {
                                int propId = IntegerBinding.compressedEntryToInt((ByteIterable)c.getKey());
                                long localId = LongBinding.compressedEntryToLong((ByteIterable)c.getValue());
                                Set localIds = (Set)allPropsMap.get(propId);
                                if (localIds == null || !localIds.remove(localId)) {
                                    phantomIds.add(new Pair((Object)propId, (Object)localId));
                                    continue;
                                }
                                if (!localIds.isEmpty()) continue;
                                allPropsMap.remove(propId);
                            }
                            c.close();
                            if (!allPropsMap.isEmpty()) {
                                final int[] added = new int[]{0};
                                PersistentEntityStoreRefactorings.this.store.executeInTransaction(new StoreTransactionalExecutable(){

                                    public void execute(@NotNull StoreTransaction txn) {
                                        int count = 0;
                                        Store allPropsIndex = propTable.getAllPropsIndex();
                                        Transaction envTxn = ((PersistentStoreTransaction)txn).getEnvironmentTransaction();
                                        for (Map.Entry entry : allPropsMap.entrySet()) {
                                            ArrayByteIterable keyEntry = IntegerBinding.intToCompressedEntry((int)((Integer)entry.getKey()));
                                            Iterator iterator = ((Set)entry.getValue()).iterator();
                                            while (iterator.hasNext()) {
                                                long localId = (Long)iterator.next();
                                                allPropsIndex.put(envTxn, (ByteIterable)keyEntry, (ByteIterable)LongBinding.longToCompressedEntry((long)localId));
                                                ++count;
                                            }
                                        }
                                        added[0] = count;
                                    }
                                });
                                if (logger.isInfoEnabled()) {
                                    logger.info(added[0] + " missing id pairs found and fixed for [" + entityType + ']');
                                }
                            }
                            if (!phantomIds.isEmpty()) {
                                PersistentEntityStoreRefactorings.this.store.executeInTransaction(new StoreTransactionalExecutable(){

                                    public void execute(@NotNull StoreTransaction txn) {
                                        Store allPropsIndex = propTable.getAllPropsIndex();
                                        Transaction envTxn = ((PersistentStoreTransaction)txn).getEnvironmentTransaction();
                                        try (Cursor c = allPropsIndex.openCursor(envTxn);){
                                            for (Pair phantom : phantomIds) {
                                                if (!c.getSearchBoth((ByteIterable)IntegerBinding.intToCompressedEntry((int)((Integer)phantom.getFirst())), (ByteIterable)LongBinding.longToCompressedEntry((long)((Long)phantom.getSecond())))) continue;
                                                c.deleteCurrent();
                                            }
                                        }
                                    }
                                });
                                if (logger.isInfoEnabled()) {
                                    logger.info(phantomIds.size() + " phantom id pairs found and fixed for [" + entityType + ']');
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    void refactorRemoveHistoryStores() {
        final Environment environment = this.store.getEnvironment();
        environment.executeInReadonlyTransaction(new TransactionalExecutable(){

            public void execute(@NotNull Transaction txn) {
                String persistentStoreName = PersistentEntityStoreRefactorings.this.store.getName();
                for (final String storeName : environment.getAllStoreNames(txn)) {
                    if (!storeName.startsWith(persistentStoreName) || !storeName.endsWith("#history")) continue;
                    environment.executeInTransaction(new TransactionalExecutable(){

                        public void execute(@NotNull Transaction txn) {
                            environment.removeStore(storeName, txn);
                        }
                    });
                }
            }
        });
    }

    private void safeExecuteRefactoringForEntityType(@NotNull String entityType, @NotNull StoreTransactionalExecutable executable) {
        try {
            this.store.executeInTransaction(executable);
        }
        catch (Throwable t) {
            logger.error("Failed to execute refactoring for entity type: " + entityType, t);
            PersistentEntityStoreRefactorings.throwJVMError(t);
        }
    }

    private void safeExclusiveExecuteRefactoringForEntityType(@NotNull String entityType, @NotNull StoreTransactionalExecutable executable) {
        try {
            this.store.executeInTransaction(executable);
        }
        catch (Throwable t) {
            logger.error("Failed to execute refactoring for entity type: " + entityType, t);
            PersistentEntityStoreRefactorings.throwJVMError(t);
        }
    }

    private void transactionalCopyAndRemoveEntitiesStore(final @NotNull String sourceName, final @NotNull String targetName) {
        final Environment env = this.store.getEnvironment();
        env.executeInTransaction(new TransactionalExecutable(){

            public void execute(@NotNull Transaction txn) {
                Store store = env.openStore(sourceName, StoreConfig.USE_EXISTING, txn);
                Store storeCopy = env.openStore(targetName, StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING, txn);
                Cursor cursor = store.openCursor(txn);
                ArrayByteIterable lastKey = null;
                while (cursor.getNext()) {
                    ArrayByteIterable key = new ArrayByteIterable(cursor.getKey());
                    if (lastKey != null && lastKey.compareTo((ByteIterable)key) >= 0) {
                        throw new IllegalStateException("Invalid key order");
                    }
                    storeCopy.putRight(txn, (ByteIterable)key, (ByteIterable)new ArrayByteIterable(cursor.getValue()));
                    lastKey = key;
                }
                cursor.close();
                env.removeStore(sourceName, txn);
            }
        });
    }

    private static void runReadonlyTransactionSafeForEntityType(@NotNull String entityType, @NotNull Runnable runnable) {
        try {
            runnable.run();
        }
        catch (ReadonlyTransactionException readonlyTransactionException) {
        }
        catch (Throwable t) {
            logger.error("Failed to execute refactoring for entity type: " + entityType, t);
            PersistentEntityStoreRefactorings.throwJVMError(t);
        }
    }

    private static void deletePair(@NotNull Cursor c, @NotNull ByteIterable key, @NotNull ByteIterable value) {
        if (c.getSearchBoth(key, value)) {
            c.deleteCurrent();
        }
        c.close();
    }

    private static void throwJVMError(@NotNull Throwable t) {
        if (t instanceof VirtualMachineError) {
            throw new EntityStoreException(t);
        }
    }

    private static void logInfo(@NotNull String message) {
        if (logger.isInfoEnabled()) {
            logger.info(message);
        }
    }
}

