/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicLong;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.entitystore.FlushLog;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.Sequence;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.Transaction;
import org.jetbrains.annotations.NotNull;

public class PersistentSequence
implements Sequence,
FlushLog.Member {
    @NotNull
    private final Store store;
    @NotNull
    private final ArrayByteIterable idKeyEntry;
    private final String name;
    private final AtomicLong val;
    private final AtomicLong lastSavedValue;
    private boolean forcedUpdate = false;

    public PersistentSequence(@NotNull PersistentStoreTransaction txn, @NotNull Store store, @NotNull String name) {
        this.store = store;
        this.name = name;
        this.idKeyEntry = PersistentSequence.sequenceNameToEntry(name);
        long savedValue = this.loadValue(txn);
        this.val = new AtomicLong(savedValue);
        this.lastSavedValue = new AtomicLong(savedValue);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "PersistentSequence '" + this.name + '\'' + ", value =" + this.val + ", last saved = " + this.lastSavedValue;
    }

    public long get() {
        return this.val.get();
    }

    public void set(long l) {
        this.val.set(l);
    }

    public void forceSet(long l) {
        this.forcedUpdate = true;
        this.val.set(l);
    }

    public long increment() {
        return this.val.incrementAndGet();
    }

    @Override
    public void logOperations(Transaction txn, FlushLog flushLog) {
        final long value = this.val.get();
        if (this.forcedUpdate) {
            this.store.put(txn, (ByteIterable)this.idKeyEntry, (ByteIterable)LongBinding.longToCompressedEntry((long)value));
            flushLog.add(new FlushLog.Operation(){

                @Override
                public void flushed() {
                    PersistentSequence.this.lastSavedValue.set(value);
                    PersistentSequence.this.forcedUpdate = false;
                }
            });
        } else if (value > this.lastSavedValue.get()) {
            this.store.put(txn, (ByteIterable)this.idKeyEntry, (ByteIterable)LongBinding.longToCompressedEntry((long)value));
            flushLog.add(new FlushLog.Operation(){

                @Override
                public void flushed() {
                    long current;
                    while ((current = PersistentSequence.this.lastSavedValue.get()) < value && !PersistentSequence.this.lastSavedValue.compareAndSet(current, value)) {
                    }
                }
            });
        }
    }

    void invalidate(@NotNull Transaction txn) {
        this.set(this.loadValue(txn));
    }

    long loadValue(@NotNull PersistentStoreTransaction txn) {
        return this.loadValue(txn.getEnvironmentTransaction());
    }

    long loadValue(@NotNull Transaction txn) {
        ByteIterable value = this.store.get(txn, (ByteIterable)this.idKeyEntry);
        return value == null ? -1L : LongBinding.compressedEntryToLong((ByteIterable)value);
    }

    static ArrayByteIterable sequenceNameToEntry(@NotNull String sequenceName) {
        return new ArrayByteIterable(sequenceName.getBytes(StandardCharsets.UTF_8));
    }
}

