/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import java.io.Closeable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterable;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.CachedInstanceIterable;
import jetbrains.exodus.entitystore.iterate.ConstantEntityIterableHandle;
import jetbrains.exodus.entitystore.iterate.EntitiesOfTypeIterable;
import jetbrains.exodus.entitystore.iterate.EntitiesWithCertainLinkIterable;
import jetbrains.exodus.entitystore.iterate.EntityAddedOrDeletedHandleChecker;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.FilterEntitiesWithCertainLinkIterable;
import jetbrains.exodus.entitystore.iterate.UpdatableEntityIdSortedSetCachedInstanceIterable;
import jetbrains.exodus.env.Cursor;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0016\u0018\u0000 \u001a2\u00020\u0001:\u0003\u001a\u001b\u001cB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0005H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ljetbrains/exodus/entitystore/iterate/EntitiesOfTypeIterable;", "Ljetbrains/exodus/entitystore/iterate/EntityIterableBase;", "txn", "Ljetbrains/exodus/entitystore/PersistentStoreTransaction;", "entityTypeId", "", "(Ljetbrains/exodus/entitystore/PersistentStoreTransaction;I)V", "countImpl", "", "createCachedInstance", "Ljetbrains/exodus/entitystore/iterate/CachedInstanceIterable;", "findLinks", "Ljetbrains/exodus/entitystore/EntityIterable;", "entities", "linkName", "", "getEntityTypeId", "getHandleImpl", "Ljetbrains/exodus/entitystore/iterate/EntitiesOfTypeIterable$EntitiesOfTypeIterableHandle;", "getIteratorImpl", "Ljetbrains/exodus/entitystore/iterate/EntitiesOfTypeIterable$EntitiesOfTypeIterator;", "getLast", "Ljetbrains/exodus/entitystore/Entity;", "isEmptyImpl", "", "nonCachedHasFastCountAndIsEmpty", "Companion", "EntitiesOfTypeIterableHandle", "EntitiesOfTypeIterator", "xodus-entity-store"})
public class EntitiesOfTypeIterable
extends EntityIterableBase {
    private final int entityTypeId;
    public static final Companion Companion = new Companion(null);

    @Override
    public int getEntityTypeId() {
        return this.entityTypeId;
    }

    @Override
    @NotNull
    public EntitiesOfTypeIterator getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
        Cursor cursor = this.getStore().getEntitiesIndexCursor(txn, this.entityTypeId);
        Intrinsics.checkExpressionValueIsNotNull((Object)cursor, (String)"store.getEntitiesIndexCursor(txn, entityTypeId)");
        return new EntitiesOfTypeIterator(this, cursor);
    }

    @Override
    public boolean nonCachedHasFastCountAndIsEmpty() {
        return true;
    }

    @Override
    @NotNull
    public EntityIterable findLinks(@NotNull EntityIterable entities, @NotNull String linkName) {
        Intrinsics.checkParameterIsNotNull((Object)entities, (String)"entities");
        Intrinsics.checkParameterIsNotNull((Object)linkName, (String)"linkName");
        PersistentStoreTransaction txn = this.getTransaction();
        int linkId = this.getStore().getLinkId(txn, linkName, false);
        if (linkId < 0) {
            EntityIterableBase entityIterableBase = EntityIterableBase.EMPTY;
            Intrinsics.checkExpressionValueIsNotNull((Object)entityIterableBase, (String)"EMPTY");
            return entityIterableBase;
        }
        PersistentStoreTransaction persistentStoreTransaction = txn;
        Intrinsics.checkExpressionValueIsNotNull((Object)persistentStoreTransaction, (String)"txn");
        return new FilterEntitiesWithCertainLinkIterable(persistentStoreTransaction, new EntitiesWithCertainLinkIterable(txn, this.entityTypeId, linkId), (EntityIterableBase)entities);
    }

    @Override
    public boolean isEmptyImpl(@NotNull PersistentStoreTransaction txn) {
        Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
        return this.countImpl(txn) == 0L;
    }

    @Override
    @NotNull
    protected EntitiesOfTypeIterableHandle getHandleImpl() {
        return new EntitiesOfTypeIterableHandle(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Entity getLast() {
        PersistentEntityStoreImpl persistentEntityStoreImpl = this.getStore();
        Intrinsics.checkExpressionValueIsNotNull((Object)persistentEntityStoreImpl, (String)"store");
        PersistentStoreTransaction txn = persistentEntityStoreImpl.getAndCheckCurrentTransaction();
        Closeable closeable = (Closeable)this.getStore().getEntitiesIndexCursor(txn, this.entityTypeId);
        Throwable throwable = null;
        try {
            Cursor cursor;
            Cursor cursor2 = cursor = (Cursor)closeable;
            Intrinsics.checkExpressionValueIsNotNull((Object)cursor2, (String)"cursor");
            Entity entity = cursor2.getLast() ? (Entity)txn.getEntity(new PersistentEntityId(this.entityTypeId, LongBinding.compressedEntryToLong((ByteIterable)cursor.getKey()))) : null;
            return entity;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Override
    @NotNull
    protected CachedInstanceIterable createCachedInstance(@NotNull PersistentStoreTransaction txn) {
        Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
        return new UpdatableEntityIdSortedSetCachedInstanceIterable(txn, this);
    }

    @Override
    protected long countImpl(@NotNull PersistentStoreTransaction txn) {
        Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
        return this.getStore().getEntitiesTable(txn, this.entityTypeId).count(txn.getEnvironmentTransaction());
    }

    public EntitiesOfTypeIterable(@NotNull PersistentStoreTransaction txn, int entityTypeId) {
        Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
        super(txn);
        this.entityTypeId = entityTypeId;
    }

    static {
        EntityIterableBase.registerType(EntityIterableType.ALL_ENTITIES, Companion.1.INSTANCE);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\u0010\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\bH\u0016R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ljetbrains/exodus/entitystore/iterate/EntitiesOfTypeIterable$EntitiesOfTypeIterator;", "Ljetbrains/exodus/entitystore/iterate/EntityIteratorBase;", "iterable", "Ljetbrains/exodus/entitystore/iterate/EntitiesOfTypeIterable;", "index", "Ljetbrains/exodus/env/Cursor;", "(Ljetbrains/exodus/entitystore/iterate/EntitiesOfTypeIterable;Ljetbrains/exodus/env/Cursor;)V", "entityId", "Ljetbrains/exodus/entitystore/EntityId;", "getEntityId", "()Ljetbrains/exodus/entitystore/EntityId;", "entityTypeId", "", "hasNext", "", "hasNextValid", "getLast", "hasNextImpl", "nextIdImpl", "xodus-entity-store"})
    public static final class EntitiesOfTypeIterator
    extends EntityIteratorBase {
        private boolean hasNext;
        private boolean hasNextValid;
        private final int entityTypeId;

        private final EntityId getEntityId() {
            Cursor cursor = this.getCursor();
            Intrinsics.checkExpressionValueIsNotNull((Object)cursor, (String)"cursor");
            return new PersistentEntityId(this.entityTypeId, LongBinding.compressedEntryToLong((ByteIterable)cursor.getKey()));
        }

        @Override
        public boolean hasNextImpl() {
            if (!this.hasNextValid) {
                Cursor cursor = this.getCursor();
                Intrinsics.checkExpressionValueIsNotNull((Object)cursor, (String)"cursor");
                this.hasNext = cursor.getNext();
                this.hasNextValid = true;
            }
            return this.hasNext;
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            if (this.hasNextImpl()) {
                this.getIterable().explain(EntityIterableType.ALL_ENTITIES);
                EntityId result = this.getEntityId();
                this.hasNextValid = false;
                return result;
            }
            return null;
        }

        @Override
        @Nullable
        public EntityId getLast() {
            Cursor cursor = this.getCursor();
            Intrinsics.checkExpressionValueIsNotNull((Object)cursor, (String)"cursor");
            return !cursor.getPrev() ? null : this.getEntityId();
        }

        public EntitiesOfTypeIterator(@NotNull EntitiesOfTypeIterable iterable, @NotNull Cursor index2) {
            Intrinsics.checkParameterIsNotNull((Object)iterable, (String)"iterable");
            Intrinsics.checkParameterIsNotNull((Object)index2, (String)"index");
            super(iterable);
            this.entityTypeId = iterable.entityTypeId;
            this.setCursor(index2);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0011H\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0014\u0010\u0018\u001a\u00020\u000b2\n\u0010\u0019\u001a\u00060\u001aj\u0002`\u001bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Ljetbrains/exodus/entitystore/iterate/EntitiesOfTypeIterable$EntitiesOfTypeIterableHandle;", "Ljetbrains/exodus/entitystore/iterate/ConstantEntityIterableHandle;", "source", "Ljetbrains/exodus/entitystore/iterate/EntitiesOfTypeIterable;", "(Ljetbrains/exodus/entitystore/iterate/EntitiesOfTypeIterable;)V", "typeId", "", "getEntityTypeId", "getTypeIdsAffectingCreation", "", "hashCode", "", "hash", "Ljetbrains/exodus/entitystore/iterate/EntityIterableHandleBase$EntityIterableHandleHash;", "isMatchedEntityAdded", "", "added", "Ljetbrains/exodus/entitystore/EntityId;", "isMatchedEntityDeleted", "deleted", "onEntityAdded", "handleChecker", "Ljetbrains/exodus/entitystore/iterate/EntityAddedOrDeletedHandleChecker;", "onEntityDeleted", "toString", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "xodus-entity-store"})
    public static class EntitiesOfTypeIterableHandle
    extends ConstantEntityIterableHandle {
        private final int typeId;

        @Override
        public void toString(@NotNull StringBuilder builder) {
            Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
            super.toString(builder);
            builder.append(this.getEntityTypeId());
        }

        @Override
        public void hashCode(@NotNull EntityIterableHandleBase.EntityIterableHandleHash hash) {
            Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
            hash.apply(this.getEntityTypeId());
        }

        @Override
        public int getEntityTypeId() {
            return this.typeId;
        }

        @Override
        @NotNull
        public int[] getTypeIdsAffectingCreation() {
            return new int[]{this.getEntityTypeId()};
        }

        @Override
        public boolean isMatchedEntityAdded(@NotNull EntityId added) {
            Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
            return added.getTypeId() == this.getEntityTypeId();
        }

        @Override
        public boolean isMatchedEntityDeleted(@NotNull EntityId deleted) {
            Intrinsics.checkParameterIsNotNull((Object)deleted, (String)"deleted");
            return deleted.getTypeId() == this.getEntityTypeId();
        }

        @Override
        public boolean onEntityAdded(@NotNull EntityAddedOrDeletedHandleChecker handleChecker) {
            Intrinsics.checkParameterIsNotNull((Object)handleChecker, (String)"handleChecker");
            UpdatableEntityIdSortedSetCachedInstanceIterable iterable = PersistentStoreTransaction.getUpdatable(handleChecker, this, UpdatableEntityIdSortedSetCachedInstanceIterable.class);
            if (iterable != null) {
                iterable.addEntity(handleChecker.getId());
                return true;
            }
            return false;
        }

        @Override
        public boolean onEntityDeleted(@NotNull EntityAddedOrDeletedHandleChecker handleChecker) {
            Intrinsics.checkParameterIsNotNull((Object)handleChecker, (String)"handleChecker");
            UpdatableEntityIdSortedSetCachedInstanceIterable iterable = PersistentStoreTransaction.getUpdatable(handleChecker, this, UpdatableEntityIdSortedSetCachedInstanceIterable.class);
            if (iterable != null) {
                iterable.removeEntity(handleChecker.getId());
                return true;
            }
            return false;
        }

        public EntitiesOfTypeIterableHandle(@NotNull EntitiesOfTypeIterable source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            super(source.getStore(), EntityIterableType.ALL_ENTITIES);
            this.typeId = source.entityTypeId;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/exodus/entitystore/iterate/EntitiesOfTypeIterable$Companion;", "", "()V", "xodus-entity-store"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

