/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableDecoratorBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleDecorator;
import jetbrains.exodus.entitystore.iterate.EntityIterableInstantiator;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.NonDisposableEntityIterator;
import org.jetbrains.annotations.NotNull;

public class SkipEntityIterable
extends EntityIterableDecoratorBase {
    private final int itemsToSkip;

    protected SkipEntityIterable(@NotNull PersistentStoreTransaction txn, @NotNull EntityIterableBase source, int itemsToSkip) {
        super(txn, source);
        this.itemsToSkip = itemsToSkip;
    }

    public static EntityIterableType getType() {
        return EntityIterableType.SKIP;
    }

    @Override
    public boolean isSortedById() {
        return this.source.isSortedById();
    }

    @Override
    public boolean canBeCached() {
        return false;
    }

    @Override
    @NotNull
    public EntityIteratorBase getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        return new NonDisposableEntityIterator(this){
            private EntityIteratorBase sourceIt;
            {
                this.sourceIt = null;
            }

            @Override
            protected boolean hasNextImpl() {
                this.skip();
                return this.sourceIt.hasNextImpl();
            }

            @Override
            public EntityId nextIdImpl() {
                this.skip();
                return this.sourceIt.nextIdImpl();
            }

            private void skip() {
                EntityIteratorBase sourceIt = this.sourceIt;
                if (sourceIt == null) {
                    this.sourceIt = sourceIt = (EntityIteratorBase)SkipEntityIterable.this.source.iterator();
                    sourceIt.skip(SkipEntityIterable.this.itemsToSkip);
                }
            }
        };
    }

    @Override
    @NotNull
    protected EntityIterableHandle getHandleImpl() {
        return new EntityIterableHandleDecorator(this.getStore(), SkipEntityIterable.getType(), this.source.getHandle()){

            @Override
            public void toString(@NotNull StringBuilder builder) {
                super.toString(builder);
                builder.append(SkipEntityIterable.this.itemsToSkip);
                builder.append('-');
                this.applyDecoratedToBuilder(builder);
            }

            @Override
            public void hashCode(@NotNull EntityIterableHandleBase.EntityIterableHandleHash hash) {
                hash.apply(SkipEntityIterable.this.itemsToSkip);
                hash.applyDelimiter();
                super.hashCode(hash);
            }
        };
    }

    static {
        SkipEntityIterable.registerType(SkipEntityIterable.getType(), new EntityIterableInstantiator(){

            @Override
            public EntityIterableBase instantiate(PersistentStoreTransaction txn, PersistentEntityStoreImpl store, Object[] parameters) {
                return new SkipEntityIterable(txn, (EntityIterableBase)parameters[1], Integer.valueOf((String)parameters[0]));
            }
        });
    }
}

