/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.PriorityQueue;
import jetbrains.exodus.core.dataStructures.hash.LongHashMap;
import jetbrains.exodus.core.dataStructures.hash.LongIterator;
import jetbrains.exodus.core.dataStructures.hash.LongSet;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterableCache;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.entitystore.PersistentEntity;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntityIdSet;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableDecoratorBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleDecorator;
import jetbrains.exodus.entitystore.iterate.EntityIterableInstantiator;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorFixingDecorator;
import jetbrains.exodus.entitystore.iterate.EntityTypeFilteredIterator;
import jetbrains.exodus.entitystore.iterate.NonDisposableEntityIterator;
import jetbrains.exodus.entitystore.iterate.PropertyValueIterator;
import jetbrains.exodus.entitystore.tables.PropertyValue;
import jetbrains.exodus.util.MathUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SortIterable
extends EntityIterableDecoratorBase {
    @NotNull
    private final EntityIterableBase propIndex;
    private final int sourceTypeId;
    private final int propertyId;
    private final boolean ascending;
    private final boolean stableSort;

    public SortIterable(@NotNull PersistentStoreTransaction txn, @NotNull EntityIterableBase propIndex, @NotNull EntityIterableBase source, int sourceTypeId, boolean ascending) {
        this(txn, propIndex, source, sourceTypeId, -1, ascending);
    }

    public SortIterable(@NotNull PersistentStoreTransaction txn, @NotNull EntityIterableBase propIndex, @NotNull EntityIterableBase source, int sourceTypeId, int propertyId, boolean ascending) {
        super(txn, source);
        this.propIndex = propIndex;
        this.sourceTypeId = sourceTypeId;
        this.propertyId = propertyId;
        this.ascending = ascending;
        this.stableSort = source.isSortResult();
    }

    @Override
    public int getEntityTypeId() {
        return this.sourceTypeId;
    }

    @Override
    public boolean setOrigin(Object origin) {
        if (super.setOrigin(origin)) {
            this.propIndex.setOrigin(origin);
            return true;
        }
        return false;
    }

    public static EntityIterableType getType() {
        return EntityIterableType.SORTING;
    }

    @Override
    public boolean isEmpty() {
        return this.source.isEmpty();
    }

    @Override
    public long size() {
        return this.source.size();
    }

    @Override
    public long count() {
        return this.source.count();
    }

    @Override
    public long getRoughCount() {
        return this.source.getRoughCount();
    }

    @Override
    public long getRoughSize() {
        return this.source.getRoughSize();
    }

    @Override
    protected long countImpl(@NotNull PersistentStoreTransaction txn) {
        int count = 0;
        EntityTypeFilteredIterator sorted = new EntityTypeFilteredIterator(this.source, this.sourceTypeId);
        while (sorted.hasNext()) {
            sorted.nextId();
            ++count;
        }
        return count;
    }

    @Override
    @NotNull
    public EntityIterator getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        EntityIterator propIterator;
        if (this.propIndex == EntityIterableBase.EMPTY) {
            return new EntityTypeFilteredIterator(this.source, this.sourceTypeId);
        }
        PersistentEntityStoreImpl store = this.getStore();
        EntityIterableCache entityIterableCache = store.getEntityIterableCache();
        EntityIterableBase cachedPropertyIndex = entityIterableCache.putIfNotCached(this.propIndex);
        if (this.propIndex.nonCachedHasFastCountAndIsEmpty() && store.getConfig().isDebugAllowInMemorySort()) {
            long sourceSize;
            long l = sourceSize = entityIterableCache.isDispatcherThread() ? -1L : this.source.getRoughCount();
            if (sourceSize >= 0L) {
                long indexSize = cachedPropertyIndex.size();
                long log2IndexSize = MathUtil.longLogarithm((long)indexSize);
                long sizeMulLog = sourceSize * log2IndexSize;
                boolean isCachedInstance = cachedPropertyIndex.isCachedInstance();
                if (isCachedInstance && sizeMulLog * sourceSize < indexSize || !isCachedInstance && sizeMulLog * log2IndexSize < indexSize) {
                    return new OptionallyStableInMemorySortIterator((int)sourceSize, this.stableSort);
                }
            }
        }
        EntityIterator entityIterator = propIterator = this.ascending ? cachedPropertyIndex.getIteratorImpl(txn) : cachedPropertyIndex.getReverseIteratorImpl(txn);
        if (propIterator == EntityIteratorBase.EMPTY) {
            return new EntityTypeFilteredIterator(this.source, this.sourceTypeId);
        }
        if (this.stableSort) {
            StableSortIterator itr = new StableSortIterator((PropertyValueIterator)propIterator);
            return new PropertyValueIteratorFixingDecorator(this, itr, itr);
        }
        return new EntityIteratorFixingDecorator(this, new NonStableSortIterator(txn, propIterator));
    }

    @Override
    @NotNull
    protected EntityIterableHandle getHandleImpl() {
        return new EntityIterableHandleDecorator(this.getStore(), SortIterable.getType(), this.source.getHandle()){
            @NotNull
            private final int[] propertyIds;
            {
                this.propertyIds = 2.mergeFieldIds(new int[]{SortIterable.this.propertyId}, this.decorated.getPropertyIds());
            }

            @Override
            @NotNull
            public int[] getPropertyIds() {
                return this.propertyIds;
            }

            @Override
            public void toString(@NotNull StringBuilder builder) {
                super.toString(builder);
                builder.append(SortIterable.this.sourceTypeId);
                builder.append('-');
                builder.append(SortIterable.this.propertyId);
                builder.append('-');
                this.applyDecoratedToBuilder(builder);
                builder.append('-');
                builder.append(SortIterable.this.ascending ? 0 : 1);
                builder.append('-');
                builder.append(SortIterable.this.stableSort ? 0 : 1);
            }

            @Override
            public void hashCode(@NotNull EntityIterableHandleBase.EntityIterableHandleHash hash) {
                hash.apply(SortIterable.this.sourceTypeId);
                hash.applyDelimiter();
                hash.apply(SortIterable.this.propertyId);
                hash.applyDelimiter();
                super.hashCode(hash);
                hash.applyDelimiter();
                hash.apply(SortIterable.this.ascending ? 0 : 1);
                hash.applyDelimiter();
                hash.apply(SortIterable.this.stableSort ? 0 : 1);
            }

            @Override
            public int getEntityTypeId() {
                return SortIterable.this.sourceTypeId;
            }

            @Override
            public boolean isMatchedPropertyChanged(@NotNull EntityId id, int propertyId, @Nullable Comparable oldValue, @Nullable Comparable newValue) {
                return SortIterable.this.sourceTypeId == id.getTypeId() && (this.decorated.isMatchedPropertyChanged(id, propertyId, oldValue, newValue) || SortIterable.this.propIndex.getHandle().isMatchedPropertyChanged(id, propertyId, oldValue, newValue));
            }
        };
    }

    @Override
    public boolean canBeCached() {
        return this.source.isThreadSafe();
    }

    @NotNull
    private LongHashMap<Integer> getRightOrder() {
        LongHashMap result = new LongHashMap();
        int position = 0;
        EntityIterator sorted = this.source.iterator();
        while (sorted.hasNext()) {
            EntityId entityId = sorted.nextId();
            if (entityId == null) {
                result.put(Long.MAX_VALUE, (Object)position++);
                continue;
            }
            if (this.sourceTypeId != entityId.getTypeId()) continue;
            result.put(entityId.getLocalId(), (Object)position++);
        }
        return result;
    }

    static {
        SortIterable.registerType(SortIterable.getType(), new EntityIterableInstantiator(){

            @Override
            public EntityIterableBase instantiate(PersistentStoreTransaction txn, PersistentEntityStoreImpl store, Object[] parameters) {
                return new SortIterable(txn, (EntityIterableBase)parameters[3], (EntityIterableBase)parameters[3], Integer.valueOf((String)parameters[0]), Integer.valueOf((String)parameters[1]), "0".equals(parameters[2]));
            }
        });
    }

    private static final class PropertyValueIteratorFixingDecorator
    extends NonDisposableEntityIterator
    implements PropertyValueIterator {
        private final PropertyValueIterator index;
        private final EntityIteratorBase iterator;
        private boolean hasNext;
        private boolean hasNextValid;

        PropertyValueIteratorFixingDecorator(@NotNull EntityIterableBase iterable, @NotNull PropertyValueIterator index2, @NotNull EntityIteratorBase iterator) {
            super(iterable);
            this.index = index2;
            this.iterator = iterator;
        }

        @Override
        protected boolean hasNextImpl() {
            if (!this.hasNextValid) {
                this.hasNext = this.iterator.hasNextImpl();
                this.hasNextValid = true;
            }
            return this.hasNext;
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            EntityId result = this.hasNextImpl() ? this.iterator.nextIdImpl() : null;
            this.hasNextValid = false;
            return result;
        }

        @Override
        public Comparable currentValue() {
            return this.index.currentValue();
        }
    }

    private static final class IdValuePair {
        final long localId;
        @Nullable
        final Comparable propValue;

        IdValuePair(long localId, @Nullable Comparable propValue) {
            this.localId = localId;
            this.propValue = propValue;
        }
    }

    private final class OptionallyStableInMemorySortIterator
    extends NonDisposableEntityIterator
    implements PropertyValueIterator {
        private final List<IdValuePair> pairs;
        private boolean hasNull;
        private int cursor;
        private Comparable currentValue;

        private OptionallyStableInMemorySortIterator(int sourceSize, final boolean stable) {
            super(SortIterable.this.propIndex);
            this.pairs = new ArrayList<IdValuePair>(sourceSize / 2);
            this.hasNull = false;
            this.cursor = 0;
            PersistentEntityStoreImpl store = this.getStore();
            PersistentStoreTransaction txn = SortIterable.this.getTransaction();
            String propertyName = store.getPropertyName(txn, SortIterable.this.propertyId);
            if (propertyName == null) {
                throw new NullPointerException("Property name is null");
            }
            int propertyId = store.getPropertyId(txn, propertyName, false);
            if (propertyId < 0) {
                throw new IllegalStateException("Property name is not registered");
            }
            EntityIterator it = SortIterable.this.source.iterator();
            while (it.hasNext()) {
                PersistentEntityId nextId = (PersistentEntityId)it.nextId();
                if (nextId == null) {
                    this.hasNull = true;
                    continue;
                }
                if (nextId.getTypeId() != SortIterable.this.sourceTypeId) continue;
                PropertyValue propValue = store.getPropertyValue(txn, new PersistentEntity(store, nextId), propertyId);
                this.pairs.add(new IdValuePair(nextId.getLocalId(), propValue == null ? null : propValue.getData()));
            }
            Object[] array = this.pairs.toArray();
            Arrays.sort(array, new Comparator(){

                public int compare(Object o1, Object o2) {
                    int result;
                    IdValuePair pair1 = (IdValuePair)o1;
                    IdValuePair pair2 = (IdValuePair)o2;
                    Comparable propValue1 = pair1.propValue;
                    Comparable propValue2 = pair2.propValue;
                    if (propValue1 == null && propValue2 == null) {
                        result = 0;
                    } else if (propValue1 == null) {
                        result = 1;
                    } else if (propValue2 == null) {
                        result = -1;
                    } else {
                        boolean isString = propValue1 instanceof String;
                        if (SortIterable.this.ascending) {
                            result = isString ? ((String)((Object)propValue1)).compareToIgnoreCase((String)((Object)propValue2)) : propValue1.compareTo(propValue2);
                        } else {
                            int n = result = isString ? ((String)((Object)propValue2)).compareToIgnoreCase((String)((Object)propValue1)) : propValue2.compareTo(propValue1);
                        }
                    }
                    if (!stable && result == 0) {
                        if (pair1.localId < pair2.localId) {
                            result = -1;
                        } else if (pair1.localId > pair2.localId) {
                            result = 1;
                        }
                    }
                    return result;
                }
            });
            ListIterator<IdValuePair> i = this.pairs.listIterator();
            for (Object o : array) {
                i.next();
                i.set((IdValuePair)o);
            }
        }

        @Override
        protected boolean hasNextImpl() {
            return this.cursor < this.pairs.size() || this.hasNull;
        }

        @Override
        @Nullable
        protected EntityId nextIdImpl() {
            if (this.cursor < this.pairs.size()) {
                IdValuePair pair = this.pairs.get(this.cursor++);
                this.currentValue = pair.propValue;
                return new PersistentEntityId(SortIterable.this.sourceTypeId, pair.localId);
            }
            this.hasNull = false;
            this.currentValue = null;
            return null;
        }

        @Override
        @Nullable
        public Comparable currentValue() {
            return this.currentValue;
        }
    }

    private final class NonStableSortIterator
    extends NonDisposableEntityIterator {
        @NotNull
        private final EntityIterator propIterator;
        private EntityId nextId;
        private final LongSet rightOrder;
        private LongIterator rightOrderIt;
        private boolean hasNull;
        private boolean rightOrderEmpty;

        private NonStableSortIterator(@NotNull PersistentStoreTransaction txn, EntityIterator propIterator) {
            super(SortIterable.this.propIndex);
            this.propIterator = propIterator;
            EntityIdSet sourceSet = SortIterable.this.source.toSet(txn);
            this.hasNull = sourceSet.contains(null);
            this.rightOrder = sourceSet.getTypeSetSnapshot(SortIterable.this.sourceTypeId);
            this.rightOrderEmpty = this.rightOrder.isEmpty();
            this.nextId = null;
        }

        @Override
        protected boolean hasNextImpl() {
            LongIterator it;
            while (!this.rightOrderEmpty && this.propIterator.hasNext()) {
                EntityId nextId = this.propIterator.nextId();
                if (nextId == null || !this.rightOrder.remove(nextId.getLocalId())) continue;
                this.rightOrderEmpty = this.rightOrder.isEmpty();
                this.nextId = nextId;
                return true;
            }
            if (this.rightOrderIt == null) {
                this.rightOrderIt = this.rightOrder.iterator();
            }
            if ((it = this.rightOrderIt).hasNext()) {
                long localId = it.nextLong();
                this.nextId = new PersistentEntityId(SortIterable.this.sourceTypeId, localId);
                return true;
            }
            if (this.hasNull) {
                this.nextId = null;
                this.hasNull = false;
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            return this.nextId;
        }
    }

    private final class StableSortIterator
    extends NonDisposableEntityIterator
    implements PropertyValueIterator {
        @NotNull
        private final PropertyValueIterator propertyValueIterator;
        private final PriorityQueue<Long> sameValueQueue;
        private final LongHashMap<Integer> rightOrder;
        private long nextId;
        private long lastEntityId;
        private Comparable currentValue;
        private Comparable lastValue;

        private StableSortIterator(PropertyValueIterator propertyValueIterator) {
            super(SortIterable.this.propIndex);
            this.propertyValueIterator = propertyValueIterator;
            this.sameValueQueue = new PriorityQueue<Long>(4, new Comparator<Long>(){

                @Override
                public int compare(Long o1, Long o2) {
                    return (Integer)StableSortIterator.this.rightOrder.get((Object)o1) - (Integer)StableSortIterator.this.rightOrder.get((Object)o2);
                }
            });
            this.rightOrder = SortIterable.this.getRightOrder();
            this.currentValue = null;
            this.lastValue = null;
        }

        @Override
        protected boolean hasNextImpl() {
            if (this.sameValueQueue.isEmpty()) {
                Comparable lastValue = this.lastValue;
                if (lastValue != null) {
                    this.currentValue = lastValue;
                    this.sameValueQueue.offer(this.lastEntityId);
                    this.lastValue = null;
                }
                while (this.propertyValueIterator.hasNext()) {
                    long nextId = this.propertyValueIterator.nextId().getLocalId();
                    if (!this.rightOrder.containsKey(nextId)) continue;
                    Comparable currentValue = this.propertyValueIterator.currentValue();
                    if (currentValue != null && lastValue != null && lastValue.compareTo(currentValue) != 0) {
                        this.lastValue = currentValue;
                        this.lastEntityId = nextId;
                        break;
                    }
                    lastValue = currentValue;
                    this.currentValue = currentValue;
                    this.sameValueQueue.offer(nextId);
                }
            }
            block1: while (true) {
                if (!this.sameValueQueue.isEmpty()) {
                    long id;
                    this.nextId = id = this.sameValueQueue.poll().longValue();
                    this.rightOrder.remove(id);
                    return true;
                }
                this.currentValue = null;
                if (this.rightOrder.isEmpty()) break;
                Iterator iterator = this.rightOrder.keySet().iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block1;
                    long localId = (Long)iterator.next();
                    this.sameValueQueue.offer(localId);
                }
                break;
            }
            return false;
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            long nextId = this.nextId;
            return nextId == Long.MAX_VALUE ? null : new PersistentEntityId(SortIterable.this.sourceTypeId, nextId);
        }

        @Override
        public Comparable currentValue() {
            return this.currentValue;
        }
    }
}

