/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableDecoratorBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleDecorator;
import jetbrains.exodus.entitystore.iterate.EntityIterableInstantiator;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.NonDisposableEntityIterator;
import org.jetbrains.annotations.NotNull;

public class TakeEntityIterable
extends EntityIterableDecoratorBase {
    private final int itemsToTake;

    protected TakeEntityIterable(@NotNull PersistentStoreTransaction txn, @NotNull EntityIterableBase source, int itemsToTake) {
        super(txn, source);
        this.itemsToTake = itemsToTake;
    }

    public static EntityIterableType getType() {
        return EntityIterableType.TAKE;
    }

    @Override
    public boolean isSortedById() {
        return this.source.isSortedById();
    }

    @Override
    public boolean canBeCached() {
        return false;
    }

    @Override
    @NotNull
    public EntityIteratorBase getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        return new NonDisposableEntityIterator(this){
            @NotNull
            private final EntityIteratorBase sourceIt;
            private int processed;
            {
                this.sourceIt = (EntityIteratorBase)TakeEntityIterable.this.source.iterator();
                this.processed = 0;
            }

            @Override
            protected boolean hasNextImpl() {
                return this.processed < TakeEntityIterable.this.itemsToTake && this.sourceIt.hasNextImpl();
            }

            @Override
            public EntityId nextIdImpl() {
                ++this.processed;
                return this.sourceIt.nextIdImpl();
            }
        };
    }

    @Override
    @NotNull
    protected EntityIterableHandle getHandleImpl() {
        return new EntityIterableHandleDecorator(this.getStore(), TakeEntityIterable.getType(), this.source.getHandle()){

            @Override
            public void toString(@NotNull StringBuilder builder) {
                super.toString(builder);
                builder.append(TakeEntityIterable.this.itemsToTake);
                builder.append('-');
                this.applyDecoratedToBuilder(builder);
            }

            @Override
            public void hashCode(@NotNull EntityIterableHandleBase.EntityIterableHandleHash hash) {
                hash.apply(TakeEntityIterable.this.itemsToTake);
                hash.applyDelimiter();
                super.hashCode(hash);
            }
        };
    }

    static {
        TakeEntityIterable.registerType(TakeEntityIterable.getType(), new EntityIterableInstantiator(){

            @Override
            public EntityIterableBase instantiate(PersistentStoreTransaction txn, PersistentEntityStoreImpl store, Object[] parameters) {
                return new TakeEntityIterable(txn, (EntityIterableBase)parameters[1], Integer.valueOf((String)parameters[0]));
            }
        });
    }
}

