/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.tables;

import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.bindings.IntegerBinding;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.tables.EntityIdBinding;
import jetbrains.exodus.util.LightOutputStream;
import org.jetbrains.annotations.NotNull;

public class LinkValue {
    @NotNull
    private final EntityId entityId;
    private final int linkId;

    public LinkValue(@NotNull EntityId entityId, int linkId) {
        this.entityId = entityId;
        this.linkId = linkId;
    }

    @NotNull
    public EntityId getEntityId() {
        return this.entityId;
    }

    public int getLinkId() {
        return this.linkId;
    }

    public static LinkValue entryToLinkValue(@NotNull ByteIterable entry) {
        ByteIterator it = entry.iterator();
        int linkId = IntegerBinding.readCompressed((ByteIterator)it);
        return new LinkValue(EntityIdBinding.iteratorToEntityId(it), linkId);
    }

    public static ArrayByteIterable linkValueToEntry(@NotNull LinkValue object) {
        LightOutputStream output = new LightOutputStream();
        int[] bytes = new int[8];
        IntegerBinding.writeCompressed((LightOutputStream)output, (int)object.linkId, (int[])bytes);
        EntityIdBinding.writeEntityId(output, object.entityId, bytes);
        return output.asArrayByteIterable();
    }
}

