/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.env;

import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.env.DatabaseRoot;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.env.LoggableIteratorUnsafe;
import jetbrains.exodus.env.MetaTreeImpl;
import jetbrains.exodus.env.MetaTreePrototype;
import jetbrains.exodus.io.Block;
import jetbrains.exodus.log.BlockDataIterator;
import jetbrains.exodus.log.BlockSet;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.LogTip;
import jetbrains.exodus.log.NullLoggable;
import jetbrains.exodus.log.RandomAccessLoggable;
import jetbrains.exodus.tree.btree.BTree;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a6\u0010\u0000\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0002\u001a#\u0010\u000b\u001a\u0002H\f\"\u0004\b\u0000\u0010\f*\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\f0\u000f\u00a2\u0006\u0002\u0010\u0010\u001a#\u0010\u0011\u001a\u0002H\f\"\u0004\b\u0000\u0010\f*\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\f0\u000f\u00a2\u0006\u0002\u0010\u0010\u001a(\u0010\u0012\u001a\u00020\u0013*\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00032\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f\u001a\f\u0010\u0000\u001a\u00020\u0018*\u00020\rH\u0000\u001a\"\u0010\u0000\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0001*\u00020\u00052\u0006\u0010\b\u001a\u00020\u0003H\u0002\u001a\f\u0010\u0019\u001a\u00020\u0018*\u00020\rH\u0002\u00a8\u0006\u001a"}, d2={"tryUpdate", "Lkotlin/Pair;", "Ljetbrains/exodus/env/DatabaseRoot;", "Ljetbrains/exodus/log/LogTip;", "log", "Ljetbrains/exodus/log/Log;", "lastBlock", "Ljetbrains/exodus/io/Block;", "tip", "blockSet", "Ljetbrains/exodus/log/BlockSet$Mutable;", "executeInCommitLock", "T", "Ljetbrains/exodus/env/EnvironmentImpl;", "action", "Lkotlin/Function0;", "(Ljetbrains/exodus/env/EnvironmentImpl;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "executeInMetaWriteLock", "reopenMetaTree", "", "proto", "Ljetbrains/exodus/env/MetaTreePrototype;", "rollbackTo", "confirm", "", "tryUpdateUnsafe", "xodus-environment"})
public final class UnsafeKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T executeInCommitLock(@NotNull EnvironmentImpl $receiver, @NotNull Function0<? extends T> action) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        Object object2 = $receiver.commitLock;
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"commitLock");
        Object object3 = object2;
        synchronized (object3) {
            object = action.invoke();
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T executeInMetaWriteLock(@NotNull EnvironmentImpl $receiver, @NotNull Function0<? extends T> action) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        ReentrantReadWriteLock.WriteLock writeLock = $receiver.metaWriteLock;
        Intrinsics.checkExpressionValueIsNotNull((Object)writeLock, (String)"metaWriteLock");
        Lock lock = writeLock;
        lock.lock();
        try {
            object = action.invoke();
        }
        finally {
            lock.unlock();
        }
        return (T)object;
    }

    /*
     * WARNING - void declaration
     */
    public static final void reopenMetaTree(@NotNull EnvironmentImpl $receiver, @NotNull MetaTreePrototype proto, @NotNull LogTip rollbackTo, @NotNull Function0<? extends LogTip> confirm) {
        void logTip;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        Intrinsics.checkParameterIsNotNull((Object)rollbackTo, (String)"rollbackTo");
        Intrinsics.checkParameterIsNotNull(confirm, (String)"confirm");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        try {
            UnsafeKt.executeInMetaWriteLock($receiver, (Function0)new Function0<Unit>($receiver, (Ref.ObjectRef)logTip, confirm, proto){
                final /* synthetic */ EnvironmentImpl receiver$0;
                final /* synthetic */ Ref.ObjectRef $logTip;
                final /* synthetic */ Function0 $confirm;
                final /* synthetic */ MetaTreePrototype $proto;

                public final void invoke() {
                    Object object = this.$confirm.invoke();
                    Ref.ObjectRef objectRef = this.$logTip;
                    LogTip it = (LogTip)object;
                    this.receiver$0.setMetaTreeInternal(MetaTreeImpl.create(this.receiver$0, it, this.$proto));
                    Object object2 = object;
                    objectRef.element = (LogTip)object2;
                }
                {
                    this.receiver$0 = environmentImpl;
                    this.$logTip = objectRef;
                    this.$confirm = function0;
                    this.$proto = metaTreePrototype;
                    super(0);
                }
            });
        }
        catch (Throwable t) {
            LogTip logTip2 = (LogTip)logTip.element;
            if (logTip2 != null) {
                LogTip logTip3;
                LogTip it = logTip3 = logTip2;
                $receiver.getLog().setHighAddress(it, rollbackTo.highAddress);
            }
            RuntimeException runtimeException = ExodusException.toExodusException((Throwable)t, (String)"Failed to reopen MetaTree");
            Intrinsics.checkExpressionValueIsNotNull((Object)runtimeException, (String)"ExodusException.toExodus\u2026iled to reopen MetaTree\")");
            throw (Throwable)runtimeException;
        }
    }

    public static final boolean tryUpdate(@NotNull EnvironmentImpl $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return (Boolean)UnsafeKt.executeInCommitLock($receiver, (Function0)new Function0<Boolean>($receiver){
            final /* synthetic */ EnvironmentImpl receiver$0;

            public final boolean invoke() {
                return UnsafeKt.access$tryUpdateUnsafe(this.receiver$0);
            }
            {
                this.receiver$0 = environmentImpl;
                super(0);
            }
        });
    }

    private static final boolean tryUpdateUnsafe(@NotNull EnvironmentImpl $receiver) {
        LogTip tip = $receiver.getLog().getTip();
        Log log = $receiver.getLog();
        Intrinsics.checkExpressionValueIsNotNull((Object)log, (String)"log");
        Pair<DatabaseRoot, LogTip> pair = UnsafeKt.tryUpdate(log, tip);
        if (pair != null) {
            Pair<DatabaseRoot, LogTip> pair2;
            Pair<DatabaseRoot, LogTip> it = pair2 = pair;
            LogTip updatedTip = (LogTip)it.getSecond();
            return (Boolean)UnsafeKt.executeInMetaWriteLock($receiver, (Function0)new Function0<Boolean>(updatedTip, it, $receiver, tip){
                final /* synthetic */ LogTip $updatedTip;
                final /* synthetic */ Pair $it;
                final /* synthetic */ EnvironmentImpl receiver$0$inlined;
                final /* synthetic */ LogTip $tip$inlined;
                {
                    this.$updatedTip = logTip;
                    this.$it = pair;
                    this.receiver$0$inlined = environmentImpl;
                    this.$tip$inlined = logTip2;
                    super(0);
                }

                public final boolean invoke() {
                    boolean bl;
                    try {
                        boolean bl2;
                        Object object;
                        this.receiver$0$inlined.getLog().compareAndSetTip(this.$tip$inlined, this.$updatedTip);
                        long root = ((DatabaseRoot)this.$it.getFirst()).getRootAddress();
                        BTree bTree = this.receiver$0$inlined.loadMetaTree(root, this.$updatedTip);
                        if (bTree != null) {
                            object = bTree;
                            BTree metaTree = object;
                            MetaTreeImpl metaTreeImpl = new MetaTreeImpl(metaTree, root, this.$updatedTip);
                            EnvironmentImpl environmentImpl = this.receiver$0$inlined;
                            MetaTreeImpl it = metaTreeImpl;
                            MetaTreeImpl.cloneTree(metaTree);
                            MetaTreeImpl metaTreeImpl2 = metaTreeImpl;
                            environmentImpl.setMetaTreeInternal(metaTreeImpl2);
                            bl2 = true;
                        } else {
                            Object $receiver = object = this.receiver$0$inlined;
                            ((EnvironmentImpl)$receiver).throwableOnCommit = new Throwable("Cannot load updated meta tree");
                            bl2 = false;
                        }
                        bl = bl2;
                    }
                    catch (Throwable t) {
                        this.receiver$0$inlined.throwableOnCommit = new Throwable("Cannot read updated meta tree", t);
                        bl = true;
                    }
                    return bl;
                }
            });
        }
        return false;
    }

    private static final Pair<DatabaseRoot, LogTip> tryUpdate(@NotNull Log $receiver, LogTip tip) {
        Block block;
        BlockSet.Mutable blockSet = tip.getBlockSetCopy();
        Iterable addedBlocks = $receiver.getConfig().getReader().getBlocks($receiver.getFileAddress(tip.highAddress));
        Iterator itr = addedBlocks.iterator();
        if (!itr.hasNext()) {
            return null;
        }
        do {
            Block block2 = block = (Block)itr.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)block2, (String)"block");
            blockSet.add(block2.getAddress(), block);
        } while (itr.hasNext());
        Block lastBlock = block;
        BlockSet.Mutable mutable = blockSet;
        Intrinsics.checkExpressionValueIsNotNull((Object)mutable, (String)"blockSet");
        return UnsafeKt.tryUpdate($receiver, lastBlock, tip, mutable);
    }

    /*
     * WARNING - void declaration
     */
    private static final Pair<DatabaseRoot, LogTip> tryUpdate(Log log, Block lastBlock, LogTip tip, BlockSet.Mutable blockSet) {
        void approvedHighAddress;
        long lastBlockAddress = lastBlock.getAddress();
        long highAddress = lastBlockAddress + lastBlock.length();
        long l = tip.approvedHighAddress;
        long startAddress = Math.max(l, lastBlockAddress);
        if (startAddress > lastBlockAddress + log.getFileLengthBound()) {
            throw (Throwable)new IllegalStateException("Log truncated abnormally, aborting");
        }
        BlockDataIterator dataIterator = new BlockDataIterator(log, tip, lastBlock, startAddress);
        LoggableIteratorUnsafe loggables = new LoggableIteratorUnsafe(log, dataIterator);
        byte rootType = 1;
        DatabaseRoot lastRoot = null;
        Ref.LongRef longRef = new Ref.LongRef();
        longRef.element = startAddress;
        try {
            RandomAccessLoggable loggable;
            long loggableEnd;
            while (loggables.hasNext() && (loggableEnd = (loggable = loggables.next()).getAddress() + (long)loggable.length()) <= highAddress) {
                if (loggable.getType() == rootType) {
                    lastRoot = new DatabaseRoot(loggable, loggables.getIterator$xodus_environment());
                } else if (!NullLoggable.isNullLoggable(loggable)) {
                    long expectedDataLength = loggable.getDataLength();
                    if (loggables.getIterator$xodus_environment().skip(expectedDataLength) < expectedDataLength) break;
                }
                if (loggableEnd == dataIterator.getAddress()) {
                    approvedHighAddress.element = loggableEnd;
                    if (loggableEnd != highAddress) continue;
                }
                break;
            }
        }
        catch (ExodusException e) {
            Log.Companion.getLogger().info((Throwable)e, (Function0)new Function0<String>((Ref.LongRef)approvedHighAddress){
                final /* synthetic */ Ref.LongRef $approvedHighAddress;

                @NotNull
                public final String invoke() {
                    StringBuilder stringBuilder = new StringBuilder().append("Exception on Log recovery by tryUpdate() in ");
                    Thread thread = Thread.currentThread();
                    Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
                    return stringBuilder.append(thread.getName()).append(". Approved high address = ").append(this.$approvedHighAddress.element).toString();
                }
                {
                    this.$approvedHighAddress = longRef;
                    super(0);
                }
            });
        }
        if (lastRoot == null) {
            return null;
        }
        DatabaseRoot databaseRoot = lastRoot;
        BlockDataIterator $receiver = dataIterator;
        LogTip logTip = new LogTip($receiver.getLastPage(), $receiver.getLastPageAddress(), $receiver.getLastPageCount(), highAddress, approvedHighAddress.element, blockSet.endWrite());
        return TuplesKt.to((Object)databaseRoot, (Object)logTip);
    }

    public static final /* synthetic */ boolean access$tryUpdateUnsafe(@NotNull EnvironmentImpl $receiver) {
        return UnsafeKt.tryUpdateUnsafe($receiver);
    }
}

