/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.gc;

import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Scanner;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.core.dataStructures.Pair;
import jetbrains.exodus.core.dataStructures.hash.LongHashMap;
import jetbrains.exodus.core.dataStructures.hash.PackedLongHashSet;
import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.EnvironmentConfig;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.StoreImpl;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.env.TransactionalExecutable;
import jetbrains.exodus.gc.ComputeUtilizationFromScratchJob;
import jetbrains.exodus.gc.GarbageCollector;
import jetbrains.exodus.gc.GcJob;
import jetbrains.exodus.gc.UtilizationProfile;
import jetbrains.exodus.io.Block;
import jetbrains.exodus.io.DataReader;
import jetbrains.exodus.io.DataWriter;
import jetbrains.exodus.log.AbstractBlockListener;
import jetbrains.exodus.log.CompressedUnsignedLongByteIterable;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.tree.ExpiredLoggableCollection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.IntIterator;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010(\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001<B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\r\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0017J\b\u0010\u0018\u001a\u00020\u0016H\u0002J\u0006\u0010\u0019\u001a\u00020\u0016J\r\u0010\u001a\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u001bJ\r\u0010\u001c\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u001dJ\u0015\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 H\u0000\u00a2\u0006\u0002\b!J\u000e\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$J\u0015\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b'J\u001b\u0010(\u001a\b\u0012\u0004\u0012\u00020\b0)2\u0006\u0010*\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b+J\u0006\u0010,\u001a\u00020\u0016J\u000e\u0010-\u001a\u00020\u00162\u0006\u0010.\u001a\u00020/J\u0015\u00100\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b1J\u0015\u00102\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b3J\u000e\u00104\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$J\u001b\u00105\u001a\u00020\u00162\f\u00106\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0000\u00a2\u0006\u0002\b7J\r\u00108\u001a\u000209H\u0000\u00a2\u0006\u0002\b:J\u0006\u0010;\u001a\u000209R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Ljetbrains/exodus/gc/UtilizationProfile;", "", "env", "Ljetbrains/exodus/env/EnvironmentImpl;", "gc", "Ljetbrains/exodus/gc/GarbageCollector;", "(Ljetbrains/exodus/env/EnvironmentImpl;Ljetbrains/exodus/gc/GarbageCollector;)V", "fileSize", "", "filesUtilization", "Ljetbrains/exodus/core/dataStructures/hash/LongHashMap;", "Ljetbrains/exodus/gc/UtilizationProfile$MutableLong;", "isDirty", "", "()Z", "setDirty", "(Z)V", "log", "Ljetbrains/exodus/log/Log;", "totalBytes", "totalFreeBytes", "clear", "", "clear$xodus_environment", "clearUtilization", "computeUtilizationFromScratch", "estimateTotalBytes", "estimateTotalBytes$xodus_environment", "estimateTotalBytesAndWakeGcIfNecessary", "estimateTotalBytesAndWakeGcIfNecessary$xodus_environment", "fetchExpiredLoggables", "loggables", "Ljetbrains/exodus/tree/ExpiredLoggableCollection;", "fetchExpiredLoggables$xodus_environment", "forceSave", "txn", "Ljetbrains/exodus/env/Transaction;", "getFileFreeBytes", "fileAddress", "getFileFreeBytes$xodus_environment", "getFilesSortedByUtilization", "", "highFile", "getFilesSortedByUtilization$xodus_environment", "load", "loadUtilizationFromFile", "path", "", "removeFile", "removeFile$xodus_environment", "resetFile", "resetFile$xodus_environment", "save", "setUtilization", "usedSpace", "setUtilization$xodus_environment", "totalFreeSpacePercent", "", "totalFreeSpacePercent$xodus_environment", "totalUtilizationPercent", "MutableLong", "xodus-environment"})
public final class UtilizationProfile {
    private final Log log;
    private final long fileSize;
    private final LongHashMap<MutableLong> filesUtilization;
    private long totalBytes;
    private long totalFreeBytes;
    private volatile boolean isDirty;
    private final EnvironmentImpl env;
    private final GarbageCollector gc;

    public final boolean isDirty() {
        return this.isDirty;
    }

    public final void setDirty(boolean bl) {
        this.isDirty = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear$xodus_environment() {
        Unit unit;
        Unit $i$a$1$synchronized;
        Unit $receiver;
        Unit $receiver$iv = this.filesUtilization;
        synchronized ($receiver$iv) {
            $receiver = $receiver$iv;
            $receiver.clear();
            $i$a$1$synchronized = Unit.INSTANCE;
        }
        $receiver = unit = $i$a$1$synchronized;
        this.estimateTotalBytes$xodus_environment();
    }

    public final void load() {
        EnvironmentConfig ec;
        EnvironmentConfig environmentConfig = ec = this.env.getEnvironmentConfig();
        Intrinsics.checkExpressionValueIsNotNull((Object)environmentConfig, (String)"ec");
        if (environmentConfig.getGcUtilizationFromScratch()) {
            this.computeUtilizationFromScratch();
        } else {
            String storedUtilization;
            String string = storedUtilization = ec.getGcUtilizationFromFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"storedUtilization");
            CharSequence charSequence = string;
            if (!(charSequence.length() == 0)) {
                this.loadUtilizationFromFile(storedUtilization);
            } else {
                this.env.executeInReadonlyTransaction(new TransactionalExecutable(this){
                    final /* synthetic */ UtilizationProfile this$0;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void execute(@NotNull Transaction txn) {
                        Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
                        if (!UtilizationProfile.access$getEnv$p(this.this$0).storeExists("exodus.gc.up", txn)) {
                            if (UtilizationProfile.access$getEnv$p(this.this$0).getAllStoreCount() == 0L && UtilizationProfile.access$getLog$p(this.this$0).getNumberOfFiles() <= 1L) {
                                UtilizationProfile.access$clearUtilization(this.this$0);
                            } else {
                                this.this$0.computeUtilizationFromScratch();
                            }
                        } else {
                            Throwable $receiver;
                            boolean inconsistent;
                            LongHashMap filesUtilization;
                            block18: {
                                filesUtilization = new LongHashMap();
                                StoreImpl store = UtilizationProfile.access$getEnv$p(this.this$0).openStore("exodus.gc.up", StoreConfig.WITHOUT_DUPLICATES, txn);
                                Closeable closeable = (Closeable)store.openCursor(txn);
                                Throwable throwable = null;
                                try {
                                    Cursor cursor = (Cursor)closeable;
                                    while (true) {
                                        Cursor cursor2 = cursor;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)cursor2, (String)"cursor");
                                        if (!cursor2.getNext()) break;
                                        long fileAddress = LongBinding.compressedEntryToLong((ByteIterable)cursor.getKey());
                                        long freeBytes = CompressedUnsignedLongByteIterable.getLong(cursor.getValue());
                                        if (freeBytes == 0L) continue;
                                        Map map = (Map)filesUtilization;
                                        Long l = fileAddress;
                                        MutableLong mutableLong = new MutableLong(freeBytes);
                                        map.put(l, mutableLong);
                                    }
                                    cursor = Unit.INSTANCE;
                                }
                                catch (Throwable cursor) {
                                    throwable = cursor;
                                    throw cursor;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                                }
                                inconsistent = false;
                                $receiver = throwable = new PackedLongHashSet((Collection)filesUtilization.keySet());
                                Object $receiver$iv = UtilizationProfile.access$getLog$p(this.this$0).getAllFileAddresses();
                                for (long element$iv : $receiver$iv) {
                                    long it = element$iv;
                                    if ($receiver.remove(it)) continue;
                                    inconsistent = true;
                                    break block18;
                                }
                                $receiver$iv = (Collection)((Object)$receiver);
                                if (!$receiver$iv.isEmpty()) {
                                    inconsistent = true;
                                }
                            }
                            if (inconsistent) {
                                this.this$0.computeUtilizationFromScratch();
                            } else {
                                LongHashMap $receiver$iv = UtilizationProfile.access$getFilesUtilization$p(this.this$0);
                                synchronized ($receiver$iv) {
                                    $receiver = $receiver$iv;
                                    $receiver.clear();
                                    $receiver.putAll((Map)filesUtilization);
                                    Unit unit = Unit.INSTANCE;
                                }
                                this.this$0.estimateTotalBytesAndWakeGcIfNecessary$xodus_environment();
                            }
                        }
                    }
                    {
                        this.this$0 = utilizationProfile;
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(@NotNull Transaction txn) {
        Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
        if (this.isDirty) {
            ArrayList arrayList;
            StoreImpl store = this.env.openStore("exodus.gc.up", StoreConfig.WITHOUT_DUPLICATES, txn);
            Closeable closeable = (Closeable)store.openCursor(txn);
            Object object = null;
            try {
                Cursor cursor = (Cursor)closeable;
                while (true) {
                    boolean bl;
                    Cursor cursor2 = cursor;
                    Intrinsics.checkExpressionValueIsNotNull((Object)cursor2, (String)"cursor");
                    if (!cursor2.getNext()) break;
                    long fileAddress = LongBinding.compressedEntryToLong((ByteIterable)cursor.getKey());
                    LongHashMap<MutableLong> $receiver$iv = this.filesUtilization;
                    synchronized ($receiver$iv) {
                        LongHashMap<MutableLong> $receiver = $receiver$iv;
                        bl = !$receiver.containsKey(fileAddress);
                    }
                    if (!bl) continue;
                    cursor.deleteCurrent();
                }
                cursor = Unit.INSTANCE;
            }
            catch (Throwable cursor) {
                object = cursor;
                throw cursor;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
            LongHashMap<MutableLong> $receiver$iv = this.filesUtilization;
            synchronized ($receiver$iv) {
                LongHashMap<MutableLong> $receiver = $receiver$iv;
                arrayList = new ArrayList($receiver.entrySet());
            }
            for (Map.Entry entry : arrayList) {
                Object k = entry.getKey();
                Intrinsics.checkExpressionValueIsNotNull(k, (String)"entry.key");
                store.put(txn, (ByteIterable)LongBinding.longToCompressedEntry((long)((Number)k).longValue()), CompressedUnsignedLongByteIterable.getIterable(((MutableLong)entry.getValue()).getValue()));
            }
        }
    }

    public final void forceSave(@NotNull Transaction txn) {
        Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
        this.isDirty = true;
        this.save(txn);
    }

    public final int totalFreeSpacePercent$xodus_environment() {
        long totalBytes = this.totalBytes;
        return (int)(totalBytes == 0L ? 0L : this.totalFreeBytes * 100L / totalBytes);
    }

    public final int totalUtilizationPercent() {
        return 100 - this.totalFreeSpacePercent$xodus_environment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getFileFreeBytes$xodus_environment(long fileAddress) {
        long l;
        LongHashMap<MutableLong> $receiver$iv = this.filesUtilization;
        synchronized ($receiver$iv) {
            LongHashMap<MutableLong> $receiver = $receiver$iv;
            MutableLong mutableLong = (MutableLong)$receiver.get(fileAddress);
            l = mutableLong != null ? mutableLong.getValue() : Long.MAX_VALUE;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void fetchExpiredLoggables$xodus_environment(@NotNull ExpiredLoggableCollection loggables) {
        Intrinsics.checkParameterIsNotNull((Object)loggables, (String)"loggables");
        Ref.LongRef longRef = new Ref.LongRef();
        longRef.element = -1L;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        PackedLongHashSet set = new PackedLongHashSet(null, 1, null);
        LongHashMap<MutableLong> $receiver$iv = this.filesUtilization;
        synchronized ($receiver$iv) {
            void prevFreeBytes;
            void prevFileAddress;
            LongHashMap<MutableLong> $receiver = $receiver$iv;
            loggables.forEach((Function2<? super Long, ? super Integer, Unit>)((Function2)new Function2<Long, Integer, Unit>($receiver, this, loggables, set, (Ref.LongRef)prevFileAddress, (Ref.ObjectRef)prevFreeBytes){
                final /* synthetic */ LongHashMap receiver$0;
                final /* synthetic */ UtilizationProfile this$0;
                final /* synthetic */ ExpiredLoggableCollection $loggables$inlined;
                final /* synthetic */ PackedLongHashSet $set$inlined;
                final /* synthetic */ Ref.LongRef $prevFileAddress$inlined;
                final /* synthetic */ Ref.ObjectRef $prevFreeBytes$inlined;
                {
                    this.receiver$0 = longHashMap;
                    this.this$0 = utilizationProfile;
                    this.$loggables$inlined = expiredLoggableCollection;
                    this.$set$inlined = packedLongHashSet;
                    this.$prevFileAddress$inlined = longRef;
                    this.$prevFreeBytes$inlined = objectRef;
                    super(2);
                }

                public final void invoke(long address, int length) {
                    if (this.$set$inlined.add(address)) {
                        MutableLong freeBytes;
                        long fileAddress = UtilizationProfile.access$getLog$p(this.this$0).getFileAddress(address);
                        MutableLong mutableLong = this.$prevFileAddress$inlined.element == fileAddress ? (MutableLong)this.$prevFreeBytes$inlined.element : (MutableLong)this.receiver$0.get(fileAddress);
                        if (mutableLong == null) {
                            MutableLong mutableLong2;
                            MutableLong it = mutableLong2 = new MutableLong(0L);
                            Map map = (Map)this.receiver$0;
                            Long l = fileAddress;
                            MutableLong mutableLong3 = it;
                            map.put(l, mutableLong3);
                            mutableLong = mutableLong2;
                        }
                        MutableLong mutableLong4 = freeBytes = mutableLong;
                        mutableLong4.setValue(mutableLong4.getValue() + (long)length);
                        this.$prevFreeBytes$inlined.element = freeBytes;
                        this.$prevFileAddress$inlined.element = fileAddress;
                    }
                }
            }));
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeFile$xodus_environment(long fileAddress) {
        LongHashMap<MutableLong> $receiver$iv = this.filesUtilization;
        synchronized ($receiver$iv) {
            LongHashMap<MutableLong> $receiver = $receiver$iv;
            $receiver.remove(fileAddress);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resetFile$xodus_environment(long fileAddress) {
        LongHashMap<MutableLong> $receiver$iv = this.filesUtilization;
        synchronized ($receiver$iv) {
            LongHashMap<MutableLong> $receiver = $receiver$iv;
            MutableLong mutableLong = (MutableLong)$receiver.get(fileAddress);
            if (mutableLong != null) {
                mutableLong.setValue(0L);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void estimateTotalBytes$xodus_environment() {
        long l;
        long totalBytes;
        long l2;
        long[] fileAddresses = this.log.getAllFileAddresses();
        int filesCount = fileAddresses.length;
        int minFileAge = this.gc.getMinFileAge$xodus_environment();
        LongHashMap<MutableLong> $receiver$iv = this.filesUtilization;
        synchronized ($receiver$iv) {
            void $receiver$iv2;
            long initial$iv;
            LongHashMap<MutableLong> $receiver = $receiver$iv;
            Iterable iterable = (Iterable)RangesKt.until((int)minFileAge, (int)filesCount);
            long accumulator$iv = initial$iv = 0L;
            Iterator iterator = $receiver$iv2.iterator();
            while (iterator.hasNext()) {
                void i2;
                int element$iv;
                int n = element$iv = ((IntIterator)iterator).nextInt();
                long sum = accumulator$iv;
                MutableLong mutableLong = (MutableLong)$receiver.get(fileAddresses[i2]);
                accumulator$iv = sum + (mutableLong != null ? mutableLong.getValue() : this.fileSize);
            }
            l2 = accumulator$iv;
        }
        long totalFreeBytes = l2;
        this.totalBytes = totalBytes = filesCount > minFileAge ? (long)(filesCount - minFileAge) * this.fileSize : 0L;
        UtilizationProfile utilizationProfile = this;
        utilizationProfile.totalFreeBytes = l = Math.min(totalFreeBytes, totalBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final Iterator<Long> getFilesSortedByUtilization$xodus_environment(long highFile) {
        void totalCleanableBytes;
        void totalFreeBytes;
        long[] fileAddresses = this.log.getAllFileAddresses();
        long maxFreeBytes = this.fileSize * (long)this.gc.getMaximumFreeSpacePercent$xodus_environment() / 100L;
        PriorityQueue<Pair> fragmentedFiles2 = new PriorityQueue<Pair>(10, getFilesSortedByUtilization.fragmentedFiles.1.INSTANCE);
        Ref.LongRef longRef = new Ref.LongRef();
        longRef.element = 0L;
        Ref.LongRef longRef2 = new Ref.LongRef();
        longRef2.element = 0L;
        LongHashMap<MutableLong> $receiver$iv = this.filesUtilization;
        synchronized ($receiver$iv) {
            LongHashMap<MutableLong> $receiver = $receiver$iv;
            Iterable $receiver$iv2 = (Iterable)RangesKt.until((int)this.gc.getMinFileAge$xodus_environment(), (int)fileAddresses.length);
            Iterator iterator = $receiver$iv2.iterator();
            while (iterator.hasNext()) {
                long l;
                int element$iv = ((IntIterator)iterator).nextInt();
                int i2 = element$iv;
                long file = fileAddresses[i2];
                if (file >= highFile || this.gc.isFileCleaned$xodus_environment(file)) continue;
                totalCleanableBytes.element += this.fileSize;
                MutableLong freeBytes = (MutableLong)$receiver.get(file);
                long l2 = totalFreeBytes.element;
                if (freeBytes == null) {
                    fragmentedFiles2.add(new Pair((Object)file, (Object)this.fileSize));
                    l = this.fileSize;
                } else {
                    long freeBytesValue = freeBytes.getValue();
                    if (freeBytesValue > maxFreeBytes) {
                        fragmentedFiles2.add(new Pair((Object)file, (Object)freeBytesValue));
                    }
                    l = freeBytesValue;
                }
                totalFreeBytes.element = l2 + l;
            }
            Unit unit = Unit.INSTANCE;
        }
        return new Iterator<Long>(this, (Ref.LongRef)totalFreeBytes, fragmentedFiles2, (Ref.LongRef)totalCleanableBytes){
            final /* synthetic */ UtilizationProfile this$0;
            final /* synthetic */ Ref.LongRef $totalFreeBytes;
            final /* synthetic */ PriorityQueue $fragmentedFiles;
            final /* synthetic */ Ref.LongRef $totalCleanableBytes;

            public boolean hasNext() {
                return !this.$fragmentedFiles.isEmpty() && this.$totalFreeBytes.element > this.$totalCleanableBytes.element * (long)UtilizationProfile.access$getGc$p(this.this$0).getMaximumFreeSpacePercent$xodus_environment() / 100L;
            }

            @NotNull
            public Long next() {
                Pair pair = (Pair)this.$fragmentedFiles.poll();
                long l = this.$totalFreeBytes.element;
                Pair pair2 = pair;
                Intrinsics.checkExpressionValueIsNotNull((Object)pair2, (String)"pair");
                Object object = pair2.getSecond();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"pair.second");
                this.$totalFreeBytes.element = l - ((Number)object).longValue();
                Object object2 = pair.getFirst();
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"pair.first");
                return (Long)object2;
            }
            {
                this.this$0 = $outer;
                this.$totalFreeBytes = $captured_local_variable$1;
                this.$fragmentedFiles = $captured_local_variable$2;
                this.$totalCleanableBytes = $captured_local_variable$3;
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    public final void loadUtilizationFromFile(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.gc.getCleaner$xodus_environment().getJobProcessor().queueAt((Job)new GcJob(this.gc, (Function0<Unit>)((Function0)new Function0<Unit>(this, path){
            final /* synthetic */ UtilizationProfile this$0;
            final /* synthetic */ String $path;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                LongHashMap usedSpace = new LongHashMap();
                try {
                    Closeable closeable = new Scanner(new File(this.$path));
                    Throwable throwable = null;
                    try {
                        Scanner scanner = (Scanner)closeable;
                        while (scanner.hasNextLong()) {
                            long address = scanner.nextLong();
                            long usedBytes = scanner.nextLong();
                            Map map = (Map)usedSpace;
                            Long l = address;
                            Long l2 = usedBytes;
                            map.put(l, l2);
                        }
                        scanner = Unit.INSTANCE;
                    }
                    catch (Throwable scanner) {
                        throwable = scanner;
                        throw scanner;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                catch (Throwable t) {
                    GarbageCollector.Companion.loggingError$xodus_environment((Function0<String>)((Function0)new Function0<String>(this){
                        final /* synthetic */ loadUtilizationFromFile.1 this$0;

                        @NotNull
                        public final String invoke() {
                            return "Failed to load utilization from " + this.this$0.$path;
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    }), t);
                }
                LongHashMap $receiver$iv = UtilizationProfile.access$getFilesUtilization$p(this.this$0);
                synchronized ($receiver$iv) {
                    LongHashMap $receiver = $receiver$iv;
                    $receiver.clear();
                    this.this$0.setUtilization$xodus_environment((LongHashMap<Long>)usedSpace);
                    Unit unit = Unit.INSTANCE;
                }
            }
            {
                this.this$0 = utilizationProfile;
                this.$path = string;
                super(0);
            }
        })), this.gc.getStartTime$xodus_environment());
    }

    public final void computeUtilizationFromScratch() {
        GarbageCollector.Companion.loggingInfo$xodus_environment((Function0<String>)((Function0)computeUtilizationFromScratch.1.INSTANCE));
        this.gc.getCleaner$xodus_environment().getJobProcessor().queueAt((Job)new ComputeUtilizationFromScratchJob(this.gc), this.gc.getStartTime$xodus_environment());
    }

    public final void estimateTotalBytesAndWakeGcIfNecessary$xodus_environment() {
        this.estimateTotalBytes$xodus_environment();
        if (this.gc.isTooMuchFreeSpace$xodus_environment()) {
            GarbageCollector.wake$default(this.gc, false, 1, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setUtilization$xodus_environment(@NotNull LongHashMap<Long> usedSpace) {
        Intrinsics.checkParameterIsNotNull(usedSpace, (String)"usedSpace");
        LongHashMap<MutableLong> $receiver$iv = this.filesUtilization;
        synchronized ($receiver$iv) {
            LongHashMap<MutableLong> $receiver = $receiver$iv;
            Map map = (Map)usedSpace;
            for (Map.Entry entry : map.entrySet()) {
                Object object = entry;
                Long fileAddress = (Long)object.getKey();
                object = entry;
                Long usedBytes = (Long)object.getValue();
                Long l = fileAddress;
                Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"fileAddress");
                Object object2 = (MutableLong)$receiver.get(l.longValue());
                if (object2 == null) {
                    Object it = object = new MutableLong(0L);
                    Map map2 = (Map)$receiver;
                    Long l2 = fileAddress;
                    Object object3 = it;
                    map2.put(l2, object3);
                    object2 = object;
                }
                long l3 = ((MutableLong)object2).getValue();
                Long l4 = usedBytes;
                Intrinsics.checkExpressionValueIsNotNull((Object)l4, (String)"usedBytes");
                ((MutableLong)object2).setValue(l3 + (this.fileSize - l4));
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void clearUtilization() {
        LongHashMap<MutableLong> $receiver$iv = this.filesUtilization;
        synchronized ($receiver$iv) {
            LongHashMap<MutableLong> $receiver = $receiver$iv;
            $receiver.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    public UtilizationProfile(@NotNull EnvironmentImpl env, @NotNull GarbageCollector gc) {
        Intrinsics.checkParameterIsNotNull((Object)env, (String)"env");
        Intrinsics.checkParameterIsNotNull((Object)gc, (String)"gc");
        this.env = env;
        this.gc = gc;
        Log log = this.env.getLog();
        Intrinsics.checkExpressionValueIsNotNull((Object)log, (String)"env.log");
        this.log = log;
        this.fileSize = this.log.getFileLengthBound();
        this.filesUtilization = new LongHashMap();
        this.log.addBlockListener(new AbstractBlockListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void blockCreated(@NotNull Block block, @NotNull DataReader reader, @NotNull DataWriter writer) {
                Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
                Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
                Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
                LongHashMap $receiver$iv = filesUtilization;
                synchronized ($receiver$iv) {
                    LongHashMap $receiver = $receiver$iv;
                    Map map = (Map)$receiver;
                    Long l = block.getAddress();
                    MutableLong mutableLong = new MutableLong(0L);
                    map.put(l, mutableLong);
                    Unit unit = Unit.INSTANCE;
                }
                this.estimateTotalBytes$xodus_environment();
            }
        });
    }

    @NotNull
    public static final /* synthetic */ EnvironmentImpl access$getEnv$p(UtilizationProfile $this) {
        return $this.env;
    }

    @NotNull
    public static final /* synthetic */ Log access$getLog$p(UtilizationProfile $this) {
        return $this.log;
    }

    public static final /* synthetic */ void access$clearUtilization(UtilizationProfile $this) {
        $this.clearUtilization();
    }

    @NotNull
    public static final /* synthetic */ GarbageCollector access$getGc$p(UtilizationProfile $this) {
        return $this.gc;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\n"}, d2={"Ljetbrains/exodus/gc/UtilizationProfile$MutableLong;", "", "value", "", "(J)V", "getValue", "()J", "setValue", "toString", "", "xodus-environment"})
    private static final class MutableLong {
        private long value;

        @NotNull
        public String toString() {
            return String.valueOf(this.value);
        }

        public final long getValue() {
            return this.value;
        }

        public final void setValue(long l) {
            this.value = l;
        }

        public MutableLong(long value) {
            this.value = value;
        }
    }
}

