/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log;

import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.core.dataStructures.ConcurrentLongObjectCache;
import jetbrains.exodus.core.dataStructures.LongObjectCache;
import jetbrains.exodus.core.dataStructures.LongObjectCacheBase;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.LogCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SeparateLogCache
extends LogCache {
    @NotNull
    private final LongObjectCacheBase<byte[]> pagesCache;

    SeparateLogCache(long memoryUsage, int pageSize, boolean nonBlocking, int cacheGenerationCount) {
        super(memoryUsage, pageSize);
        int pagesCount = (int)(memoryUsage / (long)(pageSize + 80));
        this.pagesCache = nonBlocking ? new ConcurrentLongObjectCache(pagesCount, cacheGenerationCount) : new LongObjectCache(pagesCount);
    }

    SeparateLogCache(int memoryUsagePercentage, int pageSize, boolean nonBlocking, int cacheGenerationCount) {
        super(memoryUsagePercentage, pageSize);
        if (this.memoryUsage == Long.MAX_VALUE) {
            this.pagesCache = nonBlocking ? new ConcurrentLongObjectCache(8192, cacheGenerationCount) : new LongObjectCache();
        } else {
            int pagesCount = (int)(this.memoryUsage / (long)(pageSize + 80));
            this.pagesCache = nonBlocking ? new ConcurrentLongObjectCache(pagesCount, cacheGenerationCount) : new LongObjectCache(pagesCount);
        }
    }

    @Override
    public void clear() {
        try (LongObjectCacheBase.CriticalSection ignored = this.pagesCache.newCriticalSection();){
            this.pagesCache.clear();
        }
    }

    @Override
    public float hitRate() {
        return this.pagesCache.hitRate();
    }

    @Override
    void cachePage(@NotNull Log log, long pageAddress, @NotNull byte[] page) {
        this.cachePage(pageAddress, page);
    }

    @Override
    @NotNull
    ArrayByteIterable getPageIterable(@NotNull Log log, long pageAddress) {
        byte[] page = (byte[])this.pagesCache.tryKeyLocked(pageAddress);
        if (page != null) {
            return new ArrayByteIterable(page);
        }
        page = log.getHighPage(pageAddress);
        if (page != null) {
            return new ArrayByteIterable(page, (int)Math.min(log.getHighAddress() - pageAddress, (long)this.pageSize));
        }
        page = this.readFullPage(log, pageAddress);
        this.cachePage(pageAddress, page);
        return new ArrayByteIterable(page);
    }

    @Override
    @NotNull
    byte[] getPage(@NotNull Log log, long pageAddress) {
        byte[] page = (byte[])this.pagesCache.tryKeyLocked(pageAddress);
        if (page != null) {
            return page;
        }
        page = log.getHighPage(pageAddress);
        if (page != null) {
            return page;
        }
        page = this.readFullPage(log, pageAddress);
        this.cachePage(pageAddress, page);
        return page;
    }

    @Override
    @Nullable
    byte[] getCachedPage(@NotNull Log log, long pageAddress) {
        byte[] page = (byte[])this.pagesCache.getObjectLocked(pageAddress);
        if (page != null) {
            return page;
        }
        page = log.getHighPage(pageAddress);
        if (page != null) {
            return page;
        }
        return null;
    }

    @Override
    protected void removePage(@NotNull Log log, long pageAddress) {
        try (LongObjectCacheBase.CriticalSection ignored = this.pagesCache.newCriticalSection();){
            this.pagesCache.remove(pageAddress);
        }
    }

    private void cachePage(long cacheKey, @NotNull byte[] pageArray) {
        try (LongObjectCacheBase.CriticalSection ignored = this.pagesCache.newCriticalSection();){
            if (this.pagesCache.getObject(cacheKey) == null) {
                this.pagesCache.cacheObject(cacheKey, (Object)SeparateLogCache.postProcessTailPage(pageArray));
            }
        }
    }
}

