/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.patricia;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterableBase;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.tree.INode;
import jetbrains.exodus.tree.MutableTreeRoot;
import jetbrains.exodus.tree.TreeTraverser;
import jetbrains.exodus.tree.patricia.ChildReference;
import jetbrains.exodus.tree.patricia.NodeBase;
import jetbrains.exodus.tree.patricia.NodeChildrenIterator;
import jetbrains.exodus.tree.patricia.PatriciaTreeBase;
import jetbrains.exodus.util.LightOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PatriciaTraverser
implements TreeTraverser {
    private static final int INITIAL_STACK_CAPACITY = 8;
    @NotNull
    private final PatriciaTreeBase tree;
    @NotNull
    NodeChildrenIterator[] stack;
    int top;
    @NotNull
    NodeBase currentNode;
    @Nullable
    private ByteIterable currentValue;
    ChildReference currentChild;
    @Nullable
    NodeChildrenIterator currentIterator;

    PatriciaTraverser(@NotNull PatriciaTreeBase tree, @NotNull NodeBase currentNode) {
        this.tree = tree;
        this.setCurrentNode(currentNode);
        this.stack = new NodeChildrenIterator[8];
        this.top = 0;
    }

    @Override
    public void init(boolean left) {
        if (left) {
            this.getItr();
        } else {
            this.currentIterator = this.currentNode.getChildrenLast();
            this.currentChild = this.currentIterator.getNode();
        }
    }

    @Override
    public boolean isNotEmpty() {
        return this.currentNode.getChildrenCount() > 0;
    }

    @Override
    @NotNull
    public INode moveDown() {
        this.stack = PatriciaTraverser.pushIterator(this.stack, this.currentIterator, this.top);
        this.setCurrentNode(this.currentChild.getNode(this.tree));
        this.getItr();
        ++this.top;
        return this.currentNode;
    }

    @Override
    @NotNull
    public INode moveDownToLast() {
        this.stack = PatriciaTraverser.pushIterator(this.stack, this.currentIterator, this.top);
        this.setCurrentNode(this.currentChild.getNode(this.tree));
        if (this.currentNode.getChildrenCount() > 0) {
            NodeChildrenIterator itr;
            this.currentIterator = itr = this.currentNode.getChildrenLast();
            this.currentChild = itr.getNode();
        } else {
            this.currentIterator = null;
            this.currentChild = null;
        }
        ++this.top;
        return this.currentNode;
    }

    @Override
    @NotNull
    public ByteIterable getKey() {
        if (this.top == 0) {
            return this.currentNode.hasValue() ? this.currentNode.keySequence : ByteIterable.EMPTY;
        }
        LightOutputStream output = new LightOutputStream(7);
        for (int i2 = 0; i2 < this.top; ++i2) {
            ByteIterableBase.fillBytes((ByteIterable)this.stack[i2].getKey(), (LightOutputStream)output);
            output.write((int)this.stack[i2].getNode().firstByte);
        }
        ByteIterableBase.fillBytes((ByteIterable)this.currentNode.keySequence, (LightOutputStream)output);
        return output.asArrayByteIterable();
    }

    @Override
    @NotNull
    public ByteIterable getValue() {
        ByteIterable result = this.currentValue;
        if (result == null) {
            return ByteIterable.EMPTY;
        }
        return result;
    }

    @Override
    public boolean hasValue() {
        return this.currentValue != null;
    }

    @Override
    public void moveUp() {
        --this.top;
        NodeChildrenIterator topItr = this.stack[this.top];
        this.setCurrentNode(topItr.getParentNode());
        this.currentIterator = topItr;
        this.currentChild = topItr.getNode();
        this.stack[this.top] = null;
    }

    @Override
    public int compareCurrent(@NotNull ByteIterable key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canMoveRight() {
        return this.currentIterator != null && this.currentIterator.hasNext();
    }

    boolean isValidPos() {
        return this.currentIterator != null;
    }

    @Override
    @NotNull
    public INode moveRight() {
        if (this.currentIterator.hasNext()) {
            if (this.currentIterator.isMutable()) {
                this.currentChild = (ChildReference)this.currentIterator.next();
            } else {
                this.currentIterator.nextInPlace();
            }
        } else {
            this.currentIterator = null;
            this.currentChild = null;
        }
        return this.currentNode;
    }

    @Override
    public boolean canMoveLeft() {
        if (this.currentIterator == null) {
            return this.currentNode.getChildrenCount() > 0;
        }
        return this.currentIterator.hasPrev();
    }

    @Override
    @NotNull
    public INode moveLeft() {
        if (this.currentIterator.hasPrev()) {
            if (this.currentIterator.isMutable() || this.currentChild == null) {
                this.currentChild = this.currentIterator.prev();
            } else {
                this.currentIterator.prevInPlace();
            }
            return this.currentNode;
        }
        throw new IllegalStateException();
    }

    @Override
    public long getCurrentAddress() {
        return this.currentNode.getAddress();
    }

    @Override
    public boolean canMoveUp() {
        return this.top != 0;
    }

    @Override
    public boolean canMoveDown() {
        return this.currentChild != null;
    }

    @Override
    public void reset(@NotNull MutableTreeRoot root) {
        this.top = 0;
        this.setCurrentNode((NodeBase)((Object)root));
        this.getItr();
    }

    protected void setCurrentNode(@NotNull NodeBase node) {
        this.currentNode = node;
        this.currentValue = node.getValue();
    }

    @Override
    public boolean moveTo(@NotNull ByteIterable key, @Nullable ByteIterable value) {
        ByteIterator it = key.iterator();
        NodeBase node = this.top == 0 ? this.currentNode : this.stack[0].getParentNode();
        int depth = 0;
        NodeChildrenIterator[] tmp = new NodeChildrenIterator[8];
        while (true) {
            if (NodeBase.MatchResult.getMatchingLength(node.matchesKeySequence(it)) < 0) {
                return false;
            }
            if (!it.hasNext()) break;
            NodeChildrenIterator itr = node.getChildren(it.next());
            ChildReference ref = itr.getNode();
            if (ref == null) {
                return false;
            }
            tmp = PatriciaTraverser.pushIterator(tmp, itr, depth++);
            node = ref.getNode(this.tree);
        }
        if (node.hasValue() && (value == null || value.compareTo((Object)node.getValue()) == 0)) {
            this.setCurrentNode(node);
            this.getItr();
            this.stack = tmp;
            this.top = depth;
            return true;
        }
        return false;
    }

    @Override
    public boolean moveToRange(@NotNull ByteIterable key, @Nullable ByteIterable value) {
        boolean dive;
        ByteIterator it = key.iterator();
        NodeBase node = this.top == 0 ? this.currentNode : this.stack[0].getParentNode();
        int depth = 0;
        NodeChildrenIterator[] tmp = new NodeChildrenIterator[8];
        boolean smaller = false;
        while (true) {
            boolean hasNext = it.hasNext();
            long matchResult = node.matchesKeySequence(it);
            if (NodeBase.MatchResult.getMatchingLength(matchResult) < 0) {
                if (value == null) {
                    smaller = NodeBase.MatchResult.hasNext(matchResult) && (!hasNext || NodeBase.MatchResult.getKeyByte(matchResult) < NodeBase.MatchResult.getNextByte(matchResult));
                    dive = !smaller;
                    break;
                }
                return false;
            }
            if (!it.hasNext()) {
                if (!node.hasValue()) {
                    dive = true;
                    break;
                }
                if (value == null || value.compareTo((Object)node.getValue()) <= 0) {
                    this.setCurrentNode(node);
                    this.getItr();
                    this.stack = tmp;
                    this.top = depth;
                    return true;
                }
                return false;
            }
            byte nextByte = it.next();
            NodeChildrenIterator itr = node.getChildren(nextByte);
            ChildReference ref = itr.getNode();
            if (ref == null) {
                itr = node.getChildrenRange(nextByte);
                ref = itr.getNode();
                if (ref != null) {
                    tmp = PatriciaTraverser.pushIterator(tmp, itr, depth++);
                    node = ref.getNode(this.tree);
                    dive = true;
                    break;
                }
                smaller = true;
                dive = false;
                break;
            }
            tmp = PatriciaTraverser.pushIterator(tmp, itr, depth++);
            node = ref.getNode(this.tree);
        }
        if (smaller || !node.hasValue()) {
            NodeChildrenIterator itr;
            if (dive && node.getChildrenCount() > 0) {
                itr = node.getChildren().iterator();
                tmp = PatriciaTraverser.pushIterator(tmp, itr, depth);
                node = ((ChildReference)itr.next()).getNode(this.tree);
            } else {
                do {
                    if (depth <= 0) {
                        return false;
                    }
                    itr = tmp[--depth];
                } while (!itr.hasNext());
                node = ((ChildReference)itr.next()).getNode(this.tree);
            }
            ++depth;
            while (!node.hasValue()) {
                itr = node.getChildren().iterator();
                if (!itr.hasNext()) {
                    throw new IllegalStateException("Can't dive into tree branch");
                }
                ChildReference ref = (ChildReference)itr.next();
                tmp = PatriciaTraverser.pushIterator(tmp, itr, depth++);
                node = ref.getNode(this.tree);
            }
        }
        this.setCurrentNode(node);
        this.getItr();
        this.stack = tmp;
        this.top = depth;
        return true;
    }

    @Override
    @NotNull
    public PatriciaTreeBase getTree() {
        return this.tree;
    }

    protected void getItr() {
        if (this.currentNode.getChildrenCount() > 0) {
            NodeChildrenIterator itr;
            this.currentIterator = itr = this.currentNode.getChildren().iterator();
            this.currentChild = (ChildReference)itr.next();
        } else {
            this.currentIterator = null;
            this.currentChild = null;
        }
    }

    private static NodeChildrenIterator[] pushIterator(NodeChildrenIterator[] tmp, NodeChildrenIterator itr, int depth) {
        int length = tmp.length;
        if (depth >= length) {
            int newCapacity = length << 1;
            NodeChildrenIterator[] newStack = new NodeChildrenIterator[newCapacity];
            System.arraycopy(tmp, 0, newStack, 0, length);
            tmp = newStack;
        }
        tmp[depth] = itr;
        return tmp;
    }
}

