/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.env;

import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.log.ReadBytesListener;
import jetbrains.exodus.management.Statistics;
import jetbrains.exodus.management.StatisticsItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnvironmentStatistics
extends Statistics<Type> {
    private static final int DISK_USAGE_FREQ = 10000;
    @NotNull
    private final EnvironmentImpl env;

    EnvironmentStatistics(@NotNull EnvironmentImpl env) {
        super((Enum[])Type.values());
        this.env = env;
        this.createAllStatisticsItems();
        this.getStatisticsItem(Type.BYTES_WRITTEN).setTotal(env.getLog().getHighAddress());
        env.getLog().addReadBytesListener(new ReadBytesListener(){

            @Override
            public void bytesRead(byte[] bytes, int count) {
                EnvironmentStatistics.this.getStatisticsItem(Type.BYTES_READ).addTotal((long)count);
            }
        });
    }

    protected StatisticsItem createStatisticsItem(@NotNull Type key) {
        if (!this.env.getEnvironmentConfig().getEnvGatherStatistics()) {
            return new StatisticsItem((Statistics)this);
        }
        return super.createStatisticsItem((Enum)key);
    }

    @NotNull
    public StatisticsItem getStatisticsItem(@NotNull String statisticsName) {
        if (!this.env.getEnvironmentConfig().getEnvGatherStatistics()) {
            return new StatisticsItem((Statistics)this);
        }
        return super.getStatisticsItem(statisticsName);
    }

    @NotNull
    protected StatisticsItem createNewBuiltInItem(@NotNull Type key) {
        switch (key) {
            case ACTIVE_TRANSACTIONS: {
                return new ActiveTransactionsStatisticsItem(this);
            }
            case DISK_USAGE: {
                return new DiskUsageStatisticsItem(this);
            }
            case UTILIZATION_PERCENT: {
                return new UtilizationPercentStatisticsItem(this);
            }
        }
        return super.createNewBuiltInItem((Enum)key);
    }

    private static class UtilizationPercentStatisticsItem
    extends StatisticsItem {
        UtilizationPercentStatisticsItem(@NotNull EnvironmentStatistics statistics) {
            super((Statistics)statistics);
        }

        @Nullable
        protected Long getAutoUpdatedTotal() {
            EnvironmentStatistics statistics = (EnvironmentStatistics)this.getStatistics();
            return statistics == null ? null : Long.valueOf(statistics.env.getGC().getUtilizationProfile().totalUtilizationPercent());
        }
    }

    private static class DiskUsageStatisticsItem
    extends StatisticsItem {
        private long lastAutoUpdateTime = 0L;

        DiskUsageStatisticsItem(@NotNull EnvironmentStatistics statistics) {
            super((Statistics)statistics);
        }

        @Nullable
        protected Long getAutoUpdatedTotal() {
            long currentTime;
            EnvironmentStatistics statistics = (EnvironmentStatistics)this.getStatistics();
            if (statistics != null && (currentTime = System.currentTimeMillis()) - this.lastAutoUpdateTime > 10000L) {
                this.lastAutoUpdateTime = currentTime;
                return statistics.env.getDiskUsage();
            }
            return null;
        }
    }

    private static class ActiveTransactionsStatisticsItem
    extends StatisticsItem {
        ActiveTransactionsStatisticsItem(@NotNull EnvironmentStatistics statistics) {
            super((Statistics)statistics);
        }

        @Nullable
        protected Long getAutoUpdatedTotal() {
            EnvironmentStatistics statistics = (EnvironmentStatistics)this.getStatistics();
            return statistics == null ? null : Long.valueOf(statistics.env.activeTransactions());
        }
    }

    public static enum Type {
        BYTES_WRITTEN("Bytes written"),
        BYTES_READ("Bytes read"),
        BYTES_MOVED_BY_GC("Bytes moved by GC"),
        TRANSACTIONS("Transactions"),
        READONLY_TRANSACTIONS("Read-only transactions"),
        ACTIVE_TRANSACTIONS("Active transactions"),
        FLUSHED_TRANSACTIONS("Flushed transactions"),
        DISK_USAGE("Disk usage"),
        UTILIZATION_PERCENT("Utilization percent");

        public final String id;

        private Type(String id) {
            this.id = id;
        }
    }
}

