/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.gc;

import java.util.Date;
import java.util.Iterator;
import jetbrains.exodus.core.execution.JobProcessorAdapter;
import jetbrains.exodus.env.EnvironmentConfig;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.gc.BackgroundCleaner;
import jetbrains.exodus.gc.GarbageCollector;
import jetbrains.exodus.gc.GcJob;
import jetbrains.exodus.gc.UtilizationProfile;
import jetbrains.exodus.log.Log;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010\u000f\u001a\u00020\fH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\nH\u0002\u00a8\u0006\u0014"}, d2={"Ljetbrains/exodus/gc/BackgroundCleaningJob;", "Ljetbrains/exodus/gc/GcJob;", "gc", "Ljetbrains/exodus/gc/GarbageCollector;", "(Ljetbrains/exodus/gc/GarbageCollector;)V", "canContinue", "", "cleanFiles", "fragmentedFiles", "", "", "doCleanLog", "", "log", "Ljetbrains/exodus/log/Log;", "doJob", "getName", "", "wakeAt", "time", "xodus-environment"})
public final class BackgroundCleaningJob
extends GcJob {
    @NotNull
    public String getName() {
        return "Background cleaner";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doJob() {
        EnvironmentConfig ec;
        long currentTime;
        GarbageCollector garbageCollector = this.getGc();
        if (garbageCollector == null) {
            return;
        }
        GarbageCollector gc = garbageCollector;
        BackgroundCleaner cleaner = gc.getCleaner$xodus_environment();
        if (!cleaner.isCurrentThread()) {
            JobProcessorAdapter processor = cleaner.getJobProcessor();
            GarbageCollector.Companion.loggingInfo$xodus_environment((Function0<String>)((Function0)new Function0<String>(gc, cleaner){
                final /* synthetic */ GarbageCollector $gc;
                final /* synthetic */ BackgroundCleaner $cleaner;

                @NotNull
                public final String invoke() {
                    return "Re-queueing BackgroundCleaningJob[" + this.$gc.getEnvironment$xodus_environment().getLocation() + "] to thread[" + this.$cleaner.getThreadId$xodus_environment() + ']';
                }
                {
                    this.$gc = garbageCollector;
                    this.$cleaner = backgroundCleaner;
                    super(0);
                }
            }));
            this.reQueue(processor);
            return;
        }
        if (!this.canContinue()) {
            return;
        }
        long minTimeToInvokeCleaner = gc.getStartTime$xodus_environment();
        if (minTimeToInvokeCleaner > (currentTime = System.currentTimeMillis())) {
            GarbageCollector garbageCollector2 = gc;
            Intrinsics.checkExpressionValueIsNotNull((Object)garbageCollector2, (String)"gc");
            this.wakeAt(garbageCollector2, minTimeToInvokeCleaner);
            return;
        }
        EnvironmentImpl env = gc.getEnvironment$xodus_environment();
        EnvironmentConfig environmentConfig = ec = env.getEnvironmentConfig();
        Intrinsics.checkExpressionValueIsNotNull((Object)environmentConfig, (String)"ec");
        int gcRunPeriod = environmentConfig.getGcRunPeriod();
        if (gcRunPeriod > 0 && gc.getLastInvocationTime() + (long)gcRunPeriod > currentTime) {
            GarbageCollector garbageCollector3 = gc;
            Intrinsics.checkExpressionValueIsNotNull((Object)garbageCollector3, (String)"gc");
            this.wakeAt(garbageCollector3, gc.getLastInvocationTime() + (long)gcRunPeriod);
            return;
        }
        Log log = env.getLog();
        if ((long)gc.getMinFileAge$xodus_environment() < log.getNumberOfFiles()) {
            cleaner.setCleaning(true);
            try {
                Log log2 = log;
                Intrinsics.checkExpressionValueIsNotNull((Object)log2, (String)"log");
                GarbageCollector garbageCollector4 = gc;
                Intrinsics.checkExpressionValueIsNotNull((Object)garbageCollector4, (String)"gc");
                this.doCleanLog(log2, garbageCollector4);
                if (gc.isTooMuchFreeSpace$xodus_environment() && gcRunPeriod > 0) {
                    this.wakeAt(gc, System.currentTimeMillis() + (long)gcRunPeriod);
                }
            }
            finally {
                gc.setLastInvocationTime(System.currentTimeMillis());
                cleaner.setCleaning(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doCleanLog(Log log, GarbageCollector gc) {
        UtilizationProfile up = gc.getUtilizationProfile();
        GarbageCollector.Companion.loggingInfo$xodus_environment((Function0<String>)((Function0)new Function0<String>(log, up){
            final /* synthetic */ Log $log;
            final /* synthetic */ UtilizationProfile $up;

            @NotNull
            public final String invoke() {
                return "Starting background cleaner loop for " + this.$log.getLocation() + ", free space: " + this.$up.totalFreeSpacePercent$xodus_environment() + '%';
            }
            {
                this.$log = log;
                this.$up = utilizationProfile;
                super(0);
            }
        }));
        EnvironmentImpl env = gc.getEnvironment$xodus_environment();
        long highFile = log.getHighFileAddress();
        long loopStart = System.currentTimeMillis();
        EnvironmentConfig environmentConfig = env.getEnvironmentConfig();
        Intrinsics.checkExpressionValueIsNotNull((Object)environmentConfig, (String)"env.environmentConfig");
        int gcRunPeriod = environmentConfig.getGcRunPeriod();
        try {
            Iterator<Long> fragmentedFiles2;
            while ((fragmentedFiles2 = up.getFilesSortedByUtilization$xodus_environment(highFile)).hasNext()) {
                if (!this.cleanFiles(gc, fragmentedFiles2)) {
                    Thread.yield();
                }
                if (this.canContinue() && loopStart + (long)gcRunPeriod > System.currentTimeMillis()) continue;
            }
            up.estimateTotalBytes$xodus_environment();
            up.setDirty(true);
            GarbageCollector.Companion.loggingInfo$xodus_environment((Function0<String>)((Function0)new Function0<String>(log, up){
                final /* synthetic */ Log $log;
                final /* synthetic */ UtilizationProfile $up;

                @NotNull
                public final String invoke() {
                    return "Finished background cleaner loop for " + this.$log.getLocation() + ", free space: " + this.$up.totalFreeSpacePercent$xodus_environment() + '%';
                }
                {
                    this.$log = log;
                    this.$up = utilizationProfile;
                    super(0);
                }
            }));
        }
        catch (Throwable throwable) {
            up.estimateTotalBytes$xodus_environment();
            up.setDirty(true);
            GarbageCollector.Companion.loggingInfo$xodus_environment((Function0<String>)((Function0)new /* invalid duplicate definition of identical inner class */));
            throw throwable;
        }
    }

    private final synchronized boolean cleanFiles(GarbageCollector gc, Iterator<Long> fragmentedFiles2) {
        return gc.cleanFiles$xodus_environment(fragmentedFiles2);
    }

    private final boolean canContinue() {
        EnvironmentConfig ec;
        GarbageCollector garbageCollector = this.getGc();
        if (garbageCollector == null) {
            return false;
        }
        GarbageCollector gc = garbageCollector;
        BackgroundCleaner cleaner = gc.getCleaner$xodus_environment();
        if (cleaner.isSuspended() || cleaner.isFinished()) {
            return false;
        }
        EnvironmentConfig environmentConfig = ec = gc.getEnvironment$xodus_environment().getEnvironmentConfig();
        Intrinsics.checkExpressionValueIsNotNull((Object)environmentConfig, (String)"ec");
        return environmentConfig.isGcEnabled() && !ec.getEnvIsReadonly() && gc.isTooMuchFreeSpace$xodus_environment();
    }

    private final void wakeAt(GarbageCollector gc, long time) {
        GarbageCollector.Companion.loggingInfo$xodus_environment((Function0<String>)((Function0)new Function0<String>(gc, time){
            final /* synthetic */ GarbageCollector $gc;
            final /* synthetic */ long $time;

            @NotNull
            public final String invoke() {
                return "Queueing BackgroundCleaningJob[" + this.$gc.getEnvironment$xodus_environment().getLocation() + "] to wake up at [" + new Date(this.$time) + ']';
            }
            {
                this.$gc = garbageCollector;
                this.$time = l;
                super(0);
            }
        }));
        gc.wakeAt$xodus_environment(time);
    }

    public BackgroundCleaningJob(@NotNull GarbageCollector gc) {
        Intrinsics.checkParameterIsNotNull((Object)gc, (String)"gc");
        super(gc, null, 2, null);
    }
}

