/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.btree;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.CompoundByteIteratorBase;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.log.ByteIterableWithAddress;
import jetbrains.exodus.log.ByteIteratorWithAddress;
import jetbrains.exodus.log.CompressedUnsignedLongByteIterable;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.tree.btree.BTreeBase;
import jetbrains.exodus.tree.btree.BTreeReclaimTraverser;
import jetbrains.exodus.tree.btree.BaseLeafNode;
import jetbrains.exodus.tree.btree.BasePage;
import jetbrains.exodus.tree.btree.BasePageMutable;
import jetbrains.exodus.tree.btree.ILeafNode;
import org.jetbrains.annotations.NotNull;

abstract class BasePageImmutable
extends BasePage {
    @NotNull
    protected final ByteIterableWithAddress data;
    long dataAddress;
    byte keyAddressLen;
    private ILeafNode minKey = null;
    private ILeafNode maxKey = null;

    BasePageImmutable(@NotNull BTreeBase tree) {
        super(tree);
        this.data = ByteIterableWithAddress.EMPTY;
        this.size = 0;
        this.dataAddress = -1L;
    }

    BasePageImmutable(@NotNull BTreeBase tree, @NotNull ByteIterableWithAddress data) {
        super(tree);
        this.data = data;
        ByteIteratorWithAddress it = data.iterator();
        this.size = CompressedUnsignedLongByteIterable.getInt(it) >> 1;
        this.init(it);
    }

    BasePageImmutable(@NotNull BTreeBase tree, @NotNull ByteIterableWithAddress data, int size) {
        super(tree);
        this.data = data;
        this.size = size;
        this.init(data.iterator());
    }

    private void init(@NotNull ByteIteratorWithAddress itr) {
        if (this.size > 0) {
            byte next = itr.next();
            this.dataAddress = itr.getAddress();
            this.loadAddressLengths(next, itr);
        } else {
            this.dataAddress = itr.getAddress();
        }
    }

    @Override
    @NotNull
    ILeafNode getMinKey() {
        if (this.minKey != null) {
            return this.minKey;
        }
        this.minKey = super.getMinKey();
        return this.minKey;
    }

    @Override
    @NotNull
    ILeafNode getMaxKey() {
        if (this.maxKey != null) {
            return this.maxKey;
        }
        this.maxKey = super.getMaxKey();
        return this.maxKey;
    }

    @Override
    protected long getDataAddress() {
        return this.dataAddress;
    }

    ByteIterator getDataIterator() {
        return this.dataAddress == -1L ? ByteIterable.EMPTY_ITERATOR : this.data.iterator((int)(this.dataAddress - this.data.getDataAddress()));
    }

    protected void loadAddressLengths(int length, ByteIterator it) {
        this.keyAddressLen = (byte)length;
        BasePageImmutable.checkAddressLength(this.keyAddressLen);
    }

    static void checkAddressLength(byte addressLen) {
        if (addressLen < 0 || addressLen > 8) {
            throw new ExodusException("Invalid length of address: " + addressLen);
        }
    }

    @Override
    protected long getKeyAddress(int index) {
        return this.dataAddress == -1L ? -1L : this.data.nextLong((int)(this.dataAddress - this.data.getDataAddress() + (long)(index * this.keyAddressLen)), this.keyAddressLen);
    }

    @Override
    @NotNull
    public BaseLeafNode getKey(int index) {
        return this.getTree().loadLeaf(this.getKeyAddress(index));
    }

    @Override
    protected boolean isDupKey(int index) {
        return this.getTree().isDupKey(this.getKeyAddress(index));
    }

    @Override
    protected boolean isMutable() {
        return false;
    }

    @Override
    protected int binarySearch(ByteIterable key) {
        return this.binarySearch(key, 0);
    }

    @Override
    protected int binarySearch(ByteIterable key, int low, long expectedAddress) {
        return this.binarySearch(key, low);
    }

    @Override
    protected int binarySearch(ByteIterable key, int low) {
        if (this.dataAddress == -1L) {
            return -1;
        }
        Log log = this.tree.log;
        int cachePageSize = log.getCachePageSize();
        byte bytesPerAddress = this.keyAddressLen;
        int high = this.size - 1;
        long leftAddress = -1L;
        byte[] leftPage = null;
        long rightAddress = -1L;
        byte[] rightPage = null;
        BinarySearchIterator it = new BinarySearchIterator();
        while (low <= high) {
            long leafAddress;
            int mid = low + high >>> 1;
            long midAddress = this.dataAddress + (long)(mid * bytesPerAddress);
            int offset = (int)midAddress & cachePageSize - 1;
            it.offset = offset;
            long pageAddress = midAddress - (long)offset;
            if (pageAddress == leftAddress) {
                BinarySearchIterator.access$202(it, leftPage);
            } else if (pageAddress == rightAddress) {
                BinarySearchIterator.access$202(it, rightPage);
            } else {
                leftPage = log.getCachedPage(pageAddress);
                BinarySearchIterator.access$202(it, leftPage);
                leftAddress = pageAddress;
            }
            if (cachePageSize - offset < bytesPerAddress) {
                long nextPageAddress = pageAddress + (long)cachePageSize;
                if (rightAddress == nextPageAddress) {
                    BinarySearchIterator.access$302(it, rightPage);
                } else {
                    rightPage = log.getCachedPage(nextPageAddress);
                    BinarySearchIterator.access$302(it, rightPage);
                    rightAddress = nextPageAddress;
                }
                leafAddress = it.asCompound().nextLong((int)bytesPerAddress);
            } else {
                leafAddress = it.nextLong(bytesPerAddress);
            }
            int cmp = this.tree.compareLeafToKey(leafAddress, key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    static void doReclaim(BTreeReclaimTraverser context) {
        BasePageMutable node = context.currentNode.getMutableCopy(context.mainTree);
        context.wasReclaim = true;
        context.setPage(node);
        context.popAndMutate();
    }

    private static class BinarySearchIterator
    extends ByteIterator {
        private byte[] page;
        private byte[] nextPage;
        private int offset;

        private BinarySearchIterator() {
        }

        private CompoundByteIteratorBase asCompound() {
            return new CompoundByteIteratorBase(this){

                protected ByteIterator nextIterator() {
                    BinarySearchIterator.access$202(BinarySearchIterator.this, BinarySearchIterator.this.nextPage);
                    BinarySearchIterator.this.offset = 0;
                    return BinarySearchIterator.this;
                }
            };
        }

        public boolean hasNext() {
            return this.offset < this.page.length;
        }

        public byte next() {
            return this.page[this.offset++];
        }

        public long skip(long bytes) {
            throw new UnsupportedOperationException();
        }

        public long nextLong(int length) {
            return LongBinding.entryToUnsignedLong((byte[])this.page, (int)this.offset, (int)length);
        }

        static /* synthetic */ byte[] access$202(BinarySearchIterator x0, byte[] x1) {
            x0.page = x1;
            return x1;
        }

        static /* synthetic */ byte[] access$302(BinarySearchIterator x0, byte[] x1) {
            x0.nextPage = x1;
            return x1;
        }
    }
}

