/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.patricia;

import java.io.PrintStream;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.log.ByteIterableWithAddress;
import jetbrains.exodus.log.ByteIteratorWithAddress;
import jetbrains.exodus.log.CompressedUnsignedLongByteIterable;
import jetbrains.exodus.tree.Dumpable;
import jetbrains.exodus.tree.INode;
import jetbrains.exodus.tree.patricia.ChildReference;
import jetbrains.exodus.tree.patricia.MutableNode;
import jetbrains.exodus.tree.patricia.NodeChildren;
import jetbrains.exodus.tree.patricia.NodeChildrenIterator;
import jetbrains.exodus.tree.patricia.PatriciaTreeBase;
import jetbrains.exodus.tree.patricia.PatriciaTreeMutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class NodeBase
implements INode {
    private static final int LAZY_KEY_VALUE_ITERABLE_MIN_LENGTH = 16;
    @NotNull
    protected ByteIterable keySequence;
    @Nullable
    protected ByteIterable value;

    NodeBase(@NotNull ByteIterable keySequence, @Nullable ByteIterable value) {
        this.keySequence = keySequence;
        this.value = value;
    }

    NodeBase(byte type, @NotNull ByteIterableWithAddress data, @NotNull ByteIteratorWithAddress it) {
        this.keySequence = NodeBase.extractKey(type, data, it);
        this.value = NodeBase.extractValue(type, data, it);
    }

    long matchesKeySequence(@NotNull ByteIterator it) {
        int matchingLength = 0;
        for (byte keyByte : this.keySequence) {
            if (!it.hasNext()) {
                return MatchResult.getMatchResult(-matchingLength - 1, keyByte, false, (byte)0);
            }
            byte nextByte = it.next();
            if (nextByte != keyByte) {
                return MatchResult.getMatchResult(-matchingLength - 1, keyByte, true, nextByte);
            }
            ++matchingLength;
        }
        return MatchResult.getMatchResult(matchingLength);
    }

    boolean hasKey() {
        return this.keySequence != ByteIterable.EMPTY && this.keySequence.getLength() > 0;
    }

    @Override
    @NotNull
    public ByteIterable getKey() {
        return this.keySequence;
    }

    @Override
    public boolean hasValue() {
        return this.value != null;
    }

    @Override
    @Nullable
    public ByteIterable getValue() {
        return this.value;
    }

    @Override
    public void dump(PrintStream out, int level, @Nullable Dumpable.ToString renderer) {
        throw new UnsupportedOperationException();
    }

    abstract long getAddress();

    abstract boolean isMutable();

    abstract MutableNode getMutableCopy(@NotNull PatriciaTreeMutable var1);

    abstract NodeBase getChild(@NotNull PatriciaTreeBase var1, byte var2);

    @NotNull
    abstract NodeChildrenIterator getChildren(byte var1);

    @NotNull
    abstract NodeChildrenIterator getChildrenRange(byte var1);

    @NotNull
    abstract NodeChildrenIterator getChildrenLast();

    @NotNull
    abstract NodeChildren getChildren();

    abstract int getChildrenCount();

    public String toString() {
        return String.format("%s} %s %s", this.keySequence.iterator().hasNext() ? "{key:" + this.keySequence.toString() : Character.valueOf('{'), this.value == null ? "@" : this.value.toString() + " @", this.getAddress());
    }

    static void indent(PrintStream out, int level) {
        for (int i2 = 0; i2 < level; ++i2) {
            out.print(' ');
        }
    }

    @NotNull
    private static ByteIterable extractKey(byte type, @NotNull ByteIterableWithAddress data, @NotNull ByteIteratorWithAddress it) {
        if (!PatriciaTreeBase.nodeHasKey(type)) {
            return ByteIterable.EMPTY;
        }
        return NodeBase.extractLazyIterable(data, it);
    }

    @Nullable
    private static ByteIterable extractValue(byte type, @NotNull ByteIterableWithAddress data, @NotNull ByteIteratorWithAddress it) {
        if (!PatriciaTreeBase.nodeHasValue(type)) {
            return null;
        }
        return NodeBase.extractLazyIterable(data, it);
    }

    private static ByteIterable extractLazyIterable(@NotNull ByteIterableWithAddress data, @NotNull ByteIteratorWithAddress it) {
        int length = CompressedUnsignedLongByteIterable.getInt(it);
        if (length == 1) {
            return ArrayByteIterable.fromByte((byte)it.next());
        }
        if (length < 16) {
            return new ArrayByteIterable((ByteIterator)it, length);
        }
        ByteIterable result = data.subIterable((int)(it.getAddress() - data.getDataAddress()), length);
        it.skip(length);
        return result;
    }

    final class EmptyNodeChildrenIterator
    implements NodeChildrenIterator {
        EmptyNodeChildrenIterator() {
        }

        @Override
        public boolean isMutable() {
            return false;
        }

        @Override
        public void nextInPlace() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void prevInPlace() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChildReference getNode() {
            return null;
        }

        @Override
        public NodeBase getParentNode() {
            return NodeBase.this;
        }

        @Override
        public int getIndex() {
            return 0;
        }

        @Override
        public ByteIterable getKey() {
            return ByteIterable.EMPTY;
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public ChildReference next() {
            return null;
        }

        @Override
        public boolean hasPrev() {
            return false;
        }

        @Override
        public ChildReference prev() {
            return null;
        }

        @Override
        public void remove() {
        }
    }

    static class MatchResult {
        MatchResult() {
        }

        static long getMatchResult(int matchingLength) {
            return MatchResult.getMatchResult(matchingLength, (byte)0, false, (byte)0);
        }

        static long getMatchResult(int matchingLength, byte keyByte, boolean hasNext, byte nextByte) {
            long result = ((long)Math.abs(matchingLength) << 18) + (long)((keyByte & 0xFF) << 10) + (long)((nextByte & 0xFF) << 2);
            if (matchingLength < 0) {
                result += 2L;
            }
            if (hasNext) {
                ++result;
            }
            return result;
        }

        static int getMatchingLength(long matchResult) {
            int result = (int)(matchResult >> 18);
            return (matchResult & 2L) == 0L ? result : -result;
        }

        static int getKeyByte(long matchResult) {
            return (int)(matchResult >> 10) & 0xFF;
        }

        static int getNextByte(long matchResult) {
            return (int)(matchResult >> 2) & 0xFF;
        }

        static boolean hasNext(long matchResult) {
            return (matchResult & 1L) != 0L;
        }
    }
}

