/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus;

import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.FixedLengthByteIterable;
import jetbrains.exodus.util.ByteIterableUtil;
import jetbrains.exodus.util.LightOutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ByteIterableBase
implements ByteIterable {
    protected static final byte[][] SINGLE_BYTES = new byte[256][];
    protected byte[] bytes = null;
    protected int length = -1;

    @Override
    public int compareTo(ByteIterable right) {
        return ByteIterableUtil.compare(this, right);
    }

    @Override
    public ByteIterator iterator() {
        if (this.bytes == null) {
            return this.getIterator();
        }
        final byte[] bytes = this.bytes;
        final int len = this.length;
        return new ByteIterator(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < len;
            }

            @Override
            public byte next() {
                byte result = bytes[this.i];
                ++this.i;
                return result;
            }

            @Override
            public long skip(long bytes2) {
                int result = Math.min(len - this.i, (int)bytes2);
                this.i += result;
                return result;
            }
        };
    }

    @Override
    public byte[] getBytesUnsafe() {
        if (this.bytes == null) {
            this.fillBytes();
        }
        return this.bytes;
    }

    @Override
    public int getLength() {
        if (this.length == -1) {
            this.fillBytes();
        }
        return this.length;
    }

    @Override
    @NotNull
    public ByteIterable subIterable(int offset, int length) {
        return length == 0 ? EMPTY : new FixedLengthByteIterable(this, offset, length);
    }

    protected abstract ByteIterator getIterator();

    protected void fillBytes() {
        this.fillBytes(this.getIterator());
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof ByteIterable && this.compareTo((ByteIterable)obj) == 0;
    }

    public int hashCode() {
        byte[] a = this.getBytesUnsafe();
        if (a == null) {
            return 0;
        }
        int result = 1;
        int length = this.getLength();
        for (int i = 0; i < length; ++i) {
            result = 31 * result + a[i];
        }
        return result;
    }

    public String toString() {
        return ByteIterableBase.toString(this.getBytesUnsafe(), 0, this.getLength());
    }

    public static String toString(@Nullable byte[] bytes, int start, int end) {
        if (bytes == null) {
            return "null";
        }
        if (end <= start) {
            return "[]";
        }
        StringBuilder b2 = new StringBuilder();
        b2.append('[');
        int i = start;
        while (true) {
            b2.append(bytes[i++]);
            if (i == end) {
                return b2.append(']').toString();
            }
            b2.append(", ");
        }
    }

    public static void fillBytes(@NotNull ByteIterable bi, @NotNull LightOutputStream output) {
        if (bi instanceof ArrayByteIterable) {
            ArrayByteIterable abi = (ArrayByteIterable)bi;
            int length = abi.getLength();
            if (length > 0) {
                output.write(abi.bytes, 0, length);
            }
        } else {
            ByteIterator it = bi.iterator();
            if (it.hasNext()) {
                ByteIterableBase.fillBytes(it, output);
            }
        }
    }

    @NotNull
    public static byte[] readIterator(@NotNull ByteIterator it, int size) {
        if (size == 0) {
            return EMPTY_BYTES;
        }
        if (size == 1) {
            return SINGLE_BYTES[it.next() & 0xFF];
        }
        byte[] result = new byte[size];
        for (int i = 0; i < size; ++i) {
            result[i] = it.next();
        }
        return result;
    }

    private static void fillBytes(@NotNull ByteIterator it, @NotNull LightOutputStream output) {
        do {
            output.write(it.next());
        } while (it.hasNext());
    }

    protected void fillBytes(@NotNull ByteIterator it) {
        if (!it.hasNext()) {
            this.bytes = EMPTY_BYTES;
            this.length = 0;
        } else {
            this.fillBytes(it.next(), it);
        }
    }

    protected void fillBytes(byte firstByte, @NotNull ByteIterator it) {
        if (!it.hasNext()) {
            this.bytes = SINGLE_BYTES[firstByte & 0xFF];
            this.length = 1;
        } else {
            LightOutputStream output = new LightOutputStream(4);
            output.write(firstByte);
            ByteIterableBase.fillBytes(it, output);
            this.bytes = output.getBufferBytes();
            this.length = output.size();
        }
    }

    static {
        for (int i = 0; i < SINGLE_BYTES.length; ++i) {
            ByteIterableBase.SINGLE_BYTES[i] = new byte[]{(byte)i};
        }
    }
}

