/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.ListIterator;
import jetbrains.exodus.backup.Backupable;
import jetbrains.exodus.core.dataStructures.hash.LongHashMap;
import jetbrains.exodus.core.dataStructures.hash.LongSet;
import jetbrains.exodus.entitystore.BlobHandleGenerator;
import jetbrains.exodus.entitystore.BlobStringsCache;
import jetbrains.exodus.entitystore.BlobVaultItem;
import jetbrains.exodus.entitystore.PersistentEntityStoreConfig;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.util.ByteArraySizedInputStream;
import jetbrains.exodus.util.ByteArraySpinAllocator;
import jetbrains.exodus.util.IOUtil;
import jetbrains.exodus.util.IdGenerator;
import jetbrains.exodus.util.LightByteArrayOutputStream;
import jetbrains.exodus.util.UTFUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BlobVault
implements BlobHandleGenerator,
Backupable {
    protected static final Logger logger = LoggerFactory.getLogger((String)"BlobVault");
    private static final int READ_BUFFER_SIZE = 16384;
    static final ByteArraySpinAllocator bufferAllocator = new ByteArraySpinAllocator(16384);
    private static final BlobStringsCache.BlobStringsCacheCreator stringContentCacheCreator = new BlobStringsCache.BlobStringsCacheCreator();
    private static final IdGenerator identityGenerator = new IdGenerator();
    private final PersistentEntityStoreConfig config;
    private final BlobStringsCache stringContentCache;
    private final int vaultIdentity;

    protected BlobVault(@NotNull BlobVault source) {
        this.config = source.config;
        this.stringContentCache = source.stringContentCache;
        this.vaultIdentity = source.vaultIdentity;
    }

    protected BlobVault(@NotNull PersistentEntityStoreConfig config) {
        this.config = config;
        this.stringContentCache = config.isBlobStringsCacheShared() ? stringContentCacheCreator.getInstance() : new BlobStringsCache.BlobStringsCacheCreator().getInstance();
        this.vaultIdentity = identityGenerator.nextId();
    }

    public BlobVault getSourceVault() {
        return this;
    }

    public int getIdentity() {
        return this.vaultIdentity;
    }

    @NotNull
    public File getBlobLocation(long blobHandle) {
        throw new UnsupportedOperationException("Non-file based vault");
    }

    public String getBlobKey(long blobHandle) {
        String file;
        ArrayList<String> files = new ArrayList<String>(8);
        while (true) {
            file = Integer.toHexString((int)(blobHandle & 0xFFL));
            if (blobHandle <= 255L) break;
            files.add(file);
            blobHandle >>= 8;
        }
        files.add(file);
        StringBuilder dir = new StringBuilder();
        ListIterator iterator = files.listIterator(files.size());
        while (iterator.hasPrevious()) {
            dir.append('/');
            dir.append(iterator.previous());
        }
        return dir.toString();
    }

    @NotNull
    public abstract BlobVaultItem getBlob(long var1);

    public abstract boolean delete(long var1);

    @Nullable
    public abstract InputStream getContent(long var1, @NotNull Transaction var3);

    public abstract long getSize(long var1, @NotNull Transaction var3);

    public abstract boolean requiresTxn();

    public abstract void flushBlobs(@Nullable LongHashMap<InputStream> var1, @Nullable LongHashMap<File> var2, @Nullable LongSet var3, @NotNull Transaction var4) throws Exception;

    public abstract long size();

    public abstract void clear();

    public abstract void close();

    @Nullable
    public final String getStringContent(long blobHandle, @NotNull Transaction txn) throws IOException {
        String result = this.stringContentCache.tryKey(this, blobHandle);
        if (result == null) {
            InputStream content = this.getContent(blobHandle, txn);
            if (content == null) {
                logger.error("Blob string not found: " + this.getBlobLocation(blobHandle), (Throwable)new FileNotFoundException());
            }
            String string = result = content == null ? null : UTFUtil.readUTF((InputStream)content);
            if (result != null && (long)result.length() <= this.config.getBlobStringsCacheMaxValueSize() && this.stringContentCache.getObject(this, blobHandle) == null) {
                this.stringContentCache.cacheObject(this, blobHandle, result);
            }
        }
        return result;
    }

    public final float getStringContentCacheHitRate() {
        return this.stringContentCache.getHitRate();
    }

    public final ByteArrayOutputStream copyStream(@NotNull InputStream source, boolean closeSource) throws IOException {
        LightByteArrayOutputStream memCopy = new LightByteArrayOutputStream();
        IOUtil.copyStreams((InputStream)source, (OutputStream)memCopy, (ByteArraySpinAllocator)bufferAllocator);
        if (closeSource) {
            source.close();
        }
        return memCopy;
    }

    public final ByteArraySizedInputStream cloneStream(@NotNull InputStream source, boolean closeSource) throws IOException {
        ByteArrayOutputStream memCopy = this.copyStream(source, closeSource);
        return new ByteArraySizedInputStream(memCopy.toByteArray(), 0, memCopy.size());
    }

    public final ByteArraySizedInputStream cloneFile(@NotNull File file) throws IOException {
        try (FileInputStream input = new FileInputStream(file);){
            ByteArraySizedInputStream byteArraySizedInputStream = this.cloneStream(input, false);
            return byteArraySizedInputStream;
        }
    }
}

