/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.io;

import java.util.ServiceLoader;
import jetbrains.exodus.core.dataStructures.Pair;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.io.DataReader;
import jetbrains.exodus.io.DataWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DataReaderWriterProvider {
    public static final String DEFAULT_READER_WRITER_PROVIDER = "jetbrains.exodus.io.FileDataReaderWriterProvider";

    public abstract Pair<DataReader, DataWriter> newReaderWriter(@NotNull String var1);

    public boolean isInMemory() {
        return false;
    }

    public boolean isReadonly() {
        return false;
    }

    public void onEnvironmentCreated(@NotNull Environment environment) {
    }

    @Nullable
    public static DataReaderWriterProvider getProvider(@NotNull String providerName) {
        for (DataReaderWriterProvider provider : ServiceLoader.load(DataReaderWriterProvider.class)) {
            if (!provider.getClass().getCanonicalName().equalsIgnoreCase(providerName)) continue;
            return provider;
        }
        return null;
    }
}

