/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.bindings;

import java.io.ByteArrayInputStream;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.BindingUtils;
import jetbrains.exodus.bindings.ComparableBinding;
import jetbrains.exodus.util.LightOutputStream;
import org.jetbrains.annotations.NotNull;

public class FloatBinding
extends ComparableBinding {
    public static final FloatBinding BINDING = new FloatBinding();

    private FloatBinding() {
    }

    @Override
    public Float readObject(@NotNull ByteArrayInputStream stream) {
        return Float.valueOf(BindingUtils.readFloat(stream));
    }

    @Override
    public void writeObject(@NotNull LightOutputStream output, @NotNull Comparable object) {
        output.writeUnsignedInt(Float.floatToIntBits(((Float)object).floatValue()));
    }

    public static float entryToFloat(@NotNull ByteIterable entry) {
        return ((Float)BINDING.entryToObject(entry)).floatValue();
    }

    public static ArrayByteIterable floatToEntry(float object) {
        return BINDING.objectToEntry(Float.valueOf(object));
    }
}

