/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore;

import jetbrains.exodus.AbstractConfig;
import jetbrains.exodus.ConfigurationStrategy;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.core.dataStructures.Pair;
import jetbrains.exodus.entitystore.replication.PersistentEntityStoreReplicator;
import org.jetbrains.annotations.NotNull;

public class PersistentEntityStoreConfig
extends AbstractConfig {
    public static final PersistentEntityStoreConfig DEFAULT = new PersistentEntityStoreConfig(ConfigurationStrategy.IGNORE){

        @Override
        public PersistentEntityStoreConfig setMutable(boolean isMutable) {
            if (!this.isMutable() && isMutable) {
                throw new ExodusException("Can't make PersistentEntityStoreConfig.DEFAULT mutable");
            }
            return super.setMutable(isMutable);
        }
    }.setMutable(false);
    public static final String REFACTORING_SKIP_ALL = "exodus.entityStore.refactoring.skipAll";
    public static final String REFACTORING_FORCE_ALL = "exodus.entityStore.refactoring.forceAll";
    public static final String REFACTORING_NULL_INDICES = "exodus.entityStore.refactoring.nullIndices";
    public static final String REFACTORING_BLOB_NULL_INDICES = "exodus.entityStore.refactoring.blobNullIndices";
    public static final String REFACTORING_HEAVY_LINKS = "exodus.entityStore.refactoring.heavyLinks";
    public static final String REFACTORING_HEAVY_PROPS = "exodus.entityStore.refactoring.heavyProps";
    public static final String REFACTORING_DELETE_REDUNDANT_BLOBS = "exodus.entityStore.refactoring.deleteRedundantBlobs";
    public static final String MAX_IN_PLACE_BLOB_SIZE = "exodus.entityStore.maxInPlaceBlobSize";
    public static final String BLOB_STRINGS_CACHE_SHARED = "exodus.entityStore.blobStringsCacheShared";
    public static final String BLOB_STRINGS_CACHE_MAX_VALUE_SIZE = "exodus.entityStore.blobStringsCacheMaxValueSize";
    @Deprecated
    public static final String BLOB_STRINGS_CACHE_SIZE = "exodus.entityStore.blobStringsCacheSize";
    public static final String CACHING_DISABLED = "exodus.entityStore.cachingDisabled";
    public static final String REORDERING_DISABLED = "exodus.entityStore.reorderingDisabled";
    public static final String EXPLAIN_ON = "exodus.entityStore.explainOn";
    public static final String DEBUG_LINK_DATA_GETTER = "exodus.entityStore.debug.linkDataGetter";
    public static final String DEBUG_SEARCH_FOR_INCOMING_LINKS_ON_DELETE = "exodus.entityStore.debug.searchForIncomingLinksOnDelete";
    public static final String DEBUG_TEST_LINKED_ENTITIES = "exodus.entityStore.debug.testLinkedEntities";
    public static final String DEBUG_ALLOW_IN_MEMORY_SORT = "exodus.entityStore.debug.allowInMemorySort";
    public static final String ENTITY_ITERABLE_CACHE_SIZE = "exodus.entityStore.entityIterableCache.size";
    public static final String ENTITY_ITERABLE_CACHE_COUNTS_CACHE_SIZE = "exodus.entityStore.entityIterableCache.countsCacheSize";
    public static final String ENTITY_ITERABLE_CACHE_THREAD_COUNT = "exodus.entityStore.entityIterableCache.threadCount";
    public static final String ENTITY_ITERABLE_CACHE_CACHING_TIMEOUT = "exodus.entityStore.entityIterableCache.cachingTimeout";
    public static final String ENTITY_ITERABLE_CACHE_COUNTS_CACHING_TIMEOUT = "exodus.entityStore.entityIterableCache.countsCachingTimeout";
    public static final String ENTITY_ITERABLE_CACHE_START_CACHING_TIMEOUT = "exodus.entityStore.entityIterableCache.startCachingTimeout";
    public static final String ENTITY_ITERABLE_CACHE_DEFERRED_DELAY = "exodus.entityStore.entityIterableCache.deferredDelay";
    public static final String ENTITY_ITERABLE_CACHE_MAX_SIZE_OF_DIRECT_VALUE = "exodus.entityStore.entityIterableCache.maxSizeOfDirectValue";
    public static final String ENTITY_ITERABLE_CACHE_USE_HUMAN_READABLE = "exodus.entityStore.entityIterableCache.useHumanReadable";
    public static final String ENTITY_ITERABLE_CACHE_HEAVY_QUERIES_CACHE_SIZE = "exodus.entityStore.entityIterableCache.heavyQueriesCacheSize";
    public static final String ENTITY_ITERABLE_CACHE_HEAVY_ITERABLES_LIFE_SPAN = "exodus.entityStore.entityIterableCache.heavyQueriesLifeSpan";
    public static final String TRANSACTION_PROPS_CACHE_SIZE = "exodus.entityStore.transaction.propsCacheSize";
    public static final String TRANSACTION_LINKS_CACHE_SIZE = "exodus.entityStore.transaction.linksCacheSize";
    public static final String TRANSACTION_BLOB_STRINGS_CACHE_SIZE = "exodus.entityStore.transaction.blobStringsCacheSize";
    public static final String GATHER_STATISTICS = "exodus.entityStore.gatherStatistics";
    public static final String MANAGEMENT_ENABLED = "exodus.entityStore.managementEnabled";
    public static final String REPLICATOR = "exodus.entityStore.replicator";
    private static final int MAX_DEFAULT_ENTITY_ITERABLE_CACHE_SIZE = 4096;

    public PersistentEntityStoreConfig() {
        this(ConfigurationStrategy.SYSTEM_PROPERTY);
    }

    public PersistentEntityStoreConfig(@NotNull ConfigurationStrategy strategy) {
        super(new Pair[]{new Pair((Object)REFACTORING_SKIP_ALL, (Object)false), new Pair((Object)REFACTORING_FORCE_ALL, (Object)false), new Pair((Object)REFACTORING_NULL_INDICES, (Object)false), new Pair((Object)REFACTORING_BLOB_NULL_INDICES, (Object)false), new Pair((Object)REFACTORING_HEAVY_LINKS, (Object)false), new Pair((Object)REFACTORING_HEAVY_PROPS, (Object)false), new Pair((Object)REFACTORING_DELETE_REDUNDANT_BLOBS, (Object)false), new Pair((Object)MAX_IN_PLACE_BLOB_SIZE, (Object)10000), new Pair((Object)BLOB_STRINGS_CACHE_SHARED, (Object)true), new Pair((Object)BLOB_STRINGS_CACHE_MAX_VALUE_SIZE, (Object)1000000L), new Pair((Object)CACHING_DISABLED, (Object)false), new Pair((Object)REORDERING_DISABLED, (Object)false), new Pair((Object)EXPLAIN_ON, (Object)false), new Pair((Object)DEBUG_LINK_DATA_GETTER, (Object)false), new Pair((Object)DEBUG_SEARCH_FOR_INCOMING_LINKS_ON_DELETE, (Object)false), new Pair((Object)DEBUG_TEST_LINKED_ENTITIES, (Object)true), new Pair((Object)DEBUG_ALLOW_IN_MEMORY_SORT, (Object)true), new Pair((Object)ENTITY_ITERABLE_CACHE_SIZE, (Object)PersistentEntityStoreConfig.defaultEntityIterableCacheSize()), new Pair((Object)ENTITY_ITERABLE_CACHE_COUNTS_CACHE_SIZE, (Object)65536), new Pair((Object)ENTITY_ITERABLE_CACHE_THREAD_COUNT, (Object)(Runtime.getRuntime().availableProcessors() > 8 ? 4 : 2)), new Pair((Object)ENTITY_ITERABLE_CACHE_CACHING_TIMEOUT, (Object)10000L), new Pair((Object)ENTITY_ITERABLE_CACHE_COUNTS_CACHING_TIMEOUT, (Object)100000L), new Pair((Object)ENTITY_ITERABLE_CACHE_START_CACHING_TIMEOUT, (Object)7000L), new Pair((Object)ENTITY_ITERABLE_CACHE_DEFERRED_DELAY, (Object)2000), new Pair((Object)ENTITY_ITERABLE_CACHE_MAX_SIZE_OF_DIRECT_VALUE, (Object)512), new Pair((Object)ENTITY_ITERABLE_CACHE_USE_HUMAN_READABLE, (Object)false), new Pair((Object)ENTITY_ITERABLE_CACHE_HEAVY_QUERIES_CACHE_SIZE, (Object)2048), new Pair((Object)ENTITY_ITERABLE_CACHE_HEAVY_ITERABLES_LIFE_SPAN, (Object)60000L), new Pair((Object)TRANSACTION_PROPS_CACHE_SIZE, (Object)1024), new Pair((Object)TRANSACTION_LINKS_CACHE_SIZE, (Object)1024), new Pair((Object)TRANSACTION_BLOB_STRINGS_CACHE_SIZE, (Object)256), new Pair((Object)GATHER_STATISTICS, (Object)true), new Pair((Object)MANAGEMENT_ENABLED, (Object)true), new Pair((Object)REPLICATOR, null)}, strategy);
    }

    @Override
    public PersistentEntityStoreConfig setSetting(@NotNull String key, @NotNull Object value) {
        return (PersistentEntityStoreConfig)super.setSetting(key, value);
    }

    @Override
    public PersistentEntityStoreConfig setMutable(boolean isMutable) {
        return (PersistentEntityStoreConfig)super.setMutable(isMutable);
    }

    public boolean getRefactoringSkipAll() {
        return (Boolean)this.getSetting(REFACTORING_SKIP_ALL);
    }

    public PersistentEntityStoreConfig setRefactoringSkipAll(boolean skipAll) {
        return this.setSetting(REFACTORING_SKIP_ALL, skipAll);
    }

    public boolean getRefactoringForceAll() {
        return (Boolean)this.getSetting(REFACTORING_FORCE_ALL);
    }

    public PersistentEntityStoreConfig setRefactoringForceAll(boolean forceAll) {
        return this.setSetting(REFACTORING_FORCE_ALL, forceAll);
    }

    public boolean getRefactoringNullIndices() {
        return this.getRefactoringForceAll() || (Boolean)this.getSetting(REFACTORING_NULL_INDICES) != false;
    }

    public PersistentEntityStoreConfig setRefactoringNullIndices(boolean nullIndices) {
        return this.setSetting(REFACTORING_NULL_INDICES, nullIndices);
    }

    public boolean getRefactoringBlobNullIndices() {
        return this.getRefactoringForceAll() || (Boolean)this.getSetting(REFACTORING_BLOB_NULL_INDICES) != false;
    }

    public PersistentEntityStoreConfig setRefactoringBlobNullIndices(boolean nullIndices) {
        return this.setSetting(REFACTORING_BLOB_NULL_INDICES, nullIndices);
    }

    public boolean getRefactoringHeavyLinks() {
        return this.getRefactoringForceAll() || (Boolean)this.getSetting(REFACTORING_HEAVY_LINKS) != false;
    }

    public PersistentEntityStoreConfig setRefactoringHeavyLinks(boolean heavyLinks) {
        return this.setSetting(REFACTORING_HEAVY_LINKS, heavyLinks);
    }

    public boolean getRefactoringHeavyProps() {
        return this.getRefactoringForceAll() || (Boolean)this.getSetting(REFACTORING_HEAVY_PROPS) != false;
    }

    public PersistentEntityStoreConfig setRefactoringHeavyProps(boolean heavyProps) {
        return this.setSetting(REFACTORING_HEAVY_PROPS, heavyProps);
    }

    public boolean getRefactoringDeleteRedundantBlobs() {
        return this.getRefactoringForceAll() || (Boolean)this.getSetting(REFACTORING_DELETE_REDUNDANT_BLOBS) != false;
    }

    public PersistentEntityStoreConfig setRefactoringDeleteRedundantBlobs(boolean fixRedundantBlobs) {
        return this.setSetting(REFACTORING_DELETE_REDUNDANT_BLOBS, fixRedundantBlobs);
    }

    public int getMaxInPlaceBlobSize() {
        return (Integer)this.getSetting(MAX_IN_PLACE_BLOB_SIZE);
    }

    public PersistentEntityStoreConfig setMaxInPlaceBlobSize(int blobSize) {
        return this.setSetting(MAX_IN_PLACE_BLOB_SIZE, blobSize);
    }

    public boolean isBlobStringsCacheShared() {
        return (Boolean)this.getSetting(BLOB_STRINGS_CACHE_SHARED);
    }

    public PersistentEntityStoreConfig setBlobStringsCacheShared(boolean shared) {
        return this.setSetting(BLOB_STRINGS_CACHE_SHARED, shared);
    }

    public long getBlobStringsCacheMaxValueSize() {
        return (Long)this.getSetting(BLOB_STRINGS_CACHE_MAX_VALUE_SIZE);
    }

    public PersistentEntityStoreConfig setBlobStringsCacheMaxValueSize(long maxValueSize) {
        return this.setSetting(BLOB_STRINGS_CACHE_MAX_VALUE_SIZE, maxValueSize);
    }

    @Deprecated
    public int getBlobStringsCacheSize() {
        return (Integer)this.getSetting(BLOB_STRINGS_CACHE_SIZE);
    }

    @Deprecated
    public PersistentEntityStoreConfig setBlobStringsCacheSize(int blobStringsCacheSize) {
        return this.setSetting(BLOB_STRINGS_CACHE_SIZE, blobStringsCacheSize);
    }

    public boolean isCachingDisabled() {
        return (Boolean)this.getSetting(CACHING_DISABLED);
    }

    public PersistentEntityStoreConfig setCachingDisabled(boolean disabled) {
        return this.setSetting(CACHING_DISABLED, disabled);
    }

    public boolean isReorderingDisabled() {
        return (Boolean)this.getSetting(REORDERING_DISABLED);
    }

    public PersistentEntityStoreConfig setReorderingDisabled(boolean disabled) {
        return this.setSetting(REORDERING_DISABLED, disabled);
    }

    public boolean isExplainOn() {
        return (Boolean)this.getSetting(EXPLAIN_ON);
    }

    public PersistentEntityStoreConfig setExplainOn(boolean explainOn) {
        return this.setSetting(EXPLAIN_ON, explainOn);
    }

    public boolean isDebugLinkDataGetter() {
        return (Boolean)this.getSetting(DEBUG_LINK_DATA_GETTER);
    }

    public PersistentEntityStoreConfig setDebugLinkDataGetter(boolean debug) {
        return this.setSetting(DEBUG_LINK_DATA_GETTER, debug);
    }

    public boolean isDebugSearchForIncomingLinksOnDelete() {
        return (Boolean)this.getSetting(DEBUG_SEARCH_FOR_INCOMING_LINKS_ON_DELETE);
    }

    public PersistentEntityStoreConfig setDebugSearchForIncomingLinksOnDelete(boolean debug) {
        return this.setSetting(DEBUG_SEARCH_FOR_INCOMING_LINKS_ON_DELETE, debug);
    }

    public boolean isDebugTestLinkedEntities() {
        return (Boolean)this.getSetting(DEBUG_TEST_LINKED_ENTITIES);
    }

    public PersistentEntityStoreConfig setDebugTestLinkedEntities(boolean debug) {
        return this.setSetting(DEBUG_TEST_LINKED_ENTITIES, debug);
    }

    public boolean isDebugAllowInMemorySort() {
        return (Boolean)this.getSetting(DEBUG_ALLOW_IN_MEMORY_SORT);
    }

    public PersistentEntityStoreConfig setDebugAllowInMemorySort(boolean debug) {
        return this.setSetting(DEBUG_ALLOW_IN_MEMORY_SORT, debug);
    }

    public int getEntityIterableCacheSize() {
        return (Integer)this.getSetting(ENTITY_ITERABLE_CACHE_SIZE);
    }

    public PersistentEntityStoreConfig setEntityIterableCacheSize(int size) {
        return this.setSetting(ENTITY_ITERABLE_CACHE_SIZE, size);
    }

    public int getEntityIterableCacheCountsCacheSize() {
        return (Integer)this.getSetting(ENTITY_ITERABLE_CACHE_COUNTS_CACHE_SIZE);
    }

    public PersistentEntityStoreConfig setEntityIterableCacheCountsCacheSize(int size) {
        return this.setSetting(ENTITY_ITERABLE_CACHE_COUNTS_CACHE_SIZE, size);
    }

    public int getEntityIterableCacheThreadCount() {
        return (Integer)this.getSetting(ENTITY_ITERABLE_CACHE_THREAD_COUNT);
    }

    public PersistentEntityStoreConfig setEntityIterableCacheThreadCount(int threadCount) {
        return this.setSetting(ENTITY_ITERABLE_CACHE_THREAD_COUNT, threadCount);
    }

    public long getEntityIterableCacheCachingTimeout() {
        return (Long)this.getSetting(ENTITY_ITERABLE_CACHE_CACHING_TIMEOUT);
    }

    public PersistentEntityStoreConfig setEntityIterableCacheCachingTimeout(long cachingTimeout) {
        return this.setSetting(ENTITY_ITERABLE_CACHE_CACHING_TIMEOUT, cachingTimeout);
    }

    public long getEntityIterableCacheCountsCachingTimeout() {
        return (Long)this.getSetting(ENTITY_ITERABLE_CACHE_COUNTS_CACHING_TIMEOUT);
    }

    public PersistentEntityStoreConfig setEntityIterableCacheCountsCachingTimeout(long cachingTimeout) {
        return this.setSetting(ENTITY_ITERABLE_CACHE_COUNTS_CACHING_TIMEOUT, cachingTimeout);
    }

    public long getEntityIterableCacheStartCachingTimeout() {
        return (Long)this.getSetting(ENTITY_ITERABLE_CACHE_START_CACHING_TIMEOUT);
    }

    public PersistentEntityStoreConfig setEntityIterableCacheStartCachingTimeout(long cachingTimeout) {
        return this.setSetting(ENTITY_ITERABLE_CACHE_START_CACHING_TIMEOUT, cachingTimeout);
    }

    public int getEntityIterableCacheDeferredDelay() {
        return (Integer)this.getSetting(ENTITY_ITERABLE_CACHE_DEFERRED_DELAY);
    }

    public PersistentEntityStoreConfig setEntityIterableCacheDeferredDelay(int deferredDelay) {
        return this.setSetting(ENTITY_ITERABLE_CACHE_DEFERRED_DELAY, deferredDelay);
    }

    public int getEntityIterableCacheMaxSizeOfDirectValue() {
        return (Integer)this.getSetting(ENTITY_ITERABLE_CACHE_MAX_SIZE_OF_DIRECT_VALUE);
    }

    public PersistentEntityStoreConfig setEntityIterableCacheMaxSizeOfDirectValue(int maxSizeOfDirectValue) {
        return this.setSetting(ENTITY_ITERABLE_CACHE_MAX_SIZE_OF_DIRECT_VALUE, maxSizeOfDirectValue);
    }

    public boolean getEntityIterableCacheUseHumanReadable() {
        return (Boolean)this.getSetting(ENTITY_ITERABLE_CACHE_USE_HUMAN_READABLE);
    }

    public PersistentEntityStoreConfig setEntityIterableCacheUseHumanReadable(boolean useHumanReadable) {
        return this.setSetting(ENTITY_ITERABLE_CACHE_USE_HUMAN_READABLE, useHumanReadable);
    }

    public int getEntityIterableCacheHeavyIterablesCacheSize() {
        return (Integer)this.getSetting(ENTITY_ITERABLE_CACHE_HEAVY_QUERIES_CACHE_SIZE);
    }

    public PersistentEntityStoreConfig setEntityIterableCacheHeavyIterablesCacheSize(int cacheSize) {
        return this.setSetting(ENTITY_ITERABLE_CACHE_HEAVY_QUERIES_CACHE_SIZE, cacheSize);
    }

    public long getEntityIterableCacheHeavyIterablesLifeSpan() {
        return (Long)this.getSetting(ENTITY_ITERABLE_CACHE_HEAVY_ITERABLES_LIFE_SPAN);
    }

    public PersistentEntityStoreConfig setEntityIterableCacheHeavyIterablesLifeSpan(long lifeSpan) {
        return this.setSetting(ENTITY_ITERABLE_CACHE_HEAVY_ITERABLES_LIFE_SPAN, lifeSpan);
    }

    public int getTransactionPropsCacheSize() {
        return (Integer)this.getSetting(TRANSACTION_PROPS_CACHE_SIZE);
    }

    public PersistentEntityStoreConfig setTransactionPropsCacheSize(int transactionPropsCacheSize) {
        return this.setSetting(TRANSACTION_PROPS_CACHE_SIZE, transactionPropsCacheSize);
    }

    public int getTransactionLinksCacheSize() {
        return (Integer)this.getSetting(TRANSACTION_LINKS_CACHE_SIZE);
    }

    public PersistentEntityStoreConfig setTransactionLinksCacheSize(int transactionLinksCacheSize) {
        return this.setSetting(TRANSACTION_LINKS_CACHE_SIZE, transactionLinksCacheSize);
    }

    public int getTransactionBlobStringsCacheSize() {
        return (Integer)this.getSetting(TRANSACTION_BLOB_STRINGS_CACHE_SIZE);
    }

    public PersistentEntityStoreConfig setTransactionBlobStringsCacheSize(int transactionBlobStringsCacheSize) {
        return this.setSetting(TRANSACTION_BLOB_STRINGS_CACHE_SIZE, transactionBlobStringsCacheSize);
    }

    public boolean getGatherStatistics() {
        return (Boolean)this.getSetting(GATHER_STATISTICS);
    }

    public PersistentEntityStoreConfig setGatherStatistics(boolean gatherStatistics) {
        return this.setSetting(GATHER_STATISTICS, gatherStatistics);
    }

    public boolean isManagementEnabled() {
        return (Boolean)this.getSetting(MANAGEMENT_ENABLED);
    }

    public PersistentEntityStoreConfig setManagementEnabled(boolean managementEnabled) {
        return this.setSetting(MANAGEMENT_ENABLED, managementEnabled);
    }

    public PersistentEntityStoreConfig setStoreReplicator(PersistentEntityStoreReplicator replicator) {
        return this.setSetting(REPLICATOR, replicator);
    }

    public PersistentEntityStoreReplicator getStoreReplicator() {
        return (PersistentEntityStoreReplicator)this.getSetting(REPLICATOR);
    }

    private static int defaultEntityIterableCacheSize() {
        return Math.max((int)(Runtime.getRuntime().maxMemory() >> 20), 4096);
    }
}

