/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures.persistent;

import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public class PersistentStack<T> {
    public static final PersistentStack EMPTY_STACK = new PersistentStack();
    private final T element;
    private final int size;
    private final PersistentStack<T> next;

    private PersistentStack() {
        this.element = null;
        this.size = 0;
        this.next = null;
    }

    private PersistentStack(T e, PersistentStack<T> stack) {
        this.element = e;
        this.size = stack.size + 1;
        this.next = stack;
    }

    public boolean isEmpty() {
        return this.element == null;
    }

    public int size() {
        return this.size;
    }

    public PersistentStack<T> push(@NotNull T e) {
        return new PersistentStack<T>(e, this);
    }

    public T peek() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.element;
    }

    public PersistentStack<T> skip() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.next;
    }

    public PersistentStack<T> reverse() {
        PersistentStack<T> result = new PersistentStack<T>();
        PersistentStack<T> stack = this;
        while (!stack.isEmpty()) {
            result = new PersistentStack<T>(stack.peek(), result);
            stack = stack.skip();
        }
        return result;
    }

    public int hashCode() {
        return this.isEmpty() ? 271828182 : this.element.hashCode() + this.next.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PersistentStack)) {
            return false;
        }
        PersistentStack stack = (PersistentStack)obj;
        if (this.isEmpty()) {
            return stack.isEmpty();
        }
        if (stack.isEmpty()) {
            return false;
        }
        return this.element.equals(stack.element) && this.next.equals(stack.next);
    }
}

