/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures.skiplists;

import jetbrains.exodus.util.Random;

class SkipListBase {
    private static final int[] LEVEL_FACTORS = new int[]{7, 5, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3};
    private final Random rnd = new Random();
    private int seed = this.rnd.nextInt() & Integer.MAX_VALUE;
    protected int size;

    SkipListBase() {
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    protected int generateQuasiRandomLevel() {
        int factor;
        int level = 1;
        int seed = this.seed + 1;
        if ((seed & 0x3FF) == 0) {
            seed = this.rnd.nextInt();
        }
        this.seed = seed &= Integer.MAX_VALUE;
        while (seed % (factor = LEVEL_FACTORS[level - 1]) == 1) {
            seed /= factor;
            ++level;
        }
        return level;
    }
}

