/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.execution;

import java.util.Collections;
import jetbrains.exodus.core.dataStructures.Priority;
import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.core.execution.JobProcessorAdapter;
import jetbrains.exodus.core.execution.LatchJob;
import jetbrains.exodus.core.execution.ThreadJobProcessor;
import jetbrains.exodus.core.execution.ThreadJobProcessorPool;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MultiThreadDelegatingJobProcessor
extends JobProcessorAdapter {
    @NonNls
    private static final String UNSUPPORTED_TIMED_JOBS_MESSAGE = "Timed jobs are not supported by MultiThreadDelegatingJobProcessor";
    protected final ThreadJobProcessor[] jobProcessors;

    protected MultiThreadDelegatingJobProcessor(String name, int threadCount) {
        this.jobProcessors = new ThreadJobProcessor[threadCount];
        for (int i = 0; i < this.jobProcessors.length; ++i) {
            this.jobProcessors[i] = ThreadJobProcessorPool.getOrCreateJobProcessor(name + i);
        }
    }

    @Override
    protected Job pushAt(Job job, long millis) {
        throw new UnsupportedOperationException(UNSUPPORTED_TIMED_JOBS_MESSAGE);
    }

    @Override
    public void waitForJobs(long spinTimeout) {
        for (ThreadJobProcessor processor : this.jobProcessors) {
            processor.waitForJobs(spinTimeout);
        }
    }

    @Override
    public void waitForTimedJobs(long spinTimeout) {
        for (ThreadJobProcessor processor : this.jobProcessors) {
            processor.waitForTimedJobs(spinTimeout);
        }
    }

    @Override
    protected boolean queueLowest(@NotNull Job job) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean queueLowestTimed(@NotNull Job job) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public Job getCurrentJob() {
        return null;
    }

    @Override
    public long getCurrentJobStartedAt() {
        return 0L;
    }

    @Override
    @NotNull
    public Iterable<Job> getPendingJobs() {
        return Collections.emptyList();
    }

    @Override
    public int pendingTimedJobs() {
        return 0;
    }

    @Override
    public void start() {
        if (!this.started.getAndSet(true)) {
            this.finished.set(false);
            for (ThreadJobProcessor jobProcessor : this.jobProcessors) {
                jobProcessor.start();
            }
        }
    }

    @Override
    protected final void processorStarted() {
    }

    @Override
    protected final void processorFinished() {
    }

    @Override
    public void finish() {
        if (this.started.get() && !this.finished.getAndSet(true)) {
            for (ThreadJobProcessor processor : this.jobProcessors) {
                processor.waitForLatchJob(new LatchJob(){

                    @Override
                    protected void execute() throws Throwable {
                        this.release();
                    }
                }, 100L);
            }
            this.started.set(false);
        }
    }

    public boolean isDispatcherThread() {
        long currentThreadId = Thread.currentThread().getId();
        for (ThreadJobProcessor processor : this.jobProcessors) {
            if (currentThreadId != processor.getId()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int pendingJobs() {
        int result = 0;
        for (ThreadJobProcessor processor : this.jobProcessors) {
            result += processor.pendingJobs();
        }
        return result;
    }

    public int getThreadCount() {
        return this.jobProcessors.length;
    }

    @Override
    protected boolean push(Job job, Priority priority) {
        if (this.isFinished()) {
            return false;
        }
        if (job.getProcessor() == null) {
            job.setProcessor(this);
        }
        int hc = job.hashCode();
        int processorNumber = ((hc & 0xFFFF) + (hc >>> 16)) % this.jobProcessors.length;
        return this.jobProcessors[processorNumber].queue(job, priority);
    }
}

