/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.execution;

import java.util.concurrent.atomic.AtomicReference;
import jetbrains.exodus.core.dataStructures.decorators.QueueDecorator;
import jetbrains.exodus.core.dataStructures.persistent.PersistentHashSet;
import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.core.execution.JobProcessor;
import jetbrains.exodus.core.execution.ThreadJobProcessorPool;
import org.jetbrains.annotations.NotNull;

public class SharedTimer {
    private static int PERIOD = 1000;
    private static final JobProcessor processor = ThreadJobProcessorPool.getOrCreateJobProcessor("Exodus shared timer thread");
    private static final AtomicReference<PersistentHashSet<ExpirablePeriodicTask>> registeredTasks = new AtomicReference(new PersistentHashSet());

    private SharedTimer() {
    }

    public static void registerPeriodicTask(final @NotNull ExpirablePeriodicTask task) {
        SharedTimer.optimisticUpdateOfTasks(new TasksUpdater(){

            @Override
            public void update(@NotNull PersistentHashSet.MutablePersistentHashSet<ExpirablePeriodicTask> mutableTasks) {
                mutableTasks.add(task);
            }
        });
    }

    public static void unregisterPeriodicTask(final @NotNull ExpirablePeriodicTask task) {
        SharedTimer.optimisticUpdateOfTasks(new TasksUpdater(){

            @Override
            public void update(@NotNull PersistentHashSet.MutablePersistentHashSet<ExpirablePeriodicTask> mutableTasks) {
                mutableTasks.remove(task);
            }
        });
    }

    private static void optimisticUpdateOfTasks(@NotNull TasksUpdater updater) {
        PersistentHashSet<ExpirablePeriodicTask> copy;
        PersistentHashSet<ExpirablePeriodicTask> current;
        do {
            current = registeredTasks.get();
            copy = current.getClone();
            PersistentHashSet.MutablePersistentHashSet<ExpirablePeriodicTask> mutableTasks = copy.beginWrite();
            updater.update(mutableTasks);
            mutableTasks.endWrite();
        } while (!registeredTasks.compareAndSet(current, copy));
    }

    static {
        processor.queueIn(new Ticker(), PERIOD);
    }

    private static class Ticker
    extends Job {
        private Ticker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void execute() throws Throwable {
            long nextTick = System.currentTimeMillis() + (long)PERIOD;
            final QueueDecorator<ExpirablePeriodicTask> expiredTasks = new QueueDecorator<ExpirablePeriodicTask>();
            try {
                for (ExpirablePeriodicTask task : (PersistentHashSet)registeredTasks.get()) {
                    if (task.isExpired()) {
                        expiredTasks.add(task);
                        continue;
                    }
                    task.run();
                }
                if (!expiredTasks.isEmpty()) {
                    SharedTimer.optimisticUpdateOfTasks(new TasksUpdater(){

                        @Override
                        public void update(@NotNull PersistentHashSet.MutablePersistentHashSet<ExpirablePeriodicTask> mutableTasks) {
                            for (ExpirablePeriodicTask expiredTask : expiredTasks) {
                                mutableTasks.remove(expiredTask);
                            }
                        }
                    });
                }
            }
            finally {
                processor.queueAt(this, nextTick);
            }
        }
    }

    private static interface TasksUpdater {
        public void update(@NotNull PersistentHashSet.MutablePersistentHashSet<ExpirablePeriodicTask> var1);
    }

    public static interface ExpirablePeriodicTask
    extends Runnable {
        public boolean isExpired();
    }
}

