/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.execution.locks;

public class Semaphore {
    Thread thread;
    private int permits;
    private int maxPermits;

    public Semaphore() {
        this(0);
    }

    public Semaphore(int permits) {
        this.permits = permits;
        this.maxPermits = permits;
    }

    public synchronized boolean tryAcquire() {
        if (this.permits > 0) {
            this.acquire();
            return true;
        }
        return false;
    }

    public void acquire() {
        this.acquire(1);
    }

    public synchronized void acquire(int permits) {
        while (this.permits < permits) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
        this.permits -= permits;
        this.thread = Thread.currentThread();
    }

    public void acquireUninterruptibly() {
        this.acquire();
    }

    public void acquireUninterruptibly(int permits) {
        this.acquire(permits);
    }

    public void release() {
        this.release(1);
    }

    public synchronized void release(int permits) {
        int resultingPermits = this.permits + permits;
        if (resultingPermits > this.maxPermits) {
            throw new IllegalArgumentException("Can't release " + permits + " permits. Current permits: " + this.permits + ", max permits: " + this.maxPermits);
        }
        this.permits = resultingPermits;
        this.notifyAll();
    }

    public synchronized int availablePermits() {
        return this.permits;
    }
}

