/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.util;

import jetbrains.exodus.core.dataStructures.ConcurrentObjectCache;
import jetbrains.exodus.system.JVMConstants;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0011\b\u0002\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u0007J\u001a\u0010\b\u001a\u00020\u00072\n\u0010\n\u001a\u00060\u000bj\u0002`\f2\u0006\u0010\r\u001a\u00020\u0003R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Ljetbrains/exodus/util/StringInterner;", "", "size", "", "(I)V", "cache", "Ljetbrains/exodus/core/dataStructures/ConcurrentObjectCache;", "", "doIntern", "s", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "maxLen", "Companion", "xodus-utils"})
public final class StringInterner {
    private final ConcurrentObjectCache<String, String> cache;
    private static final int NUMBER_OF_GENERATIONS = 3;
    private static final Integer MAX_SIZE_OF_CACHED_STRING;
    private static final Integer INTERNER_SIZE;
    private static final StringInterner DEFAULT_INTERNER;
    public static final Companion Companion;

    @Nullable
    public final String doIntern(@Nullable String s) {
        block5: {
            block4: {
                if (s == null) break block4;
                int n = s.length();
                Integer n2 = MAX_SIZE_OF_CACHED_STRING;
                Intrinsics.checkExpressionValueIsNotNull((Object)n2, (String)"MAX_SIZE_OF_CACHED_STRING");
                if (Intrinsics.compare((int)n, (int)n2) <= 0) break block5;
            }
            return s;
        }
        String cached = this.cache.tryKey(s);
        if (cached != null) {
            return cached;
        }
        String copy = JVMConstants.INSTANCE.getIS_JAVA8_OR_HIGHER() ? s : s + "";
        this.cache.cacheObject(copy, copy);
        return copy;
    }

    @NotNull
    public final String doIntern(@NotNull StringBuilder builder, int maxLen) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        String result = builder.toString();
        if (builder.length() <= maxLen) {
            String cached = this.cache.tryKey(result);
            if (cached != null) {
                return cached;
            }
            this.cache.cacheObject(result, result);
        }
        String string = result;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"result");
        return string;
    }

    private StringInterner(int size) {
        this.cache = new ConcurrentObjectCache(size, 3);
    }

    /* synthetic */ StringInterner(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            Integer n3 = INTERNER_SIZE;
            Intrinsics.checkExpressionValueIsNotNull((Object)n3, (String)"INTERNER_SIZE");
            n = n3;
        }
        this(n);
    }

    static {
        Companion = new Companion(null);
        MAX_SIZE_OF_CACHED_STRING = Integer.getInteger("exodus.util.stringInternerMaxEntrySize", 1000);
        INTERNER_SIZE = Integer.getInteger("exodus.util.stringInternerCacheSize", 47973);
        DEFAULT_INTERNER = new StringInterner(0, 1, null);
    }

    public /* synthetic */ StringInterner(int size, DefaultConstructorMarker $constructor_marker) {
        this(size);
    }

    @JvmStatic
    @Nullable
    public static final String intern(@Nullable String s) {
        return Companion.intern(s);
    }

    @JvmStatic
    @NotNull
    public static final String intern(@NotNull StringBuilder builder, int maxLen) {
        return Companion.intern(builder, maxLen);
    }

    @JvmStatic
    @NotNull
    public static final StringInterner newInterner(int size) {
        return Companion.newInterner(size);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0007J\u001c\u0010\u000b\u001a\u00020\f2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u00102\u0006\u0010\u0011\u001a\u00020\u0006H\u0007J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0018\u0010\t\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ljetbrains/exodus/util/StringInterner$Companion;", "", "()V", "DEFAULT_INTERNER", "Ljetbrains/exodus/util/StringInterner;", "INTERNER_SIZE", "", "kotlin.jvm.PlatformType", "Ljava/lang/Integer;", "MAX_SIZE_OF_CACHED_STRING", "NUMBER_OF_GENERATIONS", "intern", "", "s", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "maxLen", "newInterner", "size", "xodus-utils"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final String intern(@Nullable String s) {
            return DEFAULT_INTERNER.doIntern(s);
        }

        @JvmStatic
        @NotNull
        public final String intern(@NotNull StringBuilder builder, int maxLen) {
            Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
            StringInterner stringInterner = DEFAULT_INTERNER;
            Integer n = MAX_SIZE_OF_CACHED_STRING;
            Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"MAX_SIZE_OF_CACHED_STRING");
            int n2 = n;
            StringBuilder stringBuilder = builder;
            StringInterner stringInterner2 = stringInterner;
            int n3 = Math.min(maxLen, n2);
            return stringInterner2.doIntern(stringBuilder, n3);
        }

        @JvmStatic
        @NotNull
        public final StringInterner newInterner(int size) {
            return new StringInterner(size, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

