/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures;

import jetbrains.exodus.core.dataStructures.LongObjectCacheBase;
import jetbrains.exodus.core.dataStructures.hash.HashUtil;
import jetbrains.exodus.util.MathUtil;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\r\b\u0016\u0018\u0000  *\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0002\u001f B\u001b\b\u0007\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u001f\u0010\r\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001f\u0010\u0012\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0004H\u0016J\u0017\u0010\u0016\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0017J\u0017\u0010\u0018\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0019\u001a\u00020\u0014H\u0016J\u0017\u0010\u001a\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0017J\u0017\u0010\u001b\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0017J\u0017\u0010\u001c\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0017J\u0017\u0010\u001d\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u001e\u001a\u00020\u0014H\u0016R\u001e\u0010\u0007\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\t0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Ljetbrains/exodus/core/dataStructures/ConcurrentLongObjectCache;", "V", "Ljetbrains/exodus/core/dataStructures/LongObjectCacheBase;", "size", "", "numberOfGenerations", "(II)V", "cache", "", "Ljetbrains/exodus/core/dataStructures/ConcurrentLongObjectCache$CacheEntry;", "[Ljetbrains/exodus/core/dataStructures/ConcurrentLongObjectCache$CacheEntry;", "generationSize", "mask", "cacheObject", "key", "", "x", "(JLjava/lang/Object;)Ljava/lang/Object;", "cacheObjectLocked", "clear", "", "count", "getObject", "(J)Ljava/lang/Object;", "getObjectLocked", "lock", "remove", "removeLocked", "tryKey", "tryKeyLocked", "unlock", "CacheEntry", "Companion", "xodus-utils"})
public class ConcurrentLongObjectCache<V>
extends LongObjectCacheBase<V> {
    private final int generationSize;
    private final int mask;
    private final CacheEntry<V>[] cache;
    private final int numberOfGenerations;
    public static final int DEFAULT_NUMBER_OF_GENERATIONS = 3;
    private static final CacheEntry<?> NULL_OBJECT;
    public static final Companion Companion;

    @Override
    @Nullable
    public V tryKeyLocked(long key) {
        return this.tryKey(key);
    }

    @Override
    @Nullable
    public V getObjectLocked(long key) {
        return this.getObject(key);
    }

    @Override
    @Nullable
    public V cacheObjectLocked(long key, V x) {
        return this.cacheObject(key, x);
    }

    @Override
    @Nullable
    public V removeLocked(long key) {
        return this.remove(key);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void clear() {
        int n = 0;
        int n2 = this.cache.length;
        while (n < n2) {
            void i;
            if (NULL_OBJECT == null) {
                throw new TypeCastException("null cannot be cast to non-null type jetbrains.exodus.core.dataStructures.ConcurrentLongObjectCache.CacheEntry<V?>");
            }
            ++i;
        }
    }

    @Override
    public void lock() {
    }

    @Override
    public void unlock() {
    }

    @Override
    @Nullable
    public V cacheObject(long key, V x) {
        int cacheIndex = HashUtil.indexFor(key, this.generationSize, this.mask) * this.numberOfGenerations;
        int n = this.numberOfGenerations;
        int n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            int it = n2++;
            CacheEntry<V> entry = this.cache[cacheIndex];
            if (entry.getKey() == key) {
                this.cache[cacheIndex] = new CacheEntry<V>(key, x);
                return null;
            }
            ++cacheIndex;
        }
        this.cache[cacheIndex - 1] = new CacheEntry<V>(key, x);
        return null;
    }

    @Override
    @Nullable
    public V remove(long key) {
        int cacheIndex = HashUtil.indexFor(key, this.generationSize, this.mask) * this.numberOfGenerations;
        int n = this.numberOfGenerations;
        int n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            int it = n2++;
            CacheEntry<V> entry = this.cache[cacheIndex];
            if (entry.getKey() == key) {
                V result = entry.getValue();
                entry.setValue(null);
                return result;
            }
            ++cacheIndex;
        }
        return null;
    }

    @Override
    @Nullable
    public V tryKey(long key) {
        this.incAttempts();
        int cacheIndex = HashUtil.indexFor(key, this.generationSize, this.mask) * this.numberOfGenerations;
        CacheEntry<V> entry = this.cache[cacheIndex];
        if (entry.getKey() == key) {
            this.incHits();
            return entry.getValue();
        }
        int n = this.numberOfGenerations - 1;
        int n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            int it = n2++;
            if ((entry = this.cache[++cacheIndex]).getKey() != key) continue;
            this.incHits();
            CacheEntry<V> temp = this.cache[cacheIndex - 1];
            this.cache[cacheIndex - 1] = entry;
            this.cache[cacheIndex] = temp;
            return entry.getValue();
        }
        return null;
    }

    @Override
    @Nullable
    public V getObject(long key) {
        int cacheIndex = HashUtil.indexFor(key, this.generationSize, this.mask) * this.numberOfGenerations;
        int n = this.numberOfGenerations;
        int n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            int it = n2++;
            CacheEntry<V> entry = this.cache[cacheIndex];
            if (entry.getKey() == key) {
                return entry.getValue();
            }
            ++cacheIndex;
        }
        return null;
    }

    @Override
    public int count() {
        throw (Throwable)new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public ConcurrentLongObjectCache(int size, int numberOfGenerations) {
        super(size);
        CacheEntry[] cacheEntryArray;
        void size$iv;
        this.numberOfGenerations = numberOfGenerations;
        this.generationSize = HashUtil.getFloorPrime(size / this.numberOfGenerations);
        this.mask = (1 << MathUtil.integerLogarithm(this.generationSize)) - 1;
        int n = this.numberOfGenerations * this.generationSize;
        ConcurrentLongObjectCache concurrentLongObjectCache = this;
        CacheEntry[] result$iv = new CacheEntry[size$iv];
        int n2 = 0;
        int n3 = result$iv.length;
        while (n2 < n3) {
            CacheEntry<?> cacheEntry;
            void i$iv;
            void var7_8 = i$iv;
            void var12_10 = i$iv++;
            cacheEntryArray = result$iv;
            cacheEntryArray[var12_10] = cacheEntry = NULL_OBJECT;
        }
        cacheEntryArray = result$iv;
        concurrentLongObjectCache.cache = cacheEntryArray;
    }

    @JvmOverloads
    public /* synthetic */ ConcurrentLongObjectCache(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 8192;
        }
        if ((n3 & 2) != 0) {
            n2 = 3;
        }
        this(n, n2);
    }

    @JvmOverloads
    public ConcurrentLongObjectCache(int size) {
        this(size, 0, 2, null);
    }

    @JvmOverloads
    public ConcurrentLongObjectCache() {
        this(0, 0, 3, null);
    }

    static {
        Companion = new Companion(null);
        NULL_OBJECT = new CacheEntry<Object>(Long.MIN_VALUE, null);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\n\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\u0005\u001a\u0004\u0018\u00018\u0001X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\r\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Ljetbrains/exodus/core/dataStructures/ConcurrentLongObjectCache$CacheEntry;", "V", "", "key", "", "value", "(JLjava/lang/Object;)V", "getKey", "()J", "getValue", "()Ljava/lang/Object;", "setValue", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "xodus-utils"})
    private static final class CacheEntry<V> {
        private final long key;
        @Nullable
        private V value;

        public final long getKey() {
            return this.key;
        }

        @Nullable
        public final V getValue() {
            return this.value;
        }

        public final void setValue(@Nullable V v) {
            this.value = v;
        }

        public CacheEntry(long key, @Nullable V value) {
            this.key = key;
            this.value = value;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Ljetbrains/exodus/core/dataStructures/ConcurrentLongObjectCache$Companion;", "", "()V", "DEFAULT_NUMBER_OF_GENERATIONS", "", "NULL_OBJECT", "Ljetbrains/exodus/core/dataStructures/ConcurrentLongObjectCache$CacheEntry;", "xodus-utils"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

