/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.dataStructures;

import java.io.Closeable;
import jetbrains.exodus.core.dataStructures.CacheHitRateable;
import org.jetbrains.annotations.NotNull;

public abstract class ObjectCacheBase<K, V>
extends CacheHitRateable {
    public static final int DEFAULT_SIZE = 8192;
    public static final int MIN_SIZE = 4;
    static final CriticalSection TRIVIAL_CRITICAL_SECTION = new CriticalSection(){

        @Override
        public void close() {
        }
    };
    protected final int size;
    private final CriticalSection criticalSection = new CriticalSection(){

        @Override
        public void close() {
            ObjectCacheBase.this.unlock();
        }
    };

    protected ObjectCacheBase(int size) {
        this.size = Math.max(4, size);
    }

    public boolean isEmpty() {
        return this.count() == 0;
    }

    public int size() {
        return this.size;
    }

    public boolean containsKey(K key) {
        return this.isCached(key);
    }

    public V get(K key) {
        return this.tryKey(key);
    }

    public boolean isCached(K key) {
        return this.getObject(key) != null;
    }

    public V put(K key, V value) {
        V oldValue = this.tryKey(key);
        if (oldValue != null) {
            this.remove(key);
        }
        this.cacheObject(key, value);
        return oldValue;
    }

    public V tryKeyLocked(@NotNull K key) {
        try (CriticalSection ignored = this.newCriticalSection();){
            V v = this.tryKey(key);
            return v;
        }
    }

    public abstract void clear();

    public abstract void lock();

    public abstract void unlock();

    public abstract V cacheObject(@NotNull K var1, @NotNull V var2);

    public abstract V remove(@NotNull K var1);

    public abstract V tryKey(@NotNull K var1);

    public abstract V getObject(@NotNull K var1);

    public abstract int count();

    public static String formatHitRate(float hitRate) {
        int result = (int)(hitRate * 1000.0f);
        return String.valueOf(result / 10) + '.' + result % 10 + '%';
    }

    @Override
    public void adjustHitRate() {
        try (CriticalSection ignored = this.newCriticalSection();){
            super.adjustHitRate();
        }
    }

    public CriticalSection newCriticalSection() {
        this.lock();
        return this.criticalSection;
    }

    public static interface CriticalSection
    extends Closeable {
        @Override
        public void close();
    }
}

