/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.core.execution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jetbrains.exodus.core.dataStructures.Priority;
import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.core.execution.JobProcessorAdapter;
import jetbrains.exodus.core.execution.JobProcessorExceptionHandler;
import jetbrains.exodus.core.execution.LatchJob;
import jetbrains.exodus.core.execution.SharedTimer;
import jetbrains.exodus.core.execution.ThreadJobProcessor;
import jetbrains.exodus.core.execution.ThreadJobProcessorPool;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000 42\u00020\u0001:\u000245B!\b\u0005\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u001a\u0010\u001a\u001a\u00020\u00192\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00190\u001cJ\n\u0010\u001d\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\u001e\u001a\u00020\u0007H\u0016J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0 H\u0016J\b\u0010!\u001a\u00020\u0005H\u0016J\b\u0010\"\u001a\u00020\u0005H\u0016J\u0018\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020&H\u0014J\u0018\u0010'\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u0007H\u0014J\u0010\u0010)\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u000bH\u0014J\u0010\u0010*\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u000bH\u0014J\b\u0010+\u001a\u00020\u0019H\u0016J\u0012\u0010,\u001a\u00020\u00192\b\u0010-\u001a\u0004\u0018\u00010.H\u0016J\b\u0010/\u001a\u00020\u0019H\u0016J\b\u00100\u001a\u00020\u0019H\u0016J\u0010\u00101\u001a\u00020\u00192\u0006\u00102\u001a\u00020\u0007H\u0016J\u0010\u00103\u001a\u00020\u00192\u0006\u00102\u001a\u00020\u0007H\u0016R\u0019\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\nX\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00066"}, d2={"Ljetbrains/exodus/core/execution/MultiThreadDelegatingJobProcessor;", "Ljetbrains/exodus/core/execution/JobProcessorAdapter;", "name", "", "threadCount", "", "jobTimeout", "", "(Ljava/lang/String;IJ)V", "currentJobs", "", "Ljetbrains/exodus/core/execution/Job;", "getCurrentJobs", "()[Ljetbrains/exodus/core/execution/Job;", "isDispatcherThread", "", "()Z", "jobProcessors", "Ljetbrains/exodus/core/execution/ThreadJobProcessor;", "getJobProcessors", "()[Ljetbrains/exodus/core/execution/ThreadJobProcessor;", "[Ljetbrains/exodus/core/execution/ThreadJobProcessor;", "getThreadCount", "()I", "finish", "", "forEachSubProcessor", "action", "Lkotlin/Function1;", "getCurrentJob", "getCurrentJobStartedAt", "getPendingJobs", "", "pendingJobs", "pendingTimedJobs", "push", "job", "priority", "Ljetbrains/exodus/core/dataStructures/Priority;", "pushAt", "millis", "queueLowest", "queueLowestTimed", "resume", "setExceptionHandler", "handler", "Ljetbrains/exodus/core/execution/JobProcessorExceptionHandler;", "start", "suspend", "waitForJobs", "spinTimeout", "waitForTimedJobs", "Companion", "WatchDog", "xodus-utils"})
public abstract class MultiThreadDelegatingJobProcessor
extends JobProcessorAdapter {
    @NotNull
    private final ThreadJobProcessor[] jobProcessors;
    private static final String UNSUPPORTED_TIMED_JOBS_MESSAGE = "Timed jobs are not supported by MultiThreadDelegatingJobProcessor";
    private static final String UNSUPPORTED_SUSPEND_MESSAGE = "Suspend operation is not supported by MultiThreadDelegatingJobProcessor";
    private static final String UNSUPPORTED_RESUME_MESSAGE = "Resume operation is not supported by MultiThreadDelegatingJobProcessor";
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected final ThreadJobProcessor[] getJobProcessors() {
        return this.jobProcessors;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Job[] getCurrentJobs() {
        void $receiver$iv$iv;
        Object $receiver$iv = this.jobProcessors;
        ThreadJobProcessor[] threadJobProcessorArray = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(((ThreadJobProcessor[])$receiver$iv).length);
        void var4_4 = $receiver$iv$iv;
        int n = ((void)var4_4).length;
        for (int i = 0; i < n; ++i) {
            void processor;
            void item$iv$iv;
            void var8_8 = item$iv$iv = var4_4[i];
            Collection collection = destination$iv$iv;
            Job job = processor.getCurrentJob();
            collection.add(job);
        }
        $receiver$iv = (List)destination$iv$iv;
        Object thisCollection$iv = $receiver$iv;
        Job[] jobArray = thisCollection$iv.toArray(new Job[0]);
        if (jobArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return jobArray;
    }

    public final boolean isDispatcherThread() {
        boolean bl;
        block1: {
            ThreadJobProcessor[] $receiver$iv;
            for (ThreadJobProcessor element$iv : $receiver$iv = this.jobProcessors) {
                ThreadJobProcessor it = element$iv;
                if (!it.isCurrentThread()) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public final int getThreadCount() {
        return this.jobProcessors.length;
    }

    public final void forEachSubProcessor(@NotNull Function1<? super ThreadJobProcessor, Unit> action) {
        ThreadJobProcessor[] $receiver$iv;
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        ThreadJobProcessor[] threadJobProcessorArray = $receiver$iv = this.jobProcessors;
        int n = threadJobProcessorArray.length;
        for (int i = 0; i < n; ++i) {
            ThreadJobProcessor element$iv;
            ThreadJobProcessor processor = element$iv = threadJobProcessorArray[i];
            action.invoke((Object)processor);
        }
    }

    @Override
    public void setExceptionHandler(@Nullable JobProcessorExceptionHandler handler) {
        ThreadJobProcessor[] $receiver$iv;
        super.setExceptionHandler(handler);
        ThreadJobProcessor[] threadJobProcessorArray = $receiver$iv = this.jobProcessors;
        int n = threadJobProcessorArray.length;
        for (int i = 0; i < n; ++i) {
            ThreadJobProcessor element$iv;
            ThreadJobProcessor processor = element$iv = threadJobProcessorArray[i];
            processor.exceptionHandler = handler;
        }
    }

    @Override
    @NotNull
    protected Job pushAt(@NotNull Job job, long millis) {
        Intrinsics.checkParameterIsNotNull((Object)job, (String)"job");
        throw (Throwable)new UnsupportedOperationException(UNSUPPORTED_TIMED_JOBS_MESSAGE);
    }

    @Override
    public void waitForJobs(long spinTimeout) {
        ThreadJobProcessor[] $receiver$iv;
        ThreadJobProcessor[] threadJobProcessorArray = $receiver$iv = this.jobProcessors;
        int n = threadJobProcessorArray.length;
        for (int i = 0; i < n; ++i) {
            ThreadJobProcessor element$iv;
            ThreadJobProcessor processor = element$iv = threadJobProcessorArray[i];
            processor.waitForJobs(spinTimeout);
        }
    }

    @Override
    public void waitForTimedJobs(long spinTimeout) {
        ThreadJobProcessor[] $receiver$iv;
        ThreadJobProcessor[] threadJobProcessorArray = $receiver$iv = this.jobProcessors;
        int n = threadJobProcessorArray.length;
        for (int i = 0; i < n; ++i) {
            ThreadJobProcessor element$iv;
            ThreadJobProcessor processor = element$iv = threadJobProcessorArray[i];
            processor.waitForTimedJobs(spinTimeout);
        }
    }

    @Override
    public void suspend() {
        ThreadJobProcessor[] $receiver$iv;
        ThreadJobProcessor[] threadJobProcessorArray = $receiver$iv = this.jobProcessors;
        int n = threadJobProcessorArray.length;
        for (int i = 0; i < n; ++i) {
            ThreadJobProcessor element$iv;
            ThreadJobProcessor processor = element$iv = threadJobProcessorArray[i];
            processor.suspend();
        }
    }

    @Override
    public void resume() {
        ThreadJobProcessor[] $receiver$iv;
        ThreadJobProcessor[] threadJobProcessorArray = $receiver$iv = this.jobProcessors;
        int n = threadJobProcessorArray.length;
        for (int i = 0; i < n; ++i) {
            ThreadJobProcessor element$iv;
            ThreadJobProcessor processor = element$iv = threadJobProcessorArray[i];
            processor.resume();
        }
    }

    @Override
    protected boolean queueLowest(@NotNull Job job) {
        Intrinsics.checkParameterIsNotNull((Object)job, (String)"job");
        throw (Throwable)new UnsupportedOperationException();
    }

    @Override
    protected boolean queueLowestTimed(@NotNull Job job) {
        Intrinsics.checkParameterIsNotNull((Object)job, (String)"job");
        throw (Throwable)new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public Job getCurrentJob() {
        return null;
    }

    @Override
    public long getCurrentJobStartedAt() {
        return 0L;
    }

    @Override
    @NotNull
    public Iterable<Job> getPendingJobs() {
        return CollectionsKt.emptyList();
    }

    @Override
    public int pendingTimedJobs() {
        return 0;
    }

    @Override
    public void start() {
        if (!this.started.getAndSet(true)) {
            this.finished.set(false);
            for (ThreadJobProcessor jobProcessor : this.jobProcessors) {
                jobProcessor.start();
            }
        }
    }

    @Override
    public void finish() {
        if (this.started.get() && !this.finished.getAndSet(true)) {
            for (ThreadJobProcessor processor : this.jobProcessors) {
                processor.waitForLatchJob(new LatchJob(){

                    protected void execute() {
                        this.release();
                    }
                }, 100L);
            }
            this.started.set(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int pendingJobs() {
        void var3_3;
        void $receiver$iv;
        int initial$iv;
        ThreadJobProcessor[] threadJobProcessorArray = this.jobProcessors;
        int accumulator$iv = initial$iv = 0;
        void var4_4 = $receiver$iv;
        int n = ((void)var4_4).length;
        for (int i = 0; i < n; ++i) {
            void processor;
            void element$iv;
            void var8_8 = element$iv = var4_4[i];
            int jobs = accumulator$iv;
            accumulator$iv = jobs + processor.pendingJobs();
        }
        return (int)var3_3;
    }

    @Override
    protected boolean push(@NotNull Job job, @NotNull Priority priority) {
        Intrinsics.checkParameterIsNotNull((Object)job, (String)"job");
        Intrinsics.checkParameterIsNotNull((Object)priority, (String)"priority");
        if (this.isFinished()) {
            return false;
        }
        if (job.getProcessor() == null) {
            job.setProcessor(this);
        }
        int hc = job.hashCode();
        int processorNumber = ((hc & 0xFFFF) + (hc >>> 16)) % this.jobProcessors.length;
        return job.queue(this.jobProcessors[processorNumber], priority);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    protected MultiThreadDelegatingJobProcessor(@NotNull String name, int threadCount, long jobTimeout) {
        ThreadJobProcessor[] threadJobProcessorArray;
        void $receiver$iv$iv;
        Collection $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Iterable iterable = (Iterable)RangesKt.until((int)0, (int)threadCount);
        MultiThreadDelegatingJobProcessor multiThreadDelegatingJobProcessor = this;
        void var6_6 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void i;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            threadJobProcessorArray = destination$iv$iv;
            ThreadJobProcessor threadJobProcessor = ThreadJobProcessorPool.getOrCreateJobProcessor(name + (int)i);
            threadJobProcessorArray.add(threadJobProcessor);
        }
        threadJobProcessorArray = (List)destination$iv$iv;
        Collection thisCollection$iv = $receiver$iv = (Collection)threadJobProcessorArray;
        ThreadJobProcessor[] threadJobProcessorArray2 = thisCollection$iv.toArray(new ThreadJobProcessor[0]);
        if (threadJobProcessorArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        threadJobProcessorArray = threadJobProcessorArray2;
        multiThreadDelegatingJobProcessor.jobProcessors = threadJobProcessorArray;
        if (jobTimeout > 0L) {
            SharedTimer.registerPeriodicTaskIn(new WatchDog(jobTimeout), jobTimeout);
        }
    }

    @JvmOverloads
    public /* synthetic */ MultiThreadDelegatingJobProcessor(String string, int n, long l, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            l = 0L;
        }
        this(string, n, l);
    }

    @JvmOverloads
    protected MultiThreadDelegatingJobProcessor(@NotNull String name, int threadCount) {
        this(name, threadCount, 0L, 4, null);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ljetbrains/exodus/core/execution/MultiThreadDelegatingJobProcessor$WatchDog;", "Ljetbrains/exodus/core/execution/SharedTimer$ExpirablePeriodicTask;", "jobTimeout", "", "(Ljetbrains/exodus/core/execution/MultiThreadDelegatingJobProcessor;J)V", "isExpired", "", "()Z", "run", "", "xodus-utils"})
    private final class WatchDog
    implements SharedTimer.ExpirablePeriodicTask {
        private final long jobTimeout;

        @Override
        public boolean isExpired() {
            return MultiThreadDelegatingJobProcessor.this.isFinished();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void run() {
            long currentTime = System.currentTimeMillis();
            int n = 0;
            int n2 = MultiThreadDelegatingJobProcessor.this.getJobProcessors().length;
            while (n < n2) {
                void i;
                ThreadJobProcessor processor = MultiThreadDelegatingJobProcessor.this.getJobProcessors()[i];
                Job currentJob = processor.getCurrentJob();
                if (currentJob != null && currentJob.getStartedAt() + this.jobTimeout < currentTime) {
                    ThreadJobProcessor newProcessor = ThreadJobProcessorPool.getOrCreateJobProcessor(processor.getName() + '+');
                    ThreadJobProcessor[] threadJobProcessorArray = MultiThreadDelegatingJobProcessor.this.getJobProcessors();
                    ThreadJobProcessor threadJobProcessor = newProcessor;
                    Intrinsics.checkExpressionValueIsNotNull((Object)threadJobProcessor, (String)"newProcessor");
                    threadJobProcessorArray[i] = threadJobProcessor;
                    newProcessor.exceptionHandler = MultiThreadDelegatingJobProcessor.this.exceptionHandler;
                    processor.moveTo(newProcessor);
                    processor.queueFinish();
                }
                ++i;
            }
        }

        public WatchDog(long jobTimeout) {
            this.jobTimeout = jobTimeout;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Ljetbrains/exodus/core/execution/MultiThreadDelegatingJobProcessor$Companion;", "", "()V", "UNSUPPORTED_RESUME_MESSAGE", "", "UNSUPPORTED_SUSPEND_MESSAGE", "UNSUPPORTED_TIMED_JOBS_MESSAGE", "xodus-utils"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

