/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.util;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class LightByteArrayOutputStream
extends ByteArrayOutputStream {
    public LightByteArrayOutputStream() {
    }

    public LightByteArrayOutputStream(int size) {
        super(size);
    }

    public int write(@NotNull ByteBuffer buffer) {
        int bufferLen = buffer.remaining();
        if (bufferLen > 0) {
            int newCount = this.count + bufferLen;
            if (newCount > this.buf.length) {
                this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, newCount));
            }
            buffer.get(this.buf, this.count, bufferLen);
            this.count = newCount;
        }
        return bufferLen;
    }

    @Override
    public byte[] toByteArray() {
        return this.buf;
    }

    @Override
    public int size() {
        return this.count;
    }

    public void setSize(int size) {
        this.count = size;
    }
}

