/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.cluster;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Map;
import org.jetlinks.core.cluster.ClusterCache;
import org.jetlinks.core.cluster.ClusterManager;
import org.jetlinks.core.cluster.ClusterTopic;
import org.reactivestreams.Publisher;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ClusterLocalCache<K, V>
implements ClusterCache<K, V> {
    private final Cache<K, Object> cache;
    private final ClusterCache<K, V> clusterCache;
    private final ClusterTopic<K> clearTopic;
    public static final Object NULL_VALUE = new Object();

    public ClusterLocalCache(String name, ClusterManager clusterManager) {
        this(name, clusterManager, clusterManager.getCache(name), CacheBuilder.newBuilder().build());
    }

    public ClusterLocalCache(String name, ClusterManager clusterManager, ClusterCache<K, V> clusterCache, Cache<K, Object> localCache) {
        this.clusterCache = clusterCache;
        this.cache = localCache;
        this.clearTopic = clusterManager.getTopic("_local_cache_modify:".concat(name));
    }

    public void clearLocalCache(K key) {
        if (key != null) {
            this.cache.invalidate(key);
        }
    }

    public Mono<V> get(K key) {
        if (key == null) {
            return Mono.empty();
        }
        return Mono.justOrEmpty((Object)this.cache.getIfPresent(key)).switchIfEmpty(Mono.defer(() -> this.clusterCache.get(key).switchIfEmpty(Mono.fromRunnable(() -> this.cache.put(key, NULL_VALUE))).doOnNext(v -> this.cache.put(key, v)))).filter(v -> v != NULL_VALUE).map(v -> v);
    }

    public Flux<Map.Entry<K, V>> get(Collection<K> key) {
        if (key == null) {
            return Flux.empty();
        }
        return Flux.defer(() -> {
            ImmutableMap all = this.cache.getAllPresent((Iterable)key);
            if (key.size() == all.size()) {
                return Flux.fromIterable((Iterable)all.entrySet()).map(x$0 -> new SimpleEntry(x$0));
            }
            return this.clusterCache.get(key).doOnNext(kvEntry -> {
                Object k = kvEntry.getKey();
                Object v = kvEntry.getValue();
                if (v == null) {
                    this.cache.put(k, NULL_VALUE);
                } else {
                    this.cache.put(k, v);
                }
            });
        });
    }

    public Mono<Boolean> put(K key, V value) {
        if (value == null || key == null) {
            return Mono.just((Object)true);
        }
        return Mono.defer(() -> {
            this.cache.invalidate(key);
            return this.clusterCache.put(key, value).flatMap(r -> this.clearTopic.publish((Publisher)Mono.just((Object)key))).thenReturn((Object)true);
        });
    }

    public Mono<Boolean> putIfAbsent(K key, V value) {
        if (value == null || key == null) {
            return Mono.just((Object)true);
        }
        return Mono.defer(() -> {
            this.cache.invalidate(key);
            return this.clusterCache.putIfAbsent(key, value).flatMap(r -> this.clearTopic.publish((Publisher)Mono.just((Object)key)).thenReturn(r));
        });
    }

    public Mono<Boolean> remove(K key) {
        if (key == null) {
            return Mono.just((Object)true);
        }
        return Mono.defer(() -> {
            this.cache.invalidate(key);
            return this.clusterCache.remove(key).flatMap(r -> this.clearTopic.publish((Publisher)Mono.just((Object)key))).thenReturn((Object)true);
        });
    }

    public Mono<V> getAndRemove(K key) {
        if (key == null) {
            return Mono.empty();
        }
        return Mono.defer(() -> {
            this.cache.invalidate(key);
            return this.clusterCache.getAndRemove(key).flatMap(r -> this.clearTopic.publish((Publisher)Mono.just((Object)key)).thenReturn(r));
        });
    }

    public Mono<Boolean> remove(Collection<K> key) {
        if (key == null) {
            return Mono.just((Object)true);
        }
        return Mono.defer(() -> {
            this.cache.invalidateAll((Iterable)key);
            return this.clusterCache.remove(key).flatMap(r -> this.clearTopic.publish((Publisher)Flux.fromIterable((Iterable)key))).thenReturn((Object)true);
        });
    }

    public Mono<Boolean> containsKey(K key) {
        if (key == null) {
            return Mono.just((Object)true);
        }
        return Mono.defer(() -> {
            if (this.clusterCache.containsKey(key) != null) {
                return Mono.just((Object)true);
            }
            return this.clusterCache.containsKey(key);
        });
    }

    public Flux<K> keys() {
        return this.clusterCache.keys();
    }

    public Flux<V> values() {
        return this.clusterCache.values();
    }

    public Mono<Boolean> putAll(Map<? extends K, ? extends V> multi) {
        if (CollectionUtils.isEmpty(multi)) {
            return Mono.just((Object)true);
        }
        return Mono.defer(() -> {
            this.cache.putAll(multi);
            return this.clusterCache.putAll(multi).flatMap(r -> this.clearTopic.publish((Publisher)Flux.fromIterable(multi.keySet()))).thenReturn((Object)true);
        });
    }

    public Mono<Integer> size() {
        return this.clusterCache.size();
    }

    public Flux<Map.Entry<K, V>> entries() {
        return this.clusterCache.entries();
    }

    public Mono<Void> clear() {
        return Mono.defer(() -> {
            this.cache.invalidateAll();
            return this.clusterCache.clear();
        });
    }

    class SimpleEntry
    implements Map.Entry<K, V> {
        private Map.Entry<K, Object> entry;

        @Override
        public K getKey() {
            return this.entry.getKey();
        }

        @Override
        public V getValue() {
            Object v = this.entry.getValue();
            return v == NULL_VALUE ? null : v;
        }

        @Override
        public V setValue(V value) {
            Object old = this.getValue();
            this.entry.setValue(value);
            return old;
        }

        @ConstructorProperties(value={"entry"})
        public SimpleEntry(Map.Entry<K, Object> entry) {
            this.entry = entry;
        }
    }
}

