/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.official.types;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.Optional;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.types.ArrayType;
import org.jetlinks.core.metadata.types.DataTypes;
import org.jetlinks.supports.official.JetLinksDataTypeCodecs;
import org.jetlinks.supports.official.types.AbstractDataTypeCodec;

public class JetLinksArrayCodec
extends AbstractDataTypeCodec<ArrayType> {
    public String getTypeId() {
        return "array";
    }

    @Override
    public ArrayType decode(ArrayType type, Map<String, Object> config) {
        super.decode(type, config);
        JSONObject jsonObject = new JSONObject(config);
        Optional.ofNullable(jsonObject.get((Object)"elementType")).map(v -> {
            if (v instanceof JSONObject) {
                return (JSONObject)v;
            }
            JSONObject eleType = new JSONObject();
            eleType.put("type", v);
            return eleType;
        }).map(eleType -> {
            DataType dataType = (DataType)DataTypes.lookup((String)eleType.getString("type")).get();
            JetLinksDataTypeCodecs.getCodec(dataType.getId()).ifPresent(codec -> codec.decode(dataType, (Map)eleType));
            return dataType;
        }).ifPresent(arg_0 -> ((ArrayType)type).setElementType(arg_0));
        return type;
    }

    @Override
    protected void doEncode(Map<String, Object> encoded, ArrayType type) {
        super.doEncode(encoded, type);
        JetLinksDataTypeCodecs.getCodec(type.getId()).ifPresent(codec -> encoded.put("elementType", codec.encode(type.getElementType())));
    }
}

