/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.cluster;

import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.validation.constraints.NotNull;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.device.DeviceStateChecker;
import reactor.core.publisher.Mono;

public class CompositeDeviceStateChecker
implements DeviceStateChecker {
    private final List<DeviceStateChecker> checkerList = new CopyOnWriteArrayList<DeviceStateChecker>();

    public void addDeviceStateChecker(DeviceStateChecker checker) {
        this.checkerList.add(checker);
        this.checkerList.sort(Comparator.comparing(DeviceStateChecker::order));
    }

    @NotNull
    public Mono<Byte> checkState(@NotNull DeviceOperator device) {
        if (this.checkerList.isEmpty()) {
            return Mono.empty();
        }
        if (this.checkerList.size() == 1) {
            return this.checkerList.get(0).checkState(device);
        }
        Mono checker = this.checkerList.get(0).checkState(device);
        int len = this.checkerList.size();
        for (int i = 1; i < len; ++i) {
            checker = checker.switchIfEmpty(this.checkerList.get(i).checkState(device));
        }
        return checker;
    }
}

