/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.cluster.redis;

import java.math.BigDecimal;
import org.jetlinks.core.cluster.ClusterCounter;
import org.springframework.data.redis.core.ReactiveRedisOperations;
import reactor.core.publisher.Mono;

public class RedisClusterCounter
implements ClusterCounter {
    private final ReactiveRedisOperations<String, String> redis;
    private final String redisKey;

    public Mono<Double> increment(double delta) {
        return this.redis.opsForValue().increment((Object)this.redisKey, delta);
    }

    public Mono<Double> get() {
        return this.redis.opsForValue().get((Object)this.redisKey).map(BigDecimal::new).map(Number::doubleValue).defaultIfEmpty((Object)0.0);
    }

    public Mono<Double> set(double value) {
        return this.getAndSet(value);
    }

    public Mono<Double> setAndGet(double value) {
        return this.redis.opsForValue().set((Object)this.redisKey, (Object)String.valueOf(value)).thenReturn((Object)value);
    }

    public Mono<Double> getAndSet(double value) {
        return this.redis.opsForValue().getAndSet((Object)this.redisKey, (Object)String.valueOf(value)).map(BigDecimal::new).map(Number::doubleValue).defaultIfEmpty((Object)0.0);
    }

    public RedisClusterCounter(ReactiveRedisOperations<String, String> redis, String redisKey) {
        this.redis = redis;
        this.redisKey = redisKey;
    }
}

