/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.ipc;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;
import org.jetlinks.core.Payload;
import org.jetlinks.core.codec.Decoder;
import org.jetlinks.core.codec.Encoder;
import org.jetlinks.supports.ipc.ResponseType;

class IpcResponse<T> {
    private static final ResponseType[] types = ResponseType.values();
    private final ResponseType type;
    private final int seq;
    private final int messageId;
    private final T result;
    private final Throwable error;

    boolean hasResult() {
        return this.result != null;
    }

    boolean hasError() {
        return this.error != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> IpcResponse<T> decode(Payload payload, Decoder<T> decoder, Decoder<Throwable> errorDecoder) {
        ByteBuf body = payload.getBody();
        try {
            byte type = body.readByte();
            if (type < 0 || type >= types.length) {
                throw new IllegalStateException("unknown request type " + type);
            }
            ResponseType requestType = types[type];
            int seq = body.readInt();
            int messageId = body.readInt();
            boolean hasBody = body.readByte() == 1;
            Object requestBody = null;
            Throwable error = null;
            if (hasBody && requestType != ResponseType.error) {
                requestBody = decoder.decode(payload);
            }
            if (requestType == ResponseType.error) {
                error = (Throwable)errorDecoder.decode(payload);
            }
            IpcResponse<Object> ipcResponse = IpcResponse.of(requestType, seq, messageId, requestBody, error);
            return ipcResponse;
        }
        finally {
            ReferenceCountUtil.safeRelease((Object)payload);
        }
    }

    public ByteBuf toByteBuf(Encoder<T> encoder, Encoder<Throwable> errorEncoder) {
        ByteBuf ref;
        ByteBuf body;
        ByteBuf buf;
        if (this.result == null && this.error == null) {
            buf = ByteBufAllocator.DEFAULT.buffer(9);
            ref = body = Unpooled.EMPTY_BUFFER;
        } else {
            Payload payload = this.result == null ? errorEncoder.encode((Object)this.error) : encoder.encode(this.result);
            body = payload.getBody();
            buf = ByteBufAllocator.DEFAULT.buffer(9 + body.writerIndex());
            ref = payload;
        }
        buf.writeByte(this.type.ordinal());
        buf.writeInt(this.seq);
        buf.writeInt(this.messageId);
        buf.writeByte(this.result == null && this.error == null ? 0 : 1);
        buf.writeBytes(body);
        ReferenceCountUtil.safeRelease((Object)ref);
        return buf;
    }

    public String toString() {
        return "IpcResponse{type=" + (Object)((Object)this.type) + ", seq=" + this.seq + ", messageId=" + this.messageId + '}';
    }

    private IpcResponse(ResponseType type, int seq, int messageId, T result, Throwable error) {
        this.type = type;
        this.seq = seq;
        this.messageId = messageId;
        this.result = result;
        this.error = error;
    }

    public static <T> IpcResponse<T> of(ResponseType type, int seq, int messageId, T result, Throwable error) {
        return new IpcResponse<T>(type, seq, messageId, result, error);
    }

    public ResponseType getType() {
        return this.type;
    }

    public int getSeq() {
        return this.seq;
    }

    public int getMessageId() {
        return this.messageId;
    }

    public T getResult() {
        return this.result;
    }

    public Throwable getError() {
        return this.error;
    }
}

